/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.yusp.bsp.method.impl;

import cn.com.yusys.yusp.bsp.toolkit.common.ByteTools;
import cn.com.yusys.yusp.bsp.toolkit.common.StringTools;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DateMethodTool {
    private static final Logger logger = LoggerFactory.getLogger(DateMethodTool.class);
    private static final char CHAR_BLANK = ' ';
    private static final String CHAR_D = "d";
    private static final String CHAR_H = "H";
    private static final String CHAR_H_LOW = "h";
    private static final String CHAR_LOW_M = "m";
    private static final String CHAR_M = "M";
    private static final String CHAR_S = "s";
    private static final char CHAR_TWO = '2';
    private static final String CHAR_Y = "y";
    private static final String CHAR_YY = "yy";
    private static final char CHAR_ZERO = '0';
    private static final String D_T_F = "DateTimeFormat";
    private static final String R_D_F = "RDateFormat";
    private static final String R_D_T_F = "RDateTimeFormat";
    private static final String R_T_F = "RTimeFormat";
    private static final String S_D_F = "SDateFormat";
    private static final String S_D_T_F = "SDateTimeFormat";
    private static final String S_T_F = "STimeFormat";

    public static String formatDate(Object srcDataObject, Map<String, Object> paras, Map<String, Object> context) {
        byte[] srcData = ByteTools.getBytes(srcDataObject);
        String rdf = StringTools.getString(paras.get(R_D_F));
        if (StringTools.isEmpty(rdf) || srcData.length != ByteTools.getBytes(rdf).length) {
            logger.warn("Format date function @ incorrect date parameter, original value returned");
            return new String(srcData);
        }
        int bsy = rdf.indexOf(CHAR_Y);
        int bey = rdf.lastIndexOf(CHAR_Y);
        int bsm = rdf.indexOf(CHAR_M);
        int bem = rdf.lastIndexOf(CHAR_M);
        int bsd = rdf.indexOf(CHAR_D);
        int bed = rdf.lastIndexOf(CHAR_D);
        int bynum = bey - bsy + 1;
        int bmnum = bem - bsm + 1;
        int bdnum = bed - bsd + 1;
        String sdf = StringTools.getString(paras.get(S_D_F));
        if (StringTools.isEmpty(sdf)) {
            logger.warn("Format date function @ incorrect date parameter, original value returned");
            return new String(srcData);
        }
        byte[] bt = sdf.getBytes();
        int sy = sdf.indexOf(CHAR_Y);
        int ey = sdf.lastIndexOf(CHAR_Y);
        int sm = sdf.indexOf(CHAR_M);
        int em = sdf.lastIndexOf(CHAR_M);
        int sd = sdf.indexOf(CHAR_D);
        int ed = sdf.lastIndexOf(CHAR_D);
        int ynum = ey - sy + 1;
        int mnum = em - sm + 1;
        int dnum = ed - sd + 1;
        int base2Num = 2;
        int base4Num = 4;
        if (sy != -1 && bsy != -1) {
            if (ynum == bynum) {
                int i = sy;
                for (int j = bsy; i <= ey && j <= bey; ++i, ++j) {
                    bt[i] = srcData[j];
                }
            } else if (ynum == bynum + base2Num) {
                bt[sy] = 50;
                bt[sy + 1] = 48;
                int i = sy + base2Num;
                for (int j = bsy; i <= ey && j <= bey; ++i, ++j) {
                    bt[i] = srcData[j];
                }
            } else if (ynum == bynum - base2Num) {
                int i = sy;
                for (int j = bsy + base2Num; i <= ey && j <= bey; ++i, ++j) {
                    bt[i] = srcData[j];
                }
            } else {
                System.err.println("incorrect date parameter!");
            }
        } else if (sy != -1 && bsy == -1) {
            SimpleDateFormat date = new SimpleDateFormat(CHAR_YY);
            byte[] ybt = date.format(new Date()).getBytes();
            if (ynum == base2Num) {
                bt[sy] = ybt[0];
                bt[sy + 1] = ybt[1];
            } else if (ynum == base4Num) {
                bt[sy] = 50;
                bt[sy + 1] = 48;
                bt[sy + 2] = ybt[0];
                bt[sy + 3] = ybt[1];
            } else {
                System.err.println("incorrect date parameter");
            }
        }
        return DateMethodTool.getString(srcData, bsm, bem, bsd, bed, bmnum, bdnum, bt, sm, em, sd, ed, mnum, dnum);
    }

    private static String getString(byte[] srcData, int bsm, int bem, int bsd, int bed, int bmnum, int bdnum, byte[] bt, int sm, int em, int sd, int ed, int mnum, int dnum) {
        int j;
        int i;
        if (sm != -1) {
            if (mnum == bmnum) {
                i = sm;
                for (j = bsm; i <= em && j <= bem; ++i, ++j) {
                    bt[i] = srcData[j];
                }
            } else if (mnum == bmnum + 1) {
                bt[sm] = 48;
                bt[sm + 1] = srcData[bem];
            } else if (mnum == bmnum - 1) {
                bt[sm] = srcData[bem];
            } else {
                System.err.println("incorrect date parameter");
            }
        }
        if (sd != -1) {
            if (dnum == bdnum) {
                i = sd;
                for (j = bsd; i <= ed && j <= bed; ++i, ++j) {
                    bt[i] = srcData[j];
                }
            } else if (dnum == bdnum + 1) {
                bt[sd] = 48;
                bt[sd + 1] = srcData[bed];
            } else if (dnum == bdnum - 1) {
                bt[sd] = srcData[bed];
            } else {
                System.err.println("incorrect date parameter");
            }
        }
        return new String(bt);
    }

    public static String formatDateTime(Object srcDataObject, Map<String, Object> paras, Map<String, Object> context) {
        byte[] srcData = ByteTools.getBytes(srcDataObject);
        String rdtf = StringTools.getString(paras.get(R_D_T_F));
        String sdtf = StringTools.getString(paras.get(S_D_T_F));
        if (StringTools.isEmpty(rdtf) || StringTools.isEmpty(sdtf)) {
            logger.warn("Format date and time function @ format parameter is not configured, original value returned");
            return new String(srcData);
        }
        String rdf = rdtf.substring(0, rdtf.indexOf(32));
        String rtf = rdtf.substring(rdtf.indexOf(32)).trim();
        String sdf = sdtf.substring(0, sdtf.indexOf(32));
        String stf = sdtf.substring(sdtf.indexOf(32)).trim();
        paras.put(R_D_F, rdf);
        paras.put(S_D_F, sdf);
        paras.put(R_T_F, rtf);
        paras.put(S_T_F, stf);
        String srcDateTime = new String(srcData);
        String srcDate = srcDateTime.substring(0, srcDateTime.indexOf(32));
        String srcTime = srcDateTime.substring(srcDateTime.indexOf(32)).trim();
        return DateMethodTool.formatDate(srcDate.getBytes(), paras, context) + ' ' + DateMethodTool.formatTime(srcTime.getBytes(), paras, context);
    }

    public static String formatTime(Object srcDataObject, Map<String, Object> paras, Map<String, Object> context) {
        int j;
        int i;
        byte[] srcData = ByteTools.getBytes(srcDataObject);
        String rtf = StringTools.getString(paras.get(R_T_F));
        if (StringTools.isEmpty(rtf) || srcData.length != rtf.getBytes().length) {
            logger.warn("Format time function @ incorrect time parameter, original value returned");
            return new String(srcData);
        }
        int bsh = rtf.indexOf(CHAR_H);
        int beh = rtf.lastIndexOf(CHAR_H);
        int bsm = rtf.indexOf(CHAR_LOW_M);
        int bem = rtf.lastIndexOf(CHAR_LOW_M);
        int bss = rtf.indexOf(CHAR_S);
        int bes = rtf.lastIndexOf(CHAR_S);
        String stf = StringTools.getString(paras.get(S_T_F));
        if (StringTools.isEmpty(stf)) {
            logger.warn("Format time function @ incorrect time parameter, original value returned");
            return new String(srcData);
        }
        byte[] bt = stf.getBytes();
        int ash = stf.indexOf(CHAR_H);
        int aeh = stf.lastIndexOf(CHAR_H);
        int asm = stf.indexOf(CHAR_LOW_M);
        int aem = stf.lastIndexOf(CHAR_LOW_M);
        int ass = stf.indexOf(CHAR_S);
        int aes = stf.lastIndexOf(CHAR_S);
        if (bsh == -1 || ash == -1) {
            bsh = rtf.indexOf(CHAR_H_LOW);
            beh = rtf.lastIndexOf(CHAR_H_LOW);
            ash = stf.indexOf(CHAR_H_LOW);
            aeh = stf.lastIndexOf(CHAR_H_LOW);
        }
        if (ash != -1) {
            i = ash;
            for (j = bsh; i <= aeh && j <= beh; ++i, ++j) {
                bt[i] = srcData[j];
            }
        }
        if (asm != -1) {
            i = asm;
            for (j = bsm; i <= aem && j <= bem; ++i, ++j) {
                bt[i] = srcData[j];
            }
        }
        if (ass != -1) {
            i = ass;
            for (j = bss; i <= aes && j <= bes; ++i, ++j) {
                bt[i] = srcData[j];
            }
        }
        return new String(bt);
    }

    public static String recSystemDate(Object srcDataObject, Map<String, Object> paras, Map<String, Object> context) {
        String srcData = StringTools.getString(srcDataObject);
        String dtf = StringTools.getString(paras.get(D_T_F));
        if (StringTools.isEmpty(dtf)) {
            logger.warn("Get system date and time function @ format parameter is not configured, original value returned");
            return srcData;
        }
        SimpleDateFormat date = new SimpleDateFormat(dtf);
        return date.format(new Date());
    }

    public static void main(String[] args) {
        HashMap<String, Object> paras = new HashMap<String, Object>(16);
        byte[] b = "20110413      205522".getBytes();
        paras.put(R_D_T_F, "yyyyMMdd    hhmmss");
        paras.put(S_D_T_F, "yyyy-MM-dd    hh:mm:ss");
        String s1 = DateMethodTool.formatDateTime(b, paras, null);
        System.out.println(s1);
    }
}

