/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.yusp.bsp.method;

import cn.com.yusys.yusp.bsp.method.MethodException;
import cn.com.yusys.yusp.bsp.method.MethodRegistry;
import cn.com.yusys.yusp.bsp.toolkit.common.StringTools;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import net.sf.cglib.reflect.FastClass;
import net.sf.cglib.reflect.FastMethod;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FastMethodInvoker {
    private static final Logger logger = LoggerFactory.getLogger(FastMethodInvoker.class);
    private static final FastMethodInvoker INSTANCE = new FastMethodInvoker();
    private final Map<String, FastClass> clazzCache = new ConcurrentHashMap<String, FastClass>();
    private final Map<String, Object> clazzInstanceCache = new ConcurrentHashMap<String, Object>();
    private final Map<String, FastMethod> methodCache = new ConcurrentHashMap<String, FastMethod>();

    public static FastMethodInvoker getInstance() {
        return INSTANCE;
    }

    public void clear() {
        this.methodCache.clear();
        this.clazzCache.clear();
        this.clazzInstanceCache.clear();
    }

    public void clear(String clazzNameValue) {
        this.clazzCache.remove(clazzNameValue);
        this.clazzInstanceCache.remove(clazzNameValue);
        Set<String> methodKeys = this.methodCache.keySet();
        String[] methodKeysStr = new String[methodKeys.size()];
        methodKeys.toArray(methodKeysStr);
        for (String methodKey : methodKeysStr) {
            if (!methodKey.contains(clazzNameValue)) continue;
            this.methodCache.remove(methodKey);
            logger.info("Clear method cache\uff1a{}", (Object)methodKey);
        }
    }

    private FastClass getClazz(String domain, String clazzName) throws Exception {
        String clazzNameValue = null;
        if (StringTools.isEmpty(domain) || "plat".equals(domain)) {
            clazzNameValue = "plat:" + clazzName;
        } else if ("bank".equals(domain)) {
            clazzNameValue = domain + ":" + clazzName;
        }
        FastClass clazz = this.clazzCache.get(clazzNameValue);
        if (clazz == null) {
            if (logger.isDebugEnabled()) {
                logger.debug("Method call @ load class:" + clazzNameValue);
            }
            Class<?> clazz0 = MethodRegistry.getMethod(domain, clazzName);
            clazz = FastClass.create(clazz0);
            this.clazzCache.put(clazzNameValue, clazz);
            this.clazzInstanceCache.put(clazzNameValue, clazz.newInstance());
        }
        return clazz;
    }

    private FastMethod getMethod(FastClass clazz, String clazzName, String methodName) throws Exception {
        String key = clazzName + '@' + methodName;
        FastMethod method = this.methodCache.get(key);
        if (method == null) {
            Method[] m;
            if (logger.isDebugEnabled()) {
                logger.debug("Method calling component@ load method:" + methodName);
            }
            Class<?>[] type = null;
            for (Method value : m = clazz.getJavaClass().getMethods()) {
                if (!value.getName().equals(methodName)) continue;
                type = value.getParameterTypes();
                break;
            }
            if (type == null) {
                throw new Exception("Method does not exist:" + key);
            }
            method = clazz.getMethod(methodName, type);
            this.methodCache.put(key, method);
        }
        return method;
    }

    public Object invokeFormatMethod(String clazzNameValue, String methodNameValue, Map<String, String> paras, Object data, Map<String, Object> context) throws Exception {
        String clazzName = null;
        String domain = null;
        int index = clazzNameValue.indexOf(":");
        if (index != -1) {
            domain = clazzNameValue.substring(0, index);
            clazzNameValue = clazzName = clazzNameValue.substring(index + 1);
        }
        if (StringTools.isEmpty(domain) || "plat".equals(domain)) {
            clazzName = "plat:" + clazzNameValue;
        } else if ("bank".equals(domain)) {
            clazzName = domain + ":" + clazzNameValue;
        }
        FastClass fastClazz = this.getClazz(domain, clazzNameValue);
        FastMethod fastMethod = this.getMethod(fastClazz, clazzName, methodNameValue);
        Object instance = this.clazzInstanceCache.get(clazzName);
        try {
            return fastMethod.invoke(instance, new Object[]{data, paras, context});
        }
        catch (InvocationTargetException e) {
            if (e.getTargetException() instanceof ClassCastException) {
                throw new Exception("The input parameter type of method [" + clazzNameValue + "." + methodNameValue + "] is incorrect", e.getTargetException());
            }
            if (e.getTargetException() instanceof MethodException) {
                throw new Exception(e.getTargetException());
            }
            throw e;
        }
    }
}

