/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.yusp.bsp.dataformat.impl;

import cn.com.yusys.yusp.bsp.dataformat.exe.AbstractExecutor;
import cn.com.yusys.yusp.bsp.resources.core.BspTools;
import cn.com.yusys.yusp.bsp.resources.mfd.CacheHead;
import cn.com.yusys.yusp.bsp.schema.dataformat.def.Group;
import cn.com.yusys.yusp.bsp.schema.dataformat.def.Head;
import cn.com.yusys.yusp.bsp.schema.dataformat.def.Item;
import cn.com.yusys.yusp.bsp.schema.dataformat.def.While;
import cn.com.yusys.yusp.bsp.toolkit.common.ByteTools;
import cn.com.yusys.yusp.bsp.toolkit.common.StringTools;
import cn.com.yusys.yusp.bsp.toolkit.el.ognl.OgnlTools;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class MapExecutor
extends AbstractExecutor<Map<String, Object>> {
    private static final String DATA_FORMAT_NAME = "MAP";
    private static final String DATA_FORMAT_USE_ROOT = "rootVar";
    private static final String ITEM_ATRIBUTE_VARNAME = "varName";
    private static final String ITEM_ATRIBUTE_HAVE_KEY = "haveKey";
    private Map<String, Object> root;
    private List<String> packPath;
    private Object current;
    private int parentIsList = 0;
    private boolean useRoot;

    @Override
    public String getExecutorName() {
        return DATA_FORMAT_NAME;
    }

    @Override
    public boolean isDataMessage() {
        return false;
    }

    @Override
    public void init(Map<String, String> property) {
        this.useRoot = "true".equals(property.get(DATA_FORMAT_USE_ROOT));
        if (DATAFORMAT_PACK == this.getPackType()) {
            this.current = this.root = new LinkedHashMap<String, Object>();
            this.orderMap = true;
            this.packPath = new ArrayList<String>();
        }
    }

    @Override
    public void inputData(Map<String, Object> inputData) throws Exception {
        if (this.useRoot) {
            super.inputData(this.getRootContext());
        } else {
            if (inputData == null) {
                throw new Exception("The required parameter [unpacking variable] is null");
            }
            super.inputData(inputData);
        }
    }

    @Override
    public Map<String, Object> outputInner() {
        if (this.useRoot) {
            this.getCurrentContext().putAll(this.root);
            return null;
        }
        return this.root;
    }

    @Override
    public void packItem(Item field, byte[] data, Map<String, String> paras) throws Exception {
        String varname = paras.get(ITEM_ATRIBUTE_VARNAME);
        if (StringTools.isEmpty(varname)) {
            varname = field.getName();
        }
        Object value = this.itemTypeConvert(field.getType(), data);
        if (this.current instanceof Map) {
            ((Map)this.current).put(varname, value);
        } else if (this.current instanceof List) {
            ((List)this.current).add(value);
        }
    }

    @Override
    protected void packGroup(Group group) throws Exception {
        Head head = group.getHead();
        if (!(head instanceof CacheHead)) {
            throw new Exception("The header of group is illegal");
        }
        CacheHead cacheHead = (CacheHead)head;
        String name = cacheHead.getParas().get(ITEM_ATRIBUTE_VARNAME);
        if (StringTools.isEmpty(name)) {
            name = group.getName();
        }
        this.parentIsList = 0;
        Object old = this.current;
        Map<String, Object> map = this.newMap();
        if (this.current instanceof Map) {
            Object o = ((Map)this.current).get(name);
            if (o instanceof Map) {
                ArrayList<Map<String, Object>> list = new ArrayList<Map<String, Object>>();
                list.add((Map)o);
                list.add(map);
                ((Map)this.current).put(name, list);
            } else if (o instanceof List) {
                ((List)o).add(map);
            } else {
                ((Map)this.current).put(name, map);
            }
        } else if (this.current instanceof List) {
            Map<String, Object> tempMap = this.newMap();
            tempMap.put(name, map);
            ((List)this.current).add(tempMap);
        }
        this.current = map;
        this.packPath.add(name);
        this.packBody(group.getBody());
        this.parentIsList = 0;
        this.current = old;
        this.packPath.remove(this.packPath.size() - 1);
    }

    @Override
    protected void packWhile(While whileObject) throws Exception {
        Head head = whileObject.getHead();
        if (!(head instanceof CacheHead)) {
            throw new Exception("The header of group is illegal");
        }
        CacheHead cacheHead = (CacheHead)head;
        String name = cacheHead.getParas().get(ITEM_ATRIBUTE_VARNAME);
        boolean haveKey = "true".equals(cacheHead.getParas().get(ITEM_ATRIBUTE_HAVE_KEY));
        if (StringTools.isEmpty(name)) {
            name = whileObject.getName();
        }
        Object old = this.current;
        String varname = whileObject.getVar();
        int nCount = this.parseLoopCount(whileObject);
        List<Object> list = new ArrayList(nCount);
        if (this.current instanceof Map) {
            Object o = ((Map)this.current).get(name);
            if (o == null) {
                ((Map)this.current).put(name, list);
            } else if (o instanceof Map) {
                list.add(o);
                ((Map)this.current).put(name, list);
            } else if (o instanceof List) {
                list = (List)o;
            } else {
                ((Map)this.current).put(name, list);
            }
        } else if (this.current instanceof List) {
            ((List)this.current).add(list);
        }
        int oldParentIsList = this.parentIsList;
        for (int i = 0; i < nCount; ++i) {
            Object o;
            if (haveKey) {
                o = this.newMap();
                list.add(o);
            } else {
                o = list;
            }
            if (oldParentIsList == 0 || oldParentIsList == 1) {
                this.packPath.add(name + "[" + i + "]");
            } else {
                this.packPath.add(this.packPath.remove(this.packPath.size() - 1) + "[" + i + "]");
            }
            this.current = o;
            Integer tmpI = i;
            this.rootContext.put(varname, tmpI);
            this.parentIsList = haveKey ? 1 : 2;
            this.packBody(whileObject.getBody());
            if (oldParentIsList == 0 || oldParentIsList == 1) {
                this.packPath.remove(this.packPath.size() - 1);
                continue;
            }
            String pp = this.packPath.remove(this.packPath.size() - 1);
            int index = pp.lastIndexOf("[");
            this.packPath.add(pp.substring(0, index));
        }
        int base2Num = 2;
        if (haveKey && oldParentIsList == base2Num) {
            String pp = this.packPath.remove(this.packPath.size() - 1);
            int index = pp.lastIndexOf("[");
            int n = Integer.parseInt(pp.substring(index + 1, pp.length() - 1)) + 1;
            this.packPath.add(pp.substring(0, index) + "[" + n + "]");
        }
        this.rootContext.remove(varname);
        this.current = old;
        this.parentIsList = oldParentIsList;
    }

    @Override
    public byte[] unPackItem(Item field, Map<String, String> paras) throws Exception {
        String varName = paras.get(ITEM_ATRIBUTE_VARNAME);
        if (StringTools.isEmpty(varName)) {
            varName = this.getRealItemPath(field);
        }
        varName = OgnlTools.parseXmlPath(varName, this.getRootContext());
        Object obj = OgnlTools.getValue(varName, (Map)this.getInputData());
        return ByteTools.getBytes(obj, this.getEncoding());
    }

    @Override
    protected void unPackWhile(While whileObject) throws Exception {
        String name = whileObject.getName();
        String varname = whileObject.getVar();
        int nCount = this.parseLoopCount(whileObject, (Map)this.getInputData());
        this.logger.debug("{} @ Loop to split messages, loop name: {}, times: {}, variable: {}", new Object[]{this.getExecutorName(), name, nCount, varname});
        super.unPackWhile(nCount, name, varname, whileObject);
    }

    @Override
    protected boolean supportItemMust() {
        return true;
    }

    @Override
    public boolean isUnpackEmptyCheck() {
        return false;
    }

    @Override
    public int getSearchIndex() {
        return -1;
    }

    @Override
    public void log(int logLevel, Item item, String value, Map<String, String> params, String appendStr) throws Exception {
        String packTypeStr;
        String itemPath = OgnlTools.parseXmlPath(this.getRealItemPath(item), this.rootContext);
        if (this.packType == DATAFORMAT_PACK) {
            packTypeStr = "Pack";
            String varname = params.get(ITEM_ATRIBUTE_VARNAME);
            if (StringTools.isEmpty(varname)) {
                varname = item.getName();
            }
            if (this.current instanceof Map) {
                itemPath = itemPath + "<" + this.getPackPath(this.packPath, varname, -1) + ">";
            } else if (this.current instanceof List) {
                itemPath = itemPath + "<" + this.getPackPath(this.packPath, varname, ((List)this.current).size()) + ">";
            }
            if (value == null) {
                String logStr = "{} @ {}:{}, ignore {}";
                Object[] logParams = new String[]{this.getExecutorName(), packTypeStr, itemPath, appendStr};
                this.log(logLevel, logStr, logParams);
                return;
            }
        } else {
            packTypeStr = "Unpack";
        }
        if (item.isPwd() && value != null) {
            this.setHiddenInfo(true);
            value = BspTools.pwdTransfer(value);
        }
        String logStr = "{} @ {}:{}=[{}] {}";
        Object[] logParams = new String[]{this.getExecutorName(), packTypeStr, itemPath, value, appendStr};
        this.log(logLevel, logStr, logParams);
    }

    private String getPackPath(List<String> packPath, String itemName, int listIndex) {
        StringBuilder buffer = new StringBuilder();
        for (String str : packPath) {
            buffer.append(".");
            buffer.append(str);
        }
        if (listIndex == -1) {
            buffer.append(".");
            buffer.append(itemName);
        } else {
            int base2Num = 2;
            if (this.parentIsList == base2Num) {
                int index = buffer.lastIndexOf("[");
                char basePointChar = '.';
                if (buffer.charAt(index - 1) != basePointChar) {
                    buffer.delete(index, buffer.length());
                }
            }
            buffer.append("[").append(listIndex).append("]");
        }
        return buffer.substring(1);
    }

    @Override
    public String getMessageType() {
        return "Map";
    }
}

