/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.yusp.bsp.dataformat.impl;

import cn.com.yusys.yusp.bsp.dataformat.exe.AbstractExecutor;
import cn.com.yusys.yusp.bsp.resources.mfd.CacheHead;
import cn.com.yusys.yusp.bsp.schema.dataformat.def.Group;
import cn.com.yusys.yusp.bsp.schema.dataformat.def.Head;
import cn.com.yusys.yusp.bsp.schema.dataformat.def.Item;
import cn.com.yusys.yusp.bsp.schema.dataformat.def.While;
import cn.com.yusys.yusp.bsp.toolkit.common.ByteTools;
import cn.com.yusys.yusp.bsp.toolkit.common.StringTools;
import cn.com.yusys.yusp.bsp.toolkit.el.ognl.OgnlTools;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class JsonExecutor
extends AbstractExecutor<byte[]> {
    private static final String DATA_FORMAT_NAME = "JSON";
    private static final String ITEM_ATTRIBUTE_DATA_TYPE = "type";
    private static final String ITEM_ATTRIBUTE_DATA_VARIABLE = "varName";
    private static final String DATA_TYPE_STRING = "string";
    private static final String DATA_TYPE_BOOLEAN = "boolean";
    private static final String DATA_TYPE_NUMBER = "number";
    private static final String DATA_TYPE_INT = "int";
    private Object output;
    private Map<String, Object> jsonData;
    private static ObjectMapper objectMapper;

    private static ObjectMapper getObjectMapper() {
        if (objectMapper == null) {
            objectMapper = new ObjectMapper();
            objectMapper.enable(new JsonParser.Feature[]{JsonParser.Feature.ALLOW_COMMENTS});
            objectMapper.enable(DeserializationFeature.USE_BIG_DECIMAL_FOR_FLOATS);
            objectMapper.configure(JsonParser.Feature.ALLOW_MISSING_VALUES, true);
        }
        return objectMapper;
    }

    @Override
    public String getExecutorName() {
        return DATA_FORMAT_NAME;
    }

    @Override
    public void init(Map<String, String> property) {
        if (this.getPackType() == DATAFORMAT_PACK) {
            this.orderMap = true;
        }
    }

    @Override
    public void inputData(byte[] inputData) throws Exception {
        super.inputData(inputData);
        try {
            String input = StringTools.getString(inputData, this.getEncoding());
            Object object = this.parserJson(input);
            Map<String, Object> map = null;
            if (object instanceof Map) {
                map = (Map<String, Object>)object;
            } else if (object instanceof List) {
                map = this.newMap();
                List list = (List)object;
                if (StringTools.isEmpty(this.getAutoUnpackVar())) {
                    map.put("_BLANK", list);
                } else {
                    map.put(this.getAutoUnpackVar(), list);
                    this.setAutoUnpackVar(null);
                }
            }
            if (this.getGlobalParseMethod() != null) {
                this.parserDataByGlobalMethod(map, 2, this.getGlobalParseMethod());
            }
            this.jsonData = map;
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new Exception("[" + this.getExecutorName() + "] Unpacking exception", e);
        }
    }

    @Override
    public byte[] outputInner() throws Exception {
        if (this.output == null) {
            this.output = this.newMap();
        }
        return JsonExecutor.getObjectMapper().writeValueAsString(this.output).getBytes(this.getEncoding());
    }

    @Override
    public void packItem(Item item, byte[] data, Map<String, String> paras) throws Exception {
        Object result;
        String dataType;
        String dataVar = paras.get(ITEM_ATTRIBUTE_DATA_VARIABLE);
        if (StringTools.isEmpty(dataVar)) {
            dataVar = item.getName();
        }
        if (DATA_TYPE_BOOLEAN.equals(dataType = paras.get(ITEM_ATTRIBUTE_DATA_TYPE))) {
            String ret = StringTools.getString(data, this.getEncoding());
            result = Boolean.parseBoolean(ret);
        } else if (DATA_TYPE_STRING.equals(dataType)) {
            result = StringTools.getString(data, this.getEncoding());
        } else if (DATA_TYPE_NUMBER.equals(dataType)) {
            String strData = StringTools.getString(data, this.getEncoding());
            try {
                result = new BigDecimal(strData);
            }
            catch (NumberFormatException ne) {
                result = this.parserJson(strData);
            }
        } else {
            throw new Exception("Packet data type [" + dataType + "] is not supported");
        }
        String falseFlag = "false";
        if (!falseFlag.equals(paras.get("haveKey"))) {
            if (this.output instanceof List) {
                this.add2SubWhileMap(dataVar, result, (List)this.output, item.getPath());
            } else {
                if (this.output == null) {
                    this.output = this.newMap();
                }
                ((Map)this.output).put(dataVar, result);
            }
        } else {
            if (this.output instanceof Map) {
                throw new Exception("Group field [" + dataVar + "] The value of the attribute [preserving structure of the package] must be [true]");
            }
            ((List)this.output).add(result);
        }
    }

    @Override
    public void packGroup(Group group) throws Exception {
        Object oldOutput = this.output == null ? this.newMap() : this.output;
        this.output = this.newMap();
        String nameFlag = "_EMPTY_GROUP";
        String name = group.getName();
        if (!nameFlag.equals(name)) {
            this.packBody(group.getBody());
            if (oldOutput instanceof List) {
                this.add2SubWhileMap(name, this.output, (List)oldOutput, group.getPath());
            } else {
                ((Map)oldOutput).put(name, this.output);
            }
        } else if (oldOutput instanceof List) {
            ((List)oldOutput).add(new HashMap(16));
        }
        this.output = oldOutput;
    }

    @Override
    public void packWhile(While whileObject) throws Exception {
        String name = whileObject.getName();
        String varname = whileObject.getVar();
        Head head = whileObject.getHead();
        if (!(head instanceof CacheHead)) {
            throw new Exception("Invalid loop header");
        }
        CacheHead cacheHead = (CacheHead)head;
        String strHaveKey = cacheHead.getParas().get("haveKey");
        boolean haveKey = !"false".equals(strHaveKey);
        Object oldOutput = this.output;
        this.output = new ArrayList();
        int nCount = this.parseLoopCount(whileObject);
        for (int i = 0; i < nCount; ++i) {
            this.rootContext.put(varname, i);
            this.packBody(whileObject.getBody());
        }
        this.rootContext.remove(varname);
        if (haveKey) {
            if (oldOutput == null) {
                oldOutput = new HashMap(16);
            }
            if (oldOutput instanceof List) {
                this.add2SubWhileMap(name, this.output, (List)oldOutput, whileObject.getPath());
            } else {
                ((Map)oldOutput).put(name, this.output);
            }
        } else if (oldOutput == null) {
            oldOutput = this.output;
        } else if (oldOutput instanceof List) {
            ((List)oldOutput).add(this.output);
        } else {
            oldOutput = this.output;
        }
        this.output = oldOutput;
    }

    private void add2SubWhileMap(String dataVar, Object result, List<Object> parent, String path) {
        Map<String, Object> subMap;
        String strIndex = path.substring(path.lastIndexOf("[") + 1, path.lastIndexOf("]"));
        Integer index = (Integer)this.rootContext.get(strIndex);
        if (parent.isEmpty() || index > parent.size() - 1) {
            subMap = new HashMap<String, Object>(16);
            parent.add(index, subMap);
        } else {
            subMap = (Map)parent.get(index);
            if (subMap == null) {
                subMap = new HashMap(16);
                parent.add(index, subMap);
            }
        }
        subMap.put(dataVar, result);
    }

    @Override
    public byte[] autoPack(Map<String, Object> map) throws Exception {
        this.autoPackMap(map, new ArrayList<String>());
        return JsonExecutor.getObjectMapper().writeValueAsBytes(map);
    }

    @Override
    protected byte[] autoPack(List<Object> list) throws Exception {
        this.autoPackList("_BLANK", list, new ArrayList<String>());
        return JsonExecutor.getObjectMapper().writeValueAsBytes(list);
    }

    private void autoPackMap(Map<String, Object> map, List<String> path) throws Exception {
        for (Map.Entry<String, Object> entry : map.entrySet()) {
            String key = entry.getKey();
            Object obj = entry.getValue();
            if (obj instanceof Map) {
                path.add(key);
                this.autoPackMap((Map)obj, path);
                path.remove(path.size() - 1);
                continue;
            }
            if (obj instanceof List) {
                this.autoPackList(key, (List)obj, path);
                continue;
            }
            obj = this.autoPackValue(key, obj, path);
            map.put(key, obj);
        }
    }

    private void autoPackList(String key, List<Object> list, List<String> path) throws Exception {
        for (int i = 0; i < list.size(); ++i) {
            Object obj = list.get(i);
            path.add(key + "[" + i + "]");
            if (obj instanceof Map) {
                this.autoPackMap((Map)obj, path);
            } else if (obj instanceof List) {
                this.autoPackList("", (List)obj, path);
            } else {
                obj = this.autoPackValue(null, obj, path);
                list.set(i, obj);
            }
            path.remove(path.size() - 1);
        }
    }

    private Object autoPackValue(String key, Object value, List<String> path) throws Exception {
        if (value instanceof byte[] || value instanceof String) {
            byte[] valueByte = ByteTools.getBytes(value, this.getEncoding());
            if (this.isFilterEmpty() && valueByte.length == 0) {
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug("{} @ Auto packaging: {}, filter empty string", new Object[]{this.getExecutorName(), this.pathToString(path, key)});
                }
                return null;
            }
            return this.invokeMethods(key, value, path, valueByte);
        }
        if (value instanceof Integer) {
            byte[] valueByte = ByteTools.getBytes(value);
            return Integer.valueOf(this.invokeMethods(key, value, path, valueByte));
        }
        if (value instanceof Boolean) {
            byte[] valueByte = (Boolean)value != false ? "true".getBytes() : "false".getBytes();
            return Boolean.valueOf(this.invokeMethods(key, value, path, valueByte));
        }
        if (value != null) {
            byte[] valueByte = ByteTools.getBytes(value, this.getEncoding());
            return this.invokeMethods(key, value, path, valueByte);
        }
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("{} @ Auto packaging: {},ignore(value is null)", new Object[]{this.getExecutorName(), this.pathToString(path, key)});
        }
        return null;
    }

    private String invokeMethods(String key, Object value, List<String> path, byte[] valueByte) throws Exception {
        String ret = StringTools.getString(this.invokeMethods(this.getGlobalBuildMethod(), valueByte, 1), this.getEncoding());
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("{} @ Auto packaging: {}=[{}]", new Object[]{this.getExecutorName(), this.pathToString(path, key), StringTools.getString(value, this.getEncoding())});
        }
        return ret;
    }

    @Override
    public Map<String, Object> autoUnpack() {
        return this.jsonData;
    }

    @Override
    public byte[] unPackItem(Item item, Map<String, String> paras) throws Exception {
        String dataVar = paras.get(ITEM_ATTRIBUTE_DATA_VARIABLE);
        if (StringTools.isEmpty(dataVar)) {
            throw new Exception("The data variable of [" + item.getName() + "] in [" + this.getExecutorName() + "] field is empty.");
        }
        dataVar = OgnlTools.parseXmlPath(dataVar, this.getRootContext());
        Object obj = OgnlTools.getValue(dataVar, this.jsonData);
        return ByteTools.getBytes(obj, this.getEncoding());
    }

    @Override
    protected void unPackWhile(While whileObject) throws Exception {
        String name = whileObject.getName();
        String varname = whileObject.getVar();
        int nCount = this.parseLoopCount(whileObject, this.jsonData);
        this.logger.debug("{} @ Loop unpacking message, loop name: {}, times: {}, variable: {}", new Object[]{this.getExecutorName(), name, nCount, varname});
        super.unPackWhile(nCount, name, varname, whileObject);
    }

    @Override
    protected boolean supportItemMust() {
        return true;
    }

    private Object parserJson(String input) throws Exception {
        char startChart = input.trim().charAt(0);
        if (startChart == '{') {
            return JsonExecutor.getObjectMapper().readValue(input, Map.class);
        }
        if (startChart == '[') {
            return JsonExecutor.getObjectMapper().readValue(input, List.class);
        }
        throw new Exception("Illegal JSON");
    }

    public Object getOutput() {
        return this.output;
    }

    public void setOutput(Object output) {
        this.output = output;
    }

    @Override
    public int getSearchIndex() {
        return -1;
    }
}

