/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.yusp.bsp.dataformat.impl;

import cn.com.yusys.yusp.bsp.dataformat.impl.BitmapExecutor;
import cn.com.yusys.yusp.bsp.dataformat.impl.ExecutorHelper;
import cn.com.yusys.yusp.bsp.toolkit.common.ByteTools;
import cn.com.yusys.yusp.bsp.toolkit.common.StringTools;
import cn.com.yusys.yusp.bsp.toolkit.el.ognl.OgnlTools;
import java.io.ByteArrayOutputStream;
import java.util.Collections;
import java.util.LinkedList;
import java.util.Map;

public class ISO8583Executor
extends BitmapExecutor {
    private static final String DATA_FORMAT_NAME = "ISO8583";
    private static final String DATA_FORMAT_HEAD_TYPE = "headType";
    private static final String DATA_FORMAT_HEAD_LENGTH = "headLength";
    private static final String DATA_FORMAT_HEAD_VARIABLE = "headVariable";
    private String headType;
    private byte[] headValue = null;
    private int headLength = 0;
    private String headVariable;

    @Override
    public String getExecutorName() {
        return DATA_FORMAT_NAME;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void init(Map<String, String> property) throws Exception {
        this.headType = property.get(DATA_FORMAT_HEAD_TYPE);
        String str = property.get(DATA_FORMAT_HEAD_LENGTH);
        if (!StringTools.isEmpty(str)) {
            this.headLength = Integer.parseInt(str);
        }
        this.headVariable = property.get(DATA_FORMAT_HEAD_VARIABLE);
        if (this.headLength != 0 && StringTools.isEmpty(this.headVariable)) {
            throw new Exception("When the [" + this.getExecutorName() + "] packet header length is not 0, please fill in the packet header variable");
        }
        this.bitmapType = property.get("bitmapType");
        this.defDataFillStyle = property.get("defFillStyle");
        this.defDataFiller = ExecutorHelper.parserFiller(property.get("defFiller"));
        this.searchIndex = 0;
        this.bitmapMinPos = 2;
        this.bitmapMaxPos = 128;
        if (this.getPackType() == DATAFORMAT_PACK) {
            if (this.headLength > 0) {
                this.headValue = ByteTools.getBytes(OgnlTools.getValue(this.headVariable, this.getRootContext()), this.getEncoding());
                if (this.headValue == null) {
                    throw new Exception(this.getExecutorName() + " @ The value of packet header variable [" + this.headVariable + "] is null");
                }
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug("{} @ Packaging, packet header: {}=[{}]", new Object[]{DATA_FORMAT_NAME, this.headVariable, new String(this.headValue)});
                }
                if ("bcd".equals(this.headType)) {
                    if (this.headLength != this.headValue.length && this.headLength - 1 != this.headValue.length) throw new Exception("The length [" + this.headLength + "] of [" + this.getExecutorName() + "] packet header configured is not equal to the actual length [" + this.headValue.length + "].");
                    this.headValue = ByteTools.asc2Bcd(this.headValue, 0, true);
                } else if (this.headLength != this.headValue.length) {
                    throw new Exception("The length [" + this.headLength + "] of [" + this.getExecutorName() + "] packet header configured is not equal to the actual length [" + this.headValue.length + "].");
                }
            }
            this.output = new ByteArrayOutputStream();
            this.bitmap = new int[128];
        } else {
            this.listPosition = new LinkedList();
        }
        super.setIso8583(true);
    }

    @Override
    public void inputData(byte[] inputData) throws Exception {
        this.setInputData(inputData);
        this.dataLength = inputData.length;
        this.searchIndex = 0;
        if (this.headLength != 0) {
            byte[] headValue;
            boolean isBcd = false;
            int tempLen = this.headLength;
            if ("bcd".equals(this.headType)) {
                isBcd = true;
                tempLen = (this.headLength + 1) / 2;
                headValue = new byte[tempLen];
            } else {
                headValue = new byte[tempLen];
            }
            System.arraycopy(this.getInputData(), this.searchIndex, headValue, 0, headValue.length);
            if (isBcd) {
                headValue = ByteTools.bcd2Asc(headValue, 0, true, this.headLength);
            }
            this.searchIndex += tempLen;
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("{} @ Unpacking, packet header: {}=[{}]", new Object[]{DATA_FORMAT_NAME, this.headVariable, new String(headValue)});
            }
            OgnlTools.setValue(this.headVariable, headValue, this.getCurrentContext());
        }
        this.unpackBitmap();
    }

    @Override
    public byte[] outputData() throws Exception {
        byte[] data = this.output.toByteArray();
        this.output.reset();
        if (this.headValue != null) {
            this.output.write(this.headValue);
        }
        this.packBitmap();
        this.output.write(data);
        data = this.output.toByteArray();
        this.output.reset();
        return data;
    }

    private void unpackBitmap() {
        byte[] bitmap1 = new byte[]{((byte[])this.getInputData())[this.searchIndex]};
        if ("ascii".equals(this.bitmapType)) {
            int intBitmap1 = bitmap1[0] - 48;
            int base7Num = 7;
            int bitMapLen = intBitmap1 > base7Num ? 32 : 16;
            byte[] bitmap = new byte[bitMapLen];
            System.arraycopy(this.getInputData(), this.searchIndex, bitmap, 0, bitMapLen);
            this.searchIndex += bitMapLen;
            this.parserAsciiBitmap(bitmap, 4);
        } else if ("bcd".equals(this.bitmapType)) {
            int intBitmap1 = bitmap1[0] < 0 ? bitmap1[0] + 256 : bitmap1[0];
            int base127Num = 127;
            int bitMapLen = intBitmap1 > base127Num ? 16 : 8;
            byte[] bitmap = new byte[bitMapLen];
            System.arraycopy(this.getInputData(), this.searchIndex, bitmap, 0, bitMapLen);
            this.searchIndex += bitMapLen;
            this.parserBcdBitmap(bitmap, 8);
        } else if ("binaryAscii".equals(this.bitmapType)) {
            int intBitmap1 = bitmap1[0] - 48;
            int bitMapLen = intBitmap1 == 0 ? 64 : 128;
            byte[] bitmap = new byte[bitMapLen];
            System.arraycopy(this.getInputData(), this.searchIndex, bitmap, 0, bitMapLen);
            this.searchIndex += bitMapLen;
            this.parserAsciiBitmap(bitmap, 1);
        } else if ("binaryBcd".equals(this.bitmapType)) {
            byte intBitmap1 = bitmap1[0];
            byte base2Num = 2;
            int bitMapLen = intBitmap1 < base2Num ? 32 : 64;
            byte[] bitmap = new byte[bitMapLen];
            System.arraycopy(this.getInputData(), this.searchIndex, bitmap, 0, bitMapLen);
            this.searchIndex += bitMapLen;
            this.parserBcdBitmap(bitmap, 2);
        }
        Collections.sort(this.listPosition);
        if ((Integer)this.listPosition.getFirst() == 1) {
            this.listPosition.removeFirst();
        }
    }

    @Override
    protected boolean supportItemMust() {
        return true;
    }
}

