/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.yusp.bsp.dataformat.impl;

import cn.com.yusys.yusp.bsp.dataformat.exe.AbstractExecutor;
import cn.com.yusys.yusp.bsp.schema.dataformat.def.Item;
import cn.com.yusys.yusp.bsp.toolkit.common.ByteTools;
import cn.com.yusys.yusp.bsp.toolkit.common.StringTools;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.util.Map;

public class FieldLenExecutor
extends AbstractExecutor<byte[]> {
    private static final String DATA_FORMAT_NAME = "Domain fixed length";
    private static final String ITEM_FIELD_TYPE = "fieldType";
    private static final String ITEM_FIELD_LEN = "fieldLen";
    private static final String FILL_CHAR = "fillChar";
    private static final String IS_INCLUDE = "isInclude";
    private static final String ITEM_DATA_MAX_LEN = "maxLen";
    private static final String FIELD_TYPE_BYTE = "byte";
    private static final String FIELD_TYPE_SHORT = "short";
    private static final String FIELD_TYPE_INT = "int";
    private static final String FIELD_TYPE_STRING = "string";
    private int searchIndex;
    private int dataLength;
    private DataInputStream inputStream;
    private ByteArrayOutputStream byteOut;
    private DataOutputStream outputStream;

    @Override
    public String getExecutorName() {
        return DATA_FORMAT_NAME;
    }

    @Override
    public void init(Map<String, String> property) {
        if (this.getPackType() == DATAFORMAT_PACK) {
            this.byteOut = new ByteArrayOutputStream(256);
            this.outputStream = new DataOutputStream(this.byteOut);
        }
    }

    @Override
    public void inputData(byte[] inputData) throws Exception {
        super.inputData(inputData);
        this.dataLength = inputData.length;
        this.inputStream = new DataInputStream(new ByteArrayInputStream(inputData));
        this.searchIndex = 0;
    }

    @Override
    public byte[] outputInner() throws Exception {
        byte[] data = this.byteOut.toByteArray();
        this.byteOut.close();
        this.outputStream.close();
        return data;
    }

    @Override
    public void packItem(Item item, byte[] data, Map<String, String> paras) throws Exception {
        String itemFieldType = paras.get(ITEM_FIELD_TYPE);
        String itemFillChar = paras.get(FILL_CHAR);
        String isIn = paras.get(IS_INCLUDE);
        byte fillByte = 48;
        if (StringTools.isEmpty(itemFieldType)) {
            throw new Exception("The length field type of [Domain fixed length]field[" + item.getName() + "] cannot be empty");
        }
        if (!StringTools.isEmpty(itemFillChar)) {
            byte[] sign = StringTools.escString2Byte(itemFillChar);
            fillByte = sign[0];
        }
        int maxLen = -1;
        String str = paras.get(ITEM_DATA_MAX_LEN);
        if (!StringTools.isEmpty(str)) {
            try {
                maxLen = Integer.parseInt(str);
            }
            catch (Exception e) {
                throw new Exception(this.getExecutorName() + " @ Exception converting maximum data length [" + str + "] of field [" + this.getRealItemPath(item) + "] to number", e);
            }
        }
        if (maxLen > 0 && data.length > maxLen) {
            throw new Exception(this.getExecutorName() + " @ The actual data length [" + data.length + "] of field [" + this.getRealItemPath(item) + "] exceeds the maximum data length [" + maxLen + "]");
        }
        int len = data.length;
        switch (itemFieldType) {
            case "string": {
                byte[] byteLen;
                int itemFieldLen = 0;
                str = paras.get(ITEM_FIELD_LEN);
                if (!StringTools.isEmpty(str)) {
                    try {
                        itemFieldLen = Integer.parseInt(str);
                    }
                    catch (Exception e) {
                        throw new Exception("[" + this.getExecutorName() + "] The length field type of field [" + item.getName() + "] is character type. The length field length needs to be filled in.");
                    }
                }
                if ("true".equals(isIn)) {
                    len += itemFieldLen;
                }
                if ((byteLen = ByteTools.int2DecAsciiByte(len)).length > itemFieldLen) {
                    throw new Exception("[" + this.getExecutorName() + "] Length field data of field [" + this.getRealItemPath(item) + "] actual length [" + byteLen.length + "] is greater than the configured length [" + itemFieldLen + "]");
                }
                byteLen = ByteTools.leftPad(byteLen, itemFieldLen, fillByte);
                this.outputStream.write(byteLen);
                break;
            }
            case "byte": {
                if (len > 127) {
                    throw new Exception("The length [" + len + "] of the [" + item.getName() + "] field value in [" + DATA_FORMAT_NAME + "] has exceeded the length of the length field [" + 127 + "]");
                }
                this.outputStream.writeByte(len);
                break;
            }
            case "short": {
                if (len > Short.MAX_VALUE) {
                    throw new Exception("The length [" + len + "] of the [" + item.getName() + "] field value in [" + DATA_FORMAT_NAME + "] has exceeded the length of the length field [" + Short.MAX_VALUE + "]");
                }
                this.outputStream.writeShort(len);
                break;
            }
            case "int": {
                this.outputStream.writeInt(len);
                break;
            }
        }
        this.outputStream.write(data);
    }

    @Override
    public byte[] unPackItem(Item field, Map<String, String> paras) throws Exception {
        if (this.searchIndex >= this.dataLength) {
            return new byte[0];
        }
        String itemFieldType = paras.get(ITEM_FIELD_TYPE);
        String isIn = paras.get(IS_INCLUDE);
        if (StringTools.isEmpty(itemFieldType)) {
            throw new Exception("The length field type of [Domain fixed length] filed [" + field.getName() + "] cannot be empty");
        }
        int dataLen = 0;
        switch (itemFieldType) {
            case "string": {
                int itemFieldLen;
                String str = paras.get(ITEM_FIELD_LEN);
                if (StringTools.isEmpty(str)) {
                    throw new Exception(this.getExecutorName() + " @ Length field length of field [" + this.getRealItemPath(field) + "] is empty");
                }
                try {
                    itemFieldLen = Integer.parseInt(str);
                }
                catch (Exception e) {
                    throw new Exception(this.getExecutorName() + " @ The length field type of field [" + this.getRealItemPath(field) + "] is character type. The length field length needs to be filled in.");
                }
                if (itemFieldLen == 0) {
                    return new byte[0];
                }
                byte[] byteField = new byte[itemFieldLen];
                this.inputStream.readFully(byteField);
                this.searchIndex += itemFieldLen;
                String itemFillChar = paras.get(FILL_CHAR);
                byte fillByte = 48;
                if (!StringTools.isEmpty(itemFillChar)) {
                    byte[] sign = StringTools.escString2Byte(itemFillChar);
                    fillByte = sign[0];
                }
                if ((byteField = ByteTools.stripStart(byteField, fillByte)).length == 0) {
                    return new byte[0];
                }
                dataLen = ByteTools.decAsciiByte2int(byteField);
                if (!"true".equals(isIn)) break;
                dataLen -= itemFieldLen;
                break;
            }
            case "byte": {
                dataLen = this.inputStream.read();
                ++this.searchIndex;
                break;
            }
            case "short": {
                dataLen = this.inputStream.readShort();
                this.searchIndex += 2;
                break;
            }
            case "int": {
                dataLen = this.inputStream.readInt();
                this.searchIndex += 4;
                break;
            }
        }
        byte[] data = new byte[dataLen];
        this.inputStream.readFully(data);
        this.searchIndex += dataLen;
        if (this.searchIndex >= this.dataLength) {
            this.setDataFormatEnd();
        }
        return data;
    }

    @Override
    public int getSearchIndex() {
        if (this.searchIndex >= this.dataLength) {
            return -1;
        }
        return this.searchIndex;
    }
}

