/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.yusp.bsp.dataformat.exe;

import cn.com.yusys.yusp.bsp.dataformat.DataFormatException;
import cn.com.yusys.yusp.bsp.dataformat.DataFormatRegistry;
import cn.com.yusys.yusp.bsp.dataformat.exe.IDataFormatExecutor;
import cn.com.yusys.yusp.bsp.dataformat.impl.LenExecutor;
import cn.com.yusys.yusp.bsp.method.FastMethodInvoker;
import cn.com.yusys.yusp.bsp.resources.core.BspTools;
import cn.com.yusys.yusp.bsp.resources.mfd.CacheBody;
import cn.com.yusys.yusp.bsp.resources.mfd.CacheBuild;
import cn.com.yusys.yusp.bsp.resources.mfd.CacheHead;
import cn.com.yusys.yusp.bsp.resources.mfd.CacheMethod;
import cn.com.yusys.yusp.bsp.resources.mfd.CacheParse;
import cn.com.yusys.yusp.bsp.schema.dataformat.def.Body;
import cn.com.yusys.yusp.bsp.schema.dataformat.def.BodyItem;
import cn.com.yusys.yusp.bsp.schema.dataformat.def.Build;
import cn.com.yusys.yusp.bsp.schema.dataformat.def.Case;
import cn.com.yusys.yusp.bsp.schema.dataformat.def.DataFormat;
import cn.com.yusys.yusp.bsp.schema.dataformat.def.DataFormatRef;
import cn.com.yusys.yusp.bsp.schema.dataformat.def.Default;
import cn.com.yusys.yusp.bsp.schema.dataformat.def.Group;
import cn.com.yusys.yusp.bsp.schema.dataformat.def.Head;
import cn.com.yusys.yusp.bsp.schema.dataformat.def.Item;
import cn.com.yusys.yusp.bsp.schema.dataformat.def.ItemRef;
import cn.com.yusys.yusp.bsp.schema.dataformat.def.Method;
import cn.com.yusys.yusp.bsp.schema.dataformat.def.Parse;
import cn.com.yusys.yusp.bsp.schema.dataformat.def.Property;
import cn.com.yusys.yusp.bsp.schema.dataformat.def.SubRefDataFormat;
import cn.com.yusys.yusp.bsp.schema.dataformat.def.Switch;
import cn.com.yusys.yusp.bsp.schema.dataformat.def.While;
import cn.com.yusys.yusp.bsp.toolkit.common.ByteTools;
import cn.com.yusys.yusp.bsp.toolkit.common.DataFormatTools;
import cn.com.yusys.yusp.bsp.toolkit.common.FileTools;
import cn.com.yusys.yusp.bsp.toolkit.common.StringTools;
import cn.com.yusys.yusp.bsp.toolkit.el.ognl.OgnlTools;
import java.io.UnsupportedEncodingException;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractExecutor<S>
implements IDataFormatExecutor<S> {
    public static int DATAFORMAT_PACK = 0;
    public static int DATAFORMAT_UNPACK = 1;
    private String encoding;
    private boolean autoUnpack;
    private boolean autoPack;
    private String currentPath;
    private String currentPathUnpack;
    private String modulePath;
    protected boolean parseExpr = true;
    protected boolean orderMap = false;
    protected static final String PROPERTY_FILTER_EMPTY = "filterEmpty";
    protected static final String PROPERTY_AUTO_PACK = "autoPack";
    protected static final String PROPERTY_AUTO_PACK_VAR = "autoPackVar";
    protected static final String PROPERTY_AUTO_UNPACK = "isAuto";
    protected static final String PROPERTY_AUTO_UNPACK_VAR = "varName";
    protected static final String PROPERTY_AUTO_UNPACK_SAVE = "autoSave";
    protected static final String ITEM_ATTRIBUTE_HAVE_KEY = "haveKey";
    public static final String MESSAGE_TYPE_BYTEBUFFER = "ByteBuffer";
    public static final String MESSAGE_TYPE_MAP = "Map";
    public static final String MESSAGE_TYPE_OTHERS = "Others";
    private String autoPackVar;
    private String autoUnpackVar;
    private boolean autoUnpackSave;
    private boolean filterEmpty = false;
    private boolean dataMessage = true;
    private boolean unpackEmptyCheck = true;
    private boolean subObjectType = false;
    protected Method[] globalBuildMethod;
    private Method[] globalParseMethod;
    protected Map<String, Object> currentContext;
    protected boolean end = false;
    private boolean hiddenInfo;
    private S inputData;
    protected Logger logger = LoggerFactory.getLogger(this.getClass());
    protected Logger loggerWarn = LoggerFactory.getLogger(AbstractExecutor.class);
    protected int packType;
    protected Map<String, Object> rootContext;
    protected static final String V_TRUE = "true";
    protected static final String V_FALSE = "false";
    protected static final String V_DOT = ".";
    protected static final String V_STRING = "string";
    protected static final String V_HEX_STRING = "hexString";
    protected static final String V_BRACKET_LEFT = "[";
    protected static final String V_BRACKET_RIGHT = "]";
    protected static final String V_EMPTY = "";
    protected static final String V_0_STRING = "0";
    protected static final String V_SLASH = "/";
    protected static final String V_REGEX_COMMA = "[,]";
    protected static final byte V_0_BYTE = 0;
    protected static final String V_LT_STRING = "<";
    protected static final String V_GT_STRING = ">";
    protected static final String V_PACK_STRING = "Pack";
    protected static final String V_UNPACK_STRING = "Unpack";
    protected static final String HEXPREFIX_UPPER = "0X";
    protected static final String HEXPREFIX_LOWER = "0x";

    public Object itemTypeConvert(String dataType, byte[] byField) throws Exception {
        String strField = StringTools.getString(byField);
        if (strField == null) {
            return null;
        }
        switch (dataType) {
            case "String": {
                return StringTools.getString(byField, this.getEncoding());
            }
            case "Bytes": {
                return byField;
            }
            case "Integer": {
                try {
                    return new Integer(strField.trim());
                }
                catch (NumberFormatException e) {
                    throw new Exception("Convert data [" + strField.trim() + "] to integer exception", e);
                }
            }
            case "Long": {
                try {
                    return new Long(strField.trim());
                }
                catch (NumberFormatException e) {
                    throw new Exception("Convert data [" + strField.trim() + "] to long integer exception", e);
                }
            }
            case "Float": {
                try {
                    return new Float(strField.trim());
                }
                catch (NumberFormatException e) {
                    throw new Exception("Convert data [" + strField.trim() + "] to float exception", e);
                }
            }
            case "Double": {
                try {
                    return new Double(strField.trim());
                }
                catch (NumberFormatException e) {
                    throw new Exception("Convert data [" + strField.trim() + "] to Double exception", e);
                }
            }
            case "BigDecimal": {
                try {
                    return new BigDecimal(strField.trim());
                }
                catch (NumberFormatException e) {
                    throw new Exception("Convert data [" + strField.trim() + "] to Double exception", e);
                }
            }
        }
        throw new Exception("The data type is not supported [" + dataType + V_BRACKET_RIGHT);
    }

    @Override
    public Map<String, Object> getCurrentContext() {
        return this.currentContext;
    }

    public void setCurrentContext(Map<String, Object> currentContext) {
        this.currentContext = currentContext;
        if (currentContext instanceof LinkedHashMap) {
            this.orderMap = true;
        }
    }

    @Override
    public S getInputData() {
        return this.inputData;
    }

    public int getPackType() {
        return this.packType;
    }

    @Override
    public Map<String, Object> getRootContext() {
        return this.rootContext;
    }

    public void setRootContext(Map<String, Object> rootContext) {
        this.rootContext = rootContext;
    }

    @Override
    public void inputData(S inputData) throws Exception {
        this.inputData = inputData;
    }

    public String getEncoding() {
        return this.encoding;
    }

    public void setEncoding(String encoding) {
        this.encoding = encoding;
    }

    public boolean isAutoUnpack() {
        return this.autoUnpack;
    }

    public void setAutoUnPack(boolean autoUnpack) {
        this.autoUnpack = autoUnpack;
    }

    protected Object invokeMethods(Method[] methods, Item item, Object data) throws Exception {
        if (methods == null) {
            return data;
        }
        Object o = data;
        for (Method method : methods) {
            Map<String, String> paras = this.getStringStringMap(method);
            if (item != null && !StringTools.isEmpty(item.getName())) {
                paras.put("ItemName", item.getName());
                paras.put("ItemDesc", item.getDescription());
            }
            o = FastMethodInvoker.getInstance().invokeFormatMethod(method.getClazzName(), method.getMethod(), paras, o, this.getRootContext());
        }
        return ByteTools.getBytes(o);
    }

    protected Object invokeMethods(Method[] methods, Object data, int returnType) throws Exception {
        if (methods == null) {
            return data;
        }
        Object o = data;
        for (Method method : methods) {
            Map<String, String> paras = this.getStringStringMap(method);
            o = FastMethodInvoker.getInstance().invokeFormatMethod(method.getClazzName(), method.getMethod(), paras, o, this.getRootContext());
        }
        int secondType = 2;
        if (returnType == 1) {
            return ByteTools.getBytes(o);
        }
        if (returnType == secondType) {
            return StringTools.getString(o, this.getEncoding());
        }
        return o;
    }

    private Map<String, String> getStringStringMap(Method method) {
        Map<String, String> paras;
        if (method instanceof CacheMethod) {
            paras = ((CacheMethod)method).getParas();
        } else {
            Property[] properties;
            paras = new HashMap<String, String>(16);
            for (Property property : properties = method.getProperty()) {
                paras.put(property.getName(), property.getValue());
            }
        }
        return paras;
    }

    public boolean isHiddenInfo() {
        return this.hiddenInfo;
    }

    public void log(int logLevel, Item item, String value, Map<String, String> params, String appendStr) throws Exception {
        String packTypeStr;
        if (this.packType == DATAFORMAT_PACK) {
            packTypeStr = V_PACK_STRING;
            if (value == null) {
                String logStr = "{} @ {}:{},ignore {}";
                Object[] logParams = new String[]{this.getExecutorName(), packTypeStr, OgnlTools.parseXmlPath(this.getRealItemPath(item), this.rootContext), appendStr};
                this.log(logLevel, logStr, logParams);
                return;
            }
        } else {
            packTypeStr = V_UNPACK_STRING;
        }
        if (item.isPwd() && value != null) {
            this.setHiddenInfo(true);
            value = BspTools.pwdTransfer(value);
        }
        String logStr = "{} @ {}:{}=[{}] {}";
        Object[] logParams = new String[]{this.getExecutorName(), packTypeStr, OgnlTools.parseXmlPath(this.getRealItemPath(item), this.rootContext), value, appendStr};
        this.log(logLevel, logStr, logParams);
    }

    protected void log(int logLevel, String logStr, Object[] logParams) {
        int infoLevel = 2;
        int warnLevel = 3;
        int errorLevel = 4;
        if (logLevel == 1) {
            this.logger.debug(logStr, logParams);
        } else if (logLevel == warnLevel) {
            this.logger.warn(logStr, logParams);
        } else if (logLevel == infoLevel) {
            this.logger.info(logStr, logParams);
        } else if (logLevel == errorLevel) {
            this.logger.error(logStr, logParams);
        }
    }

    @Override
    public S outputData() throws Exception {
        if (this.isAutoPack()) {
            return this.autoPackInner();
        }
        return this.outputInner();
    }

    public abstract S outputInner() throws Exception;

    @Override
    public void pack(DataFormat dataformat) throws Exception {
        this.packType = DATAFORMAT_PACK;
        Map<String, String> pro = this.packHead(dataformat.getHead());
        this.setFilterEmpty(V_TRUE.equals(pro.get(PROPERTY_FILTER_EMPTY)));
        this.setAutoPack(V_TRUE.equals(pro.get(PROPERTY_AUTO_PACK)));
        this.setAutoPackVar(pro.get(PROPERTY_AUTO_PACK_VAR));
        this.initDataformat(dataformat, pro);
        if (!this.isAutoPack()) {
            this.packBody(dataformat.getBody());
        }
    }

    private S autoPackInner() throws Exception {
        if (StringTools.isEmpty(this.getAutoPackVar())) {
            throw new Exception(this.getExecutorName() + " @ When auto-packing, the variable of auto-packing cannot be empty");
        }
        Object obj = OgnlTools.getValue(this.getAutoPackVar(), this.getRootContext());
        if (obj == null) {
            throw new Exception(this.getExecutorName() + " @ The value of auto packaging variable [" + this.getAutoPackVar() + "] is null");
        }
        if (obj instanceof Map) {
            try {
                return this.autoPack((Map)obj);
            }
            catch (Exception e) {
                throw new Exception(this.getExecutorName() + " @ Auto packaging exception", e);
            }
        }
        if (obj instanceof List) {
            try {
                return this.autoPack((List)obj);
            }
            catch (Exception e) {
                throw new Exception(this.getExecutorName() + " @ Auto packaging exception", e);
            }
        }
        throw new Exception(this.getExecutorName() + " @ The type of auto packaging variable [" + this.getAutoPackVar() + "] value must be MAP");
    }

    protected S autoPack(Map<String, Object> map) throws Exception {
        throw new Exception(this.getExecutorName() + " @ Map type automatic packaging is not supported");
    }

    protected S autoPack(List<Object> list) throws Exception {
        throw new Exception(this.getExecutorName() + " @ List type automatic packaging is not supported");
    }

    protected String pathToString(List<String> path, String key) {
        if (path.size() == 0) {
            return key;
        }
        StringBuilder buf = new StringBuilder();
        for (String str : path) {
            if (buf.length() > 0) {
                buf.append(V_DOT);
            }
            buf.append(str);
        }
        if (!StringTools.isEmpty(key)) {
            buf.append(V_DOT);
            buf.append(key);
        }
        return buf.toString();
    }

    protected void packBody(Body body) throws Exception {
        BodyItem[] item;
        if (body != null && (item = body instanceof CacheBody ? ((CacheBody)body).getBodyItemArr() : body.getBodyItem()) != null) {
            for (BodyItem bodyItem : item) {
                this.packBodyItem(bodyItem.getChoiceValue());
            }
        }
    }

    protected void packBodyItem(Object choiceValue) throws Exception {
        if (choiceValue instanceof Item) {
            this.packItem((Item)choiceValue);
        } else if (choiceValue instanceof Group) {
            this.packGroup((Group)choiceValue);
        } else if (choiceValue instanceof While) {
            this.packWhile((While)choiceValue);
        } else if (choiceValue instanceof Switch) {
            this.packSwitch((Switch)choiceValue);
        } else if (choiceValue instanceof DataFormatRef) {
            this.packDataFormatRef((DataFormatRef)choiceValue);
        } else if (choiceValue instanceof ItemRef) {
            this.packItemRef((ItemRef)choiceValue);
        } else {
            throw new DataFormatException(this.getExecutorName() + " @ Type is not supported:" + choiceValue);
        }
    }

    private void packCase(Case caseValue) throws Exception {
        this.packBody(caseValue.getBody());
    }

    protected void packDataFormatRef(DataFormatRef dataFormatRef) throws Exception {
        String refName = dataFormatRef.getName();
        String messageName = StringTools.getString(OgnlTools.getValue(dataFormatRef.getFileName(), this.getRootContext()));
        if (messageName == null) {
            throw new Exception("Referenced message name must not be null");
        }
        this.logger.debug("{} @ Packing referenced message, referenced name: {}, message: {}", new Object[]{this.getExecutorName(), refName, messageName});
        String oldPath = this.currentPath;
        if (StringTools.isEmpty(this.currentPath)) {
            this.currentPath = dataFormatRef.getPath();
        } else if (!StringTools.isEmpty(dataFormatRef.getPath())) {
            this.currentPath = this.currentPath + V_DOT + dataFormatRef.getPath();
        }
        DataFormat dataFormat = this.getMfdDataFormat(FileTools.getMsgPath(this.getModulePath(), messageName));
        this.packBody(dataFormat.getBody());
        this.currentPath = oldPath;
    }

    protected DataFormat getMfdDataFormat(String messageName) throws Exception {
        return DataFormatTools.loadDataFormat(messageName);
    }

    protected byte[] packSubRefDataFormat(SubRefDataFormat dataFormatRef) throws Exception {
        String oldPath = this.currentPath;
        this.currentPath = StringTools.isEmpty(this.currentPath) ? dataFormatRef.getPath() : this.currentPath + V_DOT + dataFormatRef.getPath();
        String refName = dataFormatRef.getName();
        String messageName = StringTools.getString(OgnlTools.getValue(dataFormatRef.getFileName(), this.getRootContext()));
        this.logger.debug("{} @ Packing subreferenced message, subreferenced name: {}, message: {}", new Object[]{this.getExecutorName(), refName, messageName});
        DataFormat dataFormat = this.getMfdDataFormat(messageName);
        byte[] data = ByteTools.getBytes(this.packSubDataFormat(dataFormat));
        this.currentPath = oldPath;
        return data;
    }

    private void packDefault(Default defaultObject) throws Exception {
        this.packBody(defaultObject.getBody());
    }

    protected void packGroup(Group group) throws Exception {
        this.packBody(group.getBody());
    }

    protected Map<String, String> packHead(Head head) {
        Property[] property;
        if (head instanceof CacheHead) {
            return ((CacheHead)head).getParas();
        }
        HashMap<String, String> para = new HashMap<String, String>(16);
        if (head != null && (property = head.getProperty()) != null) {
            for (Property value : property) {
                para.put(value.getName(), value.getValue());
            }
        }
        return para;
    }

    protected boolean packItem(Item item) throws Exception {
        Map<String, String> params = this.packHead(item.getHead());
        Object ret = null;
        DataFormat dataformat = item.getDataFormat();
        SubRefDataFormat subRefDataFormat = item.getSubRefDataFormat();
        boolean invokeMethod = true;
        if (dataformat != null) {
            ret = this.packSubDataFormat(dataformat);
        } else if (subRefDataFormat != null) {
            ret = this.packSubRefDataFormat(subRefDataFormat);
        } else if (this.parseExpr) {
            ret = this.parseItemExpress(item.getBuildExpr(), item);
        } else {
            String buildExpr = item.getBuildExpr();
            if (!StringTools.isEmpty(buildExpr)) {
                String strStartWith = "\"";
                if (buildExpr.startsWith(strStartWith)) {
                    ret = buildExpr.substring(1, buildExpr.length() - 1);
                } else {
                    ret = "(" + buildExpr + ")";
                    this.logger.debug(this.getClass().getSimpleName());
                    if (this instanceof LenExecutor) {
                        invokeMethod = false;
                    }
                }
            }
        }
        if (!this.isSubObjectType()) {
            if (this.packItem(item, params, ret, invokeMethod)) {
                return false;
            }
        } else {
            this.log(1, item, StringTools.getString(ret, this.getEncoding()), params, V_EMPTY);
            this.packObjectItem(item, ret, params);
        }
        return true;
    }

    private boolean packItem(Item item, Map<String, String> params, Object ret, boolean invokeMethod) throws Exception {
        byte[] data = null;
        int valueState = 0;
        if (ret != null) {
            data = ByteTools.getBytes(ret, this.getEncoding());
            if (this.isFilterEmpty() && (data == null || data.length == 0)) {
                valueState |= 1;
                ret = null;
            }
        }
        if (ret == null) {
            data = this.parseDefaultValue(item);
            valueState |= 2;
        }
        if (data == null && !V_TRUE.equals(params.get(ITEM_ATTRIBUTE_HAVE_KEY))) {
            if ((valueState & 1) == 1) {
                if (!this.supportItemMust() || item.getMust()) {
                    throw new DataFormatException("The value of field [" + OgnlTools.parseXmlPath(this.getRealItemPath(item), this.rootContext) + "] after filtering the empty string is null, which is a required field");
                }
                if (this.loggerWarn.isWarnEnabled()) {
                    this.log(1, item, null, params, "(Null value after filtering empty string)");
                }
                return true;
            }
            if (!this.supportItemMust() || item.getMust()) {
                throw new DataFormatException("The value of field [" + OgnlTools.parseXmlPath(this.getRealItemPath(item), this.rootContext) + "] after filtering the empty string is null, which is a required field");
            }
            if (this.loggerWarn.isWarnEnabled()) {
                this.log(1, item, null, params, "(Value is null)");
            }
            return true;
        }
        if (data != null && invokeMethod) {
            Build build;
            Method[] methodList = null;
            if (item.getMethods() != null && (build = item.getMethods().getBuild()) != null) {
                methodList = build instanceof CacheBuild ? ((CacheBuild)build).getMethodArr() : build.getMethod();
            }
            data = (byte[])this.invokeMethods(methodList, item, data);
            data = (byte[])this.invokeMethods(this.globalBuildMethod, data, 1);
            data = this.prePackItem(item, data, params);
        }
        if (this.logger.isDebugEnabled()) {
            String tempStr = V_EMPTY;
            int twoValue = 2;
            int threeValue = 3;
            if (valueState == twoValue) {
                tempStr = "(Defaults)";
            } else if (valueState == threeValue) {
                tempStr = "(Take the default value after filtering the empty string)";
            }
            this.log(1, item, StringTools.getString(data, this.getEncoding()), params, tempStr);
        }
        this.packItem(item, data, params);
        return false;
    }

    protected byte[] parseDefaultValue(Item item) throws Exception {
        byte[] data = null;
        String defaultExpress = item.getDefaultValue();
        if (!StringTools.isEmpty(defaultExpress)) {
            if (defaultExpress.startsWith(HEXPREFIX_LOWER) || defaultExpress.startsWith(HEXPREFIX_UPPER)) {
                defaultExpress = defaultExpress.substring(2);
                data = StringTools.string2Byte(defaultExpress);
            } else {
                data = ByteTools.getBytes(OgnlTools.getValue(defaultExpress, this.getRootContext()), this.getEncoding());
            }
        }
        return data;
    }

    protected String getRealItemPath(Item item) {
        if (StringTools.isEmpty(this.currentPath)) {
            return item.getPath();
        }
        return this.currentPath + V_DOT + item.getPath();
    }

    protected String getRealWhilePath(While whileObject) {
        if (StringTools.isEmpty(this.currentPath)) {
            return whileObject.getPath();
        }
        return this.currentPath + V_DOT + whileObject.getPath();
    }

    protected byte[] prePackItem(Item item, byte[] data, Map<String, String> params) throws Exception {
        return data;
    }

    public abstract void packItem(Item var1, byte[] var2, Map<String, String> var3) throws Exception;

    public void packObjectItem(Item field, Object data, Map<String, String> paras) {
    }

    private void packItemRef(ItemRef itemRef) {
    }

    protected Object packSubDataFormat(DataFormat subDataFormat) throws Exception {
        String clazzName = subDataFormat.getImplClass();
        AbstractExecutor sub = DataFormatRegistry.getDataFormatExecutor(clazzName);
        this.logger.debug("{} @ Packing submessage: {}", new Object[]{this.getExecutorName(), sub.getExecutorName()});
        sub.setEncoding(subDataFormat.getEncoding());
        sub.setRootContext(this.getRootContext());
        sub.setCurrentContext(this.getCurrentContext());
        sub.setCurrentPath(this.currentPath);
        sub.setModulePath(this.getModulePath());
        sub.pack(subDataFormat);
        this.setSubObjectType(sub.isObjectType());
        this.setHiddenInfo(sub.isHiddenInfo());
        return sub.outputData();
    }

    private void packSwitch(Switch switchObject) throws Exception {
        Case[] caseArray;
        boolean defaultBranch = true;
        for (Case aCase : caseArray = switchObject.getCase()) {
            String expression = aCase.getExpression();
            boolean ret = OgnlTools.getBooleanValue(expression, this.rootContext);
            if (!ret) continue;
            this.logger.debug("{} @ Branch entry, condition: {}", new Object[]{this.getExecutorName(), expression});
            this.packCase(aCase);
            defaultBranch = false;
            break;
        }
        if (defaultBranch) {
            Default defaultObject = switchObject.getDefault();
            if (defaultObject != null) {
                this.logger.debug("{} @ Branch entry, default branch", (Object)this.getExecutorName());
                this.packDefault(defaultObject);
            } else {
                this.logger.warn("{} @ Default branch is not configured", (Object)this.getExecutorName());
            }
        }
    }

    protected int parseLoopCount(While whileObject) throws Exception {
        int nCount;
        String count = whileObject.getMaxNum();
        if (StringTools.isEmpty(count)) {
            String sCount = this.getRealWhilePath(whileObject);
            Object o = OgnlTools.getValue(sCount, this.rootContext);
            if (o instanceof List) {
                List list = (List)o;
                nCount = list.size();
            } else {
                nCount = 0;
                this.logger.warn("{} @ The structure corresponding to loop [{}] does not exist", new Object[]{this.getExecutorName(), sCount});
            }
        } else {
            String sCount;
            try {
                sCount = StringTools.getString(OgnlTools.getValue(count, this.rootContext));
            }
            catch (Exception e1) {
                throw new Exception(this.getExecutorName() + " @ Loop frequency variable [" + count + "] is abnormal:", e1);
            }
            if (StringTools.isEmpty(sCount)) {
                throw new Exception(this.getExecutorName() + " @ Loop frequency variable value [" + count + "] for loop [" + this.getRealWhilePath(whileObject) + "] does not exist");
            }
            try {
                nCount = Integer.parseInt(sCount);
            }
            catch (Exception e) {
                throw new IllegalArgumentException(this.getExecutorName() + " @ Loop frequency of loop [" + this.getRealWhilePath(whileObject) + "] must be a number, current=" + sCount, e);
            }
        }
        return nCount;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected int parseLoopCount(While whileObject, Map<String, Object> context) throws Exception {
        String sCount;
        String count = whileObject.getMaxNum();
        if (StringTools.isEmpty(count)) {
            String sCount2 = this.getRealWhilePath(whileObject);
            Object o = OgnlTools.getValue(sCount2 = OgnlTools.parseXmlPath(sCount2, this.getRootContext()), context);
            if (!(o instanceof List)) throw new Exception(this.getExecutorName() + " @ Loop [" + this.getRealWhilePath(whileObject) + "] get loop frequency exception");
            List list = (List)o;
            return list.size();
        }
        try {
            sCount = StringTools.getString(OgnlTools.getValue(count, this.rootContext));
        }
        catch (Exception e) {
            try {
                sCount = StringTools.getString(OgnlTools.getValue(count, context));
            }
            catch (Exception e1) {
                throw new Exception(this.getExecutorName() + " @ Loop frequency variable [" + count + "]is abnormal:", e1);
            }
        }
        if (StringTools.isEmpty(sCount)) {
            throw new Exception(this.getExecutorName() + " @ Loop frequency variable value [" + count + "] for loop [" + this.getRealWhilePath(whileObject) + "] does not exist");
        }
        try {
            return Integer.parseInt(sCount);
        }
        catch (Exception e) {
            throw new Exception(this.getExecutorName() + " @ Loop frequency must be a number, current=" + sCount, e);
        }
    }

    protected void packWhile(While whileObject) throws Exception {
        String varName = whileObject.getVar();
        int nCount = this.parseLoopCount(whileObject);
        for (int i = 0; i < nCount; ++i) {
            this.rootContext.put(varName, i);
            this.packBody(whileObject.getBody());
        }
        this.rootContext.remove(varName);
    }

    protected String parseExpressStringValue(String expr) {
        String result = null;
        if (!StringTools.isEmpty(expr)) {
            result = StringTools.getString(this.parseExpress(expr));
        }
        return result;
    }

    protected Object parseExpress(String expr) {
        Object ret;
        block2: {
            ret = null;
            try {
                ret = OgnlTools.getValue(expr, this.rootContext);
            }
            catch (Exception e) {
                if (!this.logger.isWarnEnabled()) break block2;
                this.logger.warn("Parse expression [{}] exception: {}", new Object[]{expr, e.getMessage()});
            }
        }
        return ret;
    }

    protected Object parseItemExpress(String expr, Item item) throws Exception {
        Object ret;
        block3: {
            ret = null;
            Map<String, Object> map = this.rootContext;
            boolean notlogwarn = false;
            try {
                if (StringTools.isEmpty(expr)) {
                    expr = this.getRealItemPath(item);
                    notlogwarn = true;
                }
                ret = OgnlTools.getValue(expr, map);
            }
            catch (Exception e) {
                if (!this.logger.isWarnEnabled() || notlogwarn) break block3;
                this.logger.warn("{} @ Packaging: {}, parse expression[{}] exception:{}", new Object[]{this.getExecutorName(), OgnlTools.parseXmlPath(this.getRealItemPath(item), this.rootContext), expr, e.getMessage()});
            }
        }
        return ret;
    }

    public void setDataFormatEnd() {
        this.end = true;
    }

    public boolean isDataFormatEnd() {
        return this.end;
    }

    public void setHiddenInfo(boolean hiddenInfo) {
        this.hiddenInfo = hiddenInfo;
    }

    public void setPackType(int packType) {
        this.packType = packType;
    }

    protected boolean supportItemMust() {
        return false;
    }

    public String transferHiddenInfo(String key, String value) {
        return value;
    }

    @Override
    public void unPack(DataFormat dataformat, S data) throws Exception {
        if (dataformat == null) {
            throw new DataFormatException(this.getExecutorName() + " @ Message configuration is empty");
        }
        this.unPackInner(dataformat, data);
    }

    private void unPackInner(DataFormat dataformat, S data) throws Exception {
        this.packType = DATAFORMAT_UNPACK;
        Map<String, String> pro = this.packHead(dataformat.getHead());
        this.setAutoUnPack(V_TRUE.equals(pro.get(PROPERTY_AUTO_UNPACK)));
        this.setAutoUnpackSave(V_TRUE.equals(pro.get(PROPERTY_AUTO_UNPACK_SAVE)));
        this.setAutoUnpackVar(pro.get(PROPERTY_AUTO_UNPACK_VAR));
        this.initDataformat(dataformat, pro);
        this.inputData(data);
        if (this.isAutoUnpack()) {
            this.autoUnpackInner();
        } else {
            if (this.isAutoUnpackSave()) {
                this.autoUnpackInner();
            }
            this.unPackBody(dataformat.getBody());
        }
    }

    private void initDataformat(DataFormat dataformat, Map<String, String> pro) throws Exception {
        this.end = false;
        if (dataformat.getMethods() != null) {
            Parse parse;
            Build build = dataformat.getMethods().getBuild();
            if (build != null) {
                this.globalBuildMethod = build instanceof CacheBuild ? ((CacheBuild)build).getMethodArr() : build.getMethod();
            }
            if ((parse = dataformat.getMethods().getParse()) != null) {
                this.globalParseMethod = parse instanceof CacheParse ? ((CacheParse)parse).getMethodArr() : parse.getMethod();
            }
        }
        this.init(pro);
    }

    private void autoUnpackInner() throws Exception {
        Object obj = this.autoUnpack();
        String path = this.getCurrentPathUnpack();
        if (path == null) {
            path = V_EMPTY;
        }
        if (!StringTools.isEmpty(this.getCurrentPath()) && !StringTools.isEmpty(path)) {
            path = this.getCurrentPath() + V_DOT + path;
        }
        if (obj instanceof Map) {
            Map unpackMap = (Map)obj;
            if (StringTools.isEmpty(this.getAutoUnpackVar()) || this.getAutoUnpackVar().equals("ctx") || this.getAutoUnpackVar().equals("context")) {
                this.getCurrentContext().putAll(unpackMap);
                if (this.logger.isDebugEnabled()) {
                    this.log(unpackMap, path, V_EMPTY, this.logger, 1, this.getExecutorName() + " @ Auto unpacking:");
                }
            } else {
                OgnlTools.setValue(this.getAutoUnpackVar(), unpackMap, this.getCurrentContext());
                if (this.logger.isDebugEnabled()) {
                    HashMap<String, Map> tempMap = new HashMap<String, Map>(16);
                    tempMap.put(this.getAutoUnpackVar(), unpackMap);
                    this.log(tempMap, path, V_EMPTY, this.logger, 1, this.getExecutorName() + " @ Auto unpacking:");
                }
            }
        } else if (obj instanceof List) {
            List templist = (List)obj;
            if (StringTools.isEmpty(this.getAutoUnpackVar())) {
                throw new Exception(this.getExecutorName() + " @ Auto unpacking variable cannot be empty");
            }
            OgnlTools.setValue(this.getAutoUnpackVar(), templist, this.getCurrentContext());
            if (this.logger.isDebugEnabled()) {
                HashMap<String, List> tempMap = new HashMap<String, List>(16);
                tempMap.put(this.getAutoUnpackVar(), templist);
                this.log(tempMap, path, V_EMPTY, this.logger, 1, this.getExecutorName() + " @ Auto unpacking:");
            }
        }
    }

    protected Object autoUnpack() throws Exception {
        throw new Exception(this.getExecutorName() + " @ Auto unpacking is not supported");
    }

    protected void unPackBody(Body body) throws Exception {
        BodyItem[] items = body instanceof CacheBody ? ((CacheBody)body).getBodyItemArr() : body.getBodyItem();
        for (BodyItem item : items) {
            this.unPackBodyItem(item.getChoiceValue());
        }
    }

    protected void unPackBodyItem(Object choiceValue) throws Exception {
        if (choiceValue instanceof Item) {
            this.unPackItem((Item)choiceValue);
        } else if (choiceValue instanceof Group) {
            this.unPackGroup((Group)choiceValue);
        } else if (choiceValue instanceof While) {
            this.unPackWhile((While)choiceValue);
        } else if (choiceValue instanceof Switch) {
            this.unPackSwitch((Switch)choiceValue);
        } else if (choiceValue instanceof DataFormatRef) {
            this.unPackDataFormatRef((DataFormatRef)choiceValue);
        } else if (choiceValue instanceof ItemRef) {
            this.unPackItemRef((ItemRef)choiceValue);
        } else {
            throw new DataFormatException(this.getExecutorName() + " @ Field type is not supported");
        }
    }

    private void unPackCase(Case caseObject) throws Exception {
        this.unPackBody(caseObject.getBody());
    }

    protected void unPackDataFormatRef(DataFormatRef dataFormatRefObject) throws Exception {
        String refName = dataFormatRefObject.getName();
        String messageName = StringTools.getString(OgnlTools.getValue(dataFormatRefObject.getFileName(), this.getRootContext()));
        this.logger.info("\u62c6\u5305\u8def\u5f84:{},{},{}", new Object[]{refName, messageName, dataFormatRefObject.getPath()});
        if (messageName == null) {
            throw new Exception("Referenced message name must not be null");
        }
        this.logger.debug("{} @ Unpack referenced message, referenced name: {}, path: {}", new Object[]{this.getExecutorName(), refName, messageName});
        String oldPath = this.currentPath;
        this.currentPath = StringTools.isEmpty(this.currentPath) ? dataFormatRefObject.getPath() : this.currentPath + V_DOT + dataFormatRefObject.getPath();
        DataFormat dataFormat = this.getMfdDataFormat(FileTools.getMsgPath(this.getModulePath(), messageName));
        this.unPackBody(dataFormat.getBody());
        this.currentPath = oldPath;
    }

    protected void unPackSubRefDataFormat(SubRefDataFormat dataFormatRefObject, Object srcData) throws Exception {
        String oldPath = this.currentPath;
        this.currentPath = StringTools.isEmpty(this.currentPath) ? dataFormatRefObject.getPath() : this.currentPath + V_DOT + dataFormatRefObject.getPath();
        String refName = dataFormatRefObject.getName();
        String messageName = StringTools.getString(OgnlTools.getValue(dataFormatRefObject.getFileName(), this.getRootContext()));
        this.logger.debug("{} @ Unpack subreferenced message, referenced name: {}, path: {}", new Object[]{this.getExecutorName(), refName, messageName});
        DataFormat dataFormat = DataFormatTools.loadDataFormat(messageName);
        this.unPackBody(dataFormat.getBody());
        this.unPackSubDataFormat(dataFormat, srcData);
        this.currentPath = oldPath;
    }

    private void unPackDefault(Default defaultObject) throws Exception {
        this.unPackBody(defaultObject.getBody());
    }

    protected void unPackGroup(Group group) throws Exception {
        Map<String, Object> cContext;
        String name = group.getName();
        Map<String, Object> oldContext = this.currentContext;
        Object o = this.currentContext.get(name);
        if (o instanceof Map) {
            cContext = (Map<String, Object>)o;
        } else {
            cContext = this.newMap();
            this.currentContext.put(name, cContext);
        }
        this.currentContext = cContext;
        String oldpath = this.getCurrentPathUnpack();
        this.setCurrentPathUnpack(group.getPath());
        this.unPackBody(group.getBody());
        this.setCurrentPathUnpack(oldpath);
        this.currentContext = oldContext;
    }

    protected void unPackItem(Item item) throws Exception {
        String dataType = item.getType();
        Map<String, Object> ctx = this.currentContext;
        Map<String, String> params = this.packHead(item.getHead());
        if (this.isObjectType()) {
            Object objItem = this.unPackObjectItem(item, params);
            this.unPackSubDataFormat(item, ctx, params, objItem, V_EMPTY, objItem);
        } else {
            Parse parse;
            byte[] byItem = this.unPackItem(item, params);
            String appendStr = V_EMPTY;
            if (byItem == null) {
                if (!this.supportItemMust() || item.getMust()) {
                    throw new DataFormatException(this.getExecutorName() + " @ " + OgnlTools.parseXmlPath(this.getRealItemPath(item), this.rootContext) + "value is NULL");
                }
                String defaultValue = item.getDefaultValue();
                Object o = null;
                if (!StringTools.isEmpty(defaultValue)) {
                    try {
                        o = OgnlTools.getValue(defaultValue, this.rootContext);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                if (o == null) {
                    if (this.loggerWarn.isWarnEnabled()) {
                        this.log(3, item, null, params, V_EMPTY);
                    }
                    return;
                }
                byItem = ByteTools.getBytes(o, this.getEncoding());
                appendStr = "(Defaults)";
            }
            Method[] methodList = null;
            if (item.getMethods() != null && (parse = item.getMethods().getParse()) != null) {
                methodList = parse instanceof CacheParse ? ((CacheParse)parse).getMethodArr() : parse.getMethod();
            }
            byItem = (byte[])this.invokeMethods(methodList, item, byItem);
            byItem = (byte[])this.invokeMethods(this.globalParseMethod, byItem, 1);
            this.unPackSubDataFormat(item, dataType, ctx, params, byItem, appendStr);
        }
    }

    private void unPackSubDataFormat(Item item, Map<String, Object> ctx, Map<String, String> params, Object objItem, String vEmpty, Object objItem2) throws Exception {
        if (this.logger.isDebugEnabled()) {
            String sData = StringTools.getString(objItem, this.getEncoding());
            this.log(1, item, sData, params, vEmpty);
        }
        ctx.put(item.getName(), objItem2);
        DataFormat subDataFormat = item.getDataFormat();
        SubRefDataFormat subRefDataFormat = item.getSubRefDataFormat();
        if (subDataFormat != null) {
            this.unPackSubDataFormat(subDataFormat, objItem);
        } else if (subRefDataFormat != null) {
            this.unPackSubRefDataFormat(subRefDataFormat, objItem);
        }
    }

    private void unPackSubDataFormat(Item item, String dataType, Map<String, Object> ctx, Map<String, String> params, byte[] byItem, String appendStr) throws Exception {
        this.unPackSubDataFormat(item, ctx, params, byItem, appendStr, this.itemTypeConvert(dataType, byItem));
    }

    public abstract byte[] unPackItem(Item var1, Map<String, String> var2) throws Exception;

    public Object unPackObjectItem(Item field, Map<String, String> paras) {
        return null;
    }

    protected void unPackItemRef(ItemRef itemRef) {
    }

    protected void unPackSubDataFormat(DataFormat subDataFormat, Object subData) throws Exception {
        String clazzName = subDataFormat.getImplClass();
        AbstractExecutor sub = DataFormatRegistry.getDataFormatExecutor(clazzName);
        this.logger.debug("{} @ Unpacking submessage: {}", new Object[]{this.getExecutorName(), sub.getExecutorName()});
        sub.setEncoding(subDataFormat.getEncoding());
        sub.setRootContext(this.getRootContext());
        sub.setCurrentContext(this.getCurrentContext());
        sub.setCurrentPath(this.currentPath);
        sub.setCurrentPathUnpack(this.getCurrentPathUnpack());
        sub.setModulePath(this.getModulePath());
        sub.unPack(subDataFormat, subData);
    }

    protected void unPackSwitch(Switch switchObject) throws Exception {
        Default defaultObject;
        Case[] cases = switchObject.getCase();
        boolean flag = true;
        for (Case aCase : cases) {
            String expr = aCase.getExpression();
            if (!OgnlTools.getBooleanValue(expr, this.rootContext).booleanValue()) continue;
            this.logger.debug("{} @ Condition expression is {}", new Object[]{this.getExecutorName(), expr});
            this.unPackCase(aCase);
            flag = false;
            break;
        }
        if (flag && (defaultObject = switchObject.getDefault()) != null) {
            this.logger.debug("{} @ Default branch", (Object)this.getExecutorName());
            this.unPackDefault(defaultObject);
        }
    }

    protected void unPackWhile(While whileObject) throws Exception {
        int nCount;
        String count = whileObject.getMaxNum();
        String name = whileObject.getName();
        String varname = whileObject.getVar();
        String sCount = StringTools.getString(OgnlTools.getValue(count, this.rootContext));
        if (sCount == null) {
            throw new Exception("Loop frequency must not be null");
        }
        try {
            nCount = Integer.parseInt(sCount);
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Loop frequency must be a number, current=" + sCount, e);
        }
        this.unPackWhile(nCount, name, varname, whileObject);
    }

    protected void unPackWhile(int nCount, String name, String varname, While whileObject) throws Exception {
        ArrayList<Map<String, Object>> list = new ArrayList<Map<String, Object>>(nCount);
        Map<String, Object> oldContext = this.getCurrentContext();
        oldContext.put(name, list);
        String oldPath = this.getCurrentPathUnpack();
        for (int i = 0; i < nCount; ++i) {
            Map<String, Object> map = this.newMap();
            list.add(map);
            map.put(varname, i);
            this.rootContext.put(varname, i);
            this.currentContext = map;
            this.setCurrentPathUnpack(OgnlTools.parseXmlPath(whileObject.getPath() + V_BRACKET_LEFT + whileObject.getVar() + V_BRACKET_RIGHT, this.rootContext));
            this.unPackBody(whileObject.getBody());
            map.remove(varname);
            if (!this.end) continue;
            if (!this.logger.isDebugEnabled()) break;
            this.logger.debug("{} @ Loop message, {}, number of loop: {}", new Object[]{this.getExecutorName(), name, i + 1});
            break;
        }
        this.setCurrentPathUnpack(oldPath);
        this.rootContext.remove(varname);
        this.currentContext = oldContext;
    }

    public void parserDataByGlobalMethod(Object data, int valueType, Method[] methodList) throws DataFormatException {
        try {
            if (data instanceof Map) {
                Map map = (Map)data;
                for (String key : map.keySet()) {
                    Object value = map.get(key);
                    if (value instanceof byte[] || value instanceof String) {
                        value = this.invokeMethods(methodList, value, valueType);
                        map.put(key, value);
                        continue;
                    }
                    if (value instanceof Map) {
                        this.parserDataByGlobalMethod(value, valueType, methodList);
                        continue;
                    }
                    if (value instanceof List) {
                        this.parserDataByGlobalMethod(value, valueType, methodList);
                        continue;
                    }
                    this.logger.debug("{} @ Field: {}, type [{}] can be method parameter type", new Object[]{this.getExecutorName(), key, value.getClass().getName()});
                }
            } else if (data instanceof List) {
                List list = (List)data;
                ArrayList<Object> newList = new ArrayList<Object>();
                for (Object value : list) {
                    if (value instanceof byte[] || value instanceof String) {
                        value = this.invokeMethods(methodList, value, valueType);
                    } else if (value instanceof Map) {
                        this.parserDataByGlobalMethod(value, valueType, methodList);
                    } else if (value instanceof List) {
                        this.parserDataByGlobalMethod(value, valueType, methodList);
                    } else {
                        this.logger.debug("{} @ Type [{}] can be a method parameter type", new Object[]{this.getExecutorName(), value.getClass().getName()});
                    }
                    newList.add(value);
                }
                list.clear();
                list.addAll(newList);
            }
        }
        catch (Exception e) {
            throw new DataFormatException("Call global method execution exception", e);
        }
    }

    public void log(Object map, String path, String key, Logger logger, int level, String info) throws UnsupportedEncodingException {
        char pointChar = '.';
        if (path.length() > 0 && path.charAt(0) == pointChar) {
            path = path.substring(1);
        }
        if (map instanceof Map) {
            Map m = (Map)map;
            int hashCode = map.hashCode();
            for (Map.Entry element : m.entrySet()) {
                this.log(element.getValue(), path + V_DOT + (String)element.getKey(), (String)element.getKey(), logger, level, info);
            }
        } else if (map instanceof List) {
            List list = (List)map;
            for (int i = 0; i < list.size(); ++i) {
                this.log(list.get(i), path + V_BRACKET_LEFT + i + V_BRACKET_RIGHT, V_EMPTY, logger, level, info);
            }
        } else {
            String sv = StringTools.getString(map, this.getEncoding());
            StringBuilder buffer = new StringBuilder();
            if (info != null && info.length() > 0) {
                buffer.append(info);
            }
            buffer.append(path);
            buffer.append("=[");
            buffer.append(sv);
            buffer.append(V_BRACKET_RIGHT);
            logger.debug(buffer.toString());
        }
    }

    public Map<String, Object> newMap() {
        HashMap map = this.orderMap ? new LinkedHashMap() : new HashMap(16);
        return map;
    }

    public boolean isSimpleType(Object obj) {
        return obj instanceof byte[] || obj instanceof String || obj instanceof Number || obj instanceof Character;
    }

    public boolean isAutoPack() {
        return this.autoPack;
    }

    public void setAutoPack(boolean autoPack) {
        this.autoPack = autoPack;
    }

    public boolean isDataMessage() {
        return this.dataMessage;
    }

    public String getMessageType() {
        return MESSAGE_TYPE_OTHERS;
    }

    public boolean isSubObjectType() {
        return this.subObjectType;
    }

    public void setSubObjectType(boolean subObjectType) {
        this.subObjectType = subObjectType;
    }

    public boolean isObjectType() {
        return false;
    }

    public boolean subMessageType() {
        return false;
    }

    public void setDataMessage(boolean dataMessage) {
        this.dataMessage = dataMessage;
    }

    protected boolean isFilterEmpty() {
        return this.filterEmpty;
    }

    protected void setFilterEmpty(boolean filterEmpty) {
        this.filterEmpty = filterEmpty;
    }

    public String getCurrentPath() {
        return this.currentPath;
    }

    public void setCurrentPath(String currentPath) {
        this.currentPath = currentPath;
    }

    public String getCurrentPathUnpack() {
        return this.currentPathUnpack;
    }

    public void setCurrentPathUnpack(String currentPathUnpack) {
        this.currentPathUnpack = currentPathUnpack;
    }

    public String getAutoPackVar() {
        return this.autoPackVar;
    }

    public void setAutoPackVar(String autoPackVar) {
        if (this.autoPackVar == null) {
            this.autoPackVar = autoPackVar;
        }
    }

    public String getAutoUnpackVar() {
        return this.autoUnpackVar;
    }

    public void setAutoUnpackVar(String autoUnpackVar) {
        if (this.autoUnpackVar == null) {
            this.autoUnpackVar = autoUnpackVar;
        }
    }

    public boolean isAutoUnpackSave() {
        return this.autoUnpackSave;
    }

    public void setAutoUnpackSave(boolean autoUnpackSave) {
        this.autoUnpackSave = autoUnpackSave;
    }

    public boolean isUnpackEmptyCheck() {
        return this.unpackEmptyCheck;
    }

    public void setUnpackEmptyCheck(boolean unpackEmptyCheck) {
        this.unpackEmptyCheck = unpackEmptyCheck;
    }

    public Method[] getGlobalBuildMethod() {
        return this.globalBuildMethod;
    }

    public void setGlobalBuildMethod(Method[] globalBuildMethod) {
        this.globalBuildMethod = globalBuildMethod;
    }

    public Method[] getGlobalParseMethod() {
        return this.globalParseMethod;
    }

    public void setGlobalParseMethod(Method[] globalParseMethod) {
        this.globalParseMethod = globalParseMethod;
    }

    public boolean isParseExpr() {
        return this.parseExpr;
    }

    public void setParseExpr(boolean parseExpr) {
        this.parseExpr = parseExpr;
    }

    public boolean isOrderMap() {
        return this.orderMap;
    }

    public void setOrderMap(boolean orderMap) {
        this.orderMap = orderMap;
    }

    public String getModulePath() {
        return this.modulePath;
    }

    public void setModulePath(String modulePath) {
        this.modulePath = modulePath;
    }

    public abstract int getSearchIndex();
}

