/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.yusp.bsp.communication.impl.out.ssl;

import cn.com.yusys.yusp.bsp.communication.impl.out.tcp.ShortClientOutAdapter;
import cn.com.yusys.yusp.bsp.communication.impl.ssl.SecureSocketsLayerFactory;
import cn.com.yusys.yusp.bsp.toolkit.common.PwdTools;
import cn.com.yusys.yusp.bsp.toolkit.common.StringTools;
import java.net.Socket;
import javax.net.ssl.SSLSocketFactory;

public class SslShortClientOutAdapter
extends ShortClientOutAdapter {
    private String keyStoreFile;
    private String keyStorePwd;
    private String keyPwd;
    private String trustKeyStoreFile;
    private String trustKeyStorePwd;
    private String sslContextAlgorithm;
    private String keyStoreAlgorithm;
    private String trustManagerAlgorithm;
    private static final String OUT_ADAPTER_NAME = "SSL short connection client adapter";
    SSLSocketFactory clientSocketFactory = null;

    @Override
    public void doStart() throws Exception {
        this.logger.debug("{} @ Keystore path\uff1a{}", new Object[]{this.getAdapterName(), this.keyStoreFile});
        this.logger.debug("{} @ Trust keystore path\uff1a{}", new Object[]{this.getAdapterName(), this.trustKeyStoreFile});
        this.keyStorePwd = PwdTools.decryptStr(this.keyStoreFile, this.keyStorePwd);
        this.keyPwd = PwdTools.decryptStr(this.keyStoreFile, this.keyPwd);
        this.trustKeyStorePwd = PwdTools.decryptStr(this.trustKeyStoreFile, this.trustKeyStorePwd);
        super.doStart();
    }

    @Override
    public Socket createSocket(String host, int port, int timeout) throws Exception {
        if (this.clientSocketFactory == null) {
            SecureSocketsLayerFactory secureSocketsLayerFactory = new SecureSocketsLayerFactory();
            secureSocketsLayerFactory.iniAlgorithm(this.sslContextAlgorithm, this.keyStoreAlgorithm, this.trustManagerAlgorithm);
            if (StringTools.isEmpty(this.keyStoreFile) && StringTools.isEmpty(this.keyStorePwd) && StringTools.isEmpty(this.keyPwd) && StringTools.isEmpty(this.trustKeyStoreFile) && StringTools.isEmpty(this.trustKeyStorePwd)) {
                this.clientSocketFactory = secureSocketsLayerFactory.buildClientFactory();
            } else if (StringTools.isEmpty(this.keyStoreFile) && StringTools.isEmpty(this.keyStorePwd) && StringTools.isEmpty(this.keyPwd) && !StringTools.isEmpty(this.trustKeyStoreFile) && !StringTools.isEmpty(this.trustKeyStorePwd)) {
                this.clientSocketFactory = secureSocketsLayerFactory.buildClientFactory(this.trustKeyStoreFile, this.trustKeyStorePwd);
            } else if (!(StringTools.isEmpty(this.keyStoreFile) || StringTools.isEmpty(this.keyStorePwd) || StringTools.isEmpty(this.keyPwd) || StringTools.isEmpty(this.trustKeyStoreFile) || StringTools.isEmpty(this.trustKeyStorePwd))) {
                this.clientSocketFactory = secureSocketsLayerFactory.buildClientFactory(this.keyStoreFile, this.keyStorePwd, this.keyPwd, this.trustKeyStoreFile, this.trustKeyStorePwd);
            } else {
                throw new Exception("SSL outgoing adapter configuration is incorrect");
            }
        }
        Socket socket = this.clientSocketFactory.createSocket(host, port);
        socket.setKeepAlive(true);
        socket.setSoTimeout(timeout);
        return socket;
    }

    @Override
    public String getAdapterTypeName() {
        return OUT_ADAPTER_NAME;
    }

    public String getKeyStoreFile() {
        return this.keyStoreFile;
    }

    public void setKeyStoreFile(String keyStoreFile) {
        this.keyStoreFile = keyStoreFile;
    }

    public String getKeyStorePwd() {
        return this.keyStorePwd;
    }

    public void setKeyStorePwd(String keyStorePwd) {
        this.keyStorePwd = keyStorePwd;
    }

    public String getKeyPwd() {
        return this.keyPwd;
    }

    public void setKeyPwd(String keyPwd) {
        this.keyPwd = keyPwd;
    }

    public String getTrustKeyStoreFile() {
        return this.trustKeyStoreFile;
    }

    public void setTrustKeyStoreFile(String trustKeyStoreFile) {
        this.trustKeyStoreFile = trustKeyStoreFile;
    }

    public String getTrustKeyStorePwd() {
        return this.trustKeyStorePwd;
    }

    public void setTrustKeyStorePwd(String trustKeyStorePwd) {
        this.trustKeyStorePwd = trustKeyStorePwd;
    }

    public String getSslContextAlgorithm() {
        return this.sslContextAlgorithm;
    }

    public void setSslContextAlgorithm(String sslContextAlgorithm) {
        this.sslContextAlgorithm = sslContextAlgorithm;
    }

    public String getKeyStoreAlgorithm() {
        return this.keyStoreAlgorithm;
    }

    public void setKeyStoreAlgorithm(String keyStoreAlgorithm) {
        this.keyStoreAlgorithm = keyStoreAlgorithm;
    }

    public String getTrustManagerAlgorithm() {
        return this.trustManagerAlgorithm;
    }

    public void setTrustManagerAlgorithm(String trustManagerAlgorithm) {
        this.trustManagerAlgorithm = trustManagerAlgorithm;
    }
}

