/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.yusp.bsp.communication.impl.mq;

import cn.com.yusys.yusp.bsp.toolkit.common.ByteTools;
import cn.com.yusys.yusp.bsp.toolkit.common.StringTools;
import com.ibm.mq.MQException;
import com.ibm.mq.MQGetMessageOptions;
import com.ibm.mq.MQMessage;
import com.ibm.mq.MQPutMessageOptions;
import com.ibm.mq.MQQueue;
import com.ibm.mq.MQQueueManager;
import com.ibm.mq.constants.MQConstants;
import java.io.IOException;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Map;

public class MessageQueueTools {
    public static final int TIMEOUT_DEFAULT = 2000;
    public static final int TIMEOUT_UNLIMITED = -1;
    public static final int RECEIVE_MODE_WAIT = 1;
    public static final int RECEIVE_MODE_NOWAIT = 0;
    public static final String MQ_MESSAGE_ID = "messageId";
    public static final String MQ_MESSAGE = "message";
    public static final String MQ_CORRELATION_ID = "correlationId";
    public static final String MQ_APPLICATION_ID_DATA = "applicationIdData";
    public static final String MQ_CHARSET = "charset";
    public static final String MQ_EXPIRY = "expiry";
    private long maxMessageLength = 0xA00000L;
    private String hostname;
    private int port = 1414;
    private int ccsid = 1381;
    private String userId;
    private String password;
    private String channel;
    private volatile MQQueueManager readerManager;
    private MQQueueManager writerManager;
    private MQQueue recQueue;
    private MQQueue sendQueue;
    private int charset = 0;
    private int expiry = -1;
    private boolean closeFlag = false;
    private final Object recvMute = new Object();
    private boolean alive = true;
    private final Object sendMute = new Object();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void initRecQueue(String queueManagerName, String recvQueueName) throws Exception {
        if (this.readerManager == null || this.recQueue == null) {
            Object object = this.recvMute;
            synchronized (object) {
                if (this.readerManager == null || this.recQueue == null) {
                    this.readerManager = this.createQueueManager(queueManagerName);
                    this.recQueue = this.createQueue(this.readerManager, recvQueueName, true);
                    this.alive = true;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void initRecQueue(String queueManagerName, String recvQueueName, boolean keepRecvQueue) throws Exception {
        MQQueueManager localReaderManager = this.readerManager;
        if (localReaderManager == null) {
            Object object = this.recvMute;
            synchronized (object) {
                localReaderManager = this.readerManager;
                if (localReaderManager == null) {
                    this.readerManager = this.createQueueManager(queueManagerName);
                    this.alive = true;
                }
            }
        }
        if (!keepRecvQueue) {
            this.recQueue = this.createQueue(this.readerManager, recvQueueName, true);
        } else if (this.recQueue == null) {
            this.recQueue = this.createQueue(this.readerManager, recvQueueName, true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void initSendQueue(String queueManagerName, String sendQueueName) throws Exception {
        if (this.writerManager == null || this.sendQueue == null) {
            Object object = this.sendMute;
            synchronized (object) {
                if (this.writerManager == null || this.sendQueue == null) {
                    this.writerManager = this.createQueueManager(queueManagerName);
                    this.sendQueue = this.createQueue(this.writerManager, sendQueueName, false);
                }
            }
        }
    }

    public Map<String, Object> receive(int waitMode, int timeout, String recieveFlag, Object flagValue) throws Exception {
        MQMessage recMessage = new MQMessage();
        MQGetMessageOptions gmo = new MQGetMessageOptions();
        gmo.options += 2;
        gmo.options += 8192;
        gmo.options += waitMode;
        if (flagValue != null && flagValue.toString().length() > 0) {
            if (MQ_MESSAGE_ID.equals(recieveFlag)) {
                gmo.matchOptions = 1;
                recMessage.messageId = ByteTools.getBytes(flagValue);
            } else if (MQ_CORRELATION_ID.equals(recieveFlag)) {
                gmo.matchOptions = 2;
                recMessage.correlationId = ByteTools.getBytes(flagValue);
            }
        }
        try {
            if (timeout == -1) {
                gmo.waitInterval = 2000;
                while (this.alive) {
                    try {
                        this.recQueue.get(recMessage, gmo);
                        break;
                    }
                    catch (MQException e) {
                        if (e.reasonCode == 2033 || e.reasonCode == 2019) continue;
                        throw e;
                    }
                }
                if (!this.alive) {
                    throw new Exception("Adapter is off");
                }
            } else {
                gmo.waitInterval = timeout;
                this.recQueue.get(recMessage, gmo);
            }
        }
        catch (MQException e) {
            int base2202Num = 2202;
            int base2033Num = 2033;
            int base2161Num = 2161;
            if (e.reasonCode == base2202Num) {
                throw new Exception("Read message exception, MQ server [" + this.getHostname() + ":" + this.getPort() + "]Channel closed", e);
            }
            if (e.reasonCode == base2033Num) {
                throw new Exception("Read message timeout exception, no readable message", e);
            }
            if (e.reasonCode == base2161Num) {
                throw new Exception("Read message exception, MQ server [" + this.getHostname() + ":" + this.getPort() + "]Queue manager closed", e);
            }
            throw new Exception("Read message exception", e);
        }
        HashMap<String, Object> map = new HashMap<String, Object>(16);
        map.put(MQ_MESSAGE_ID, recMessage.messageId);
        map.put(MQ_CORRELATION_ID, recMessage.correlationId);
        map.put(MQ_APPLICATION_ID_DATA, recMessage.applicationIdData);
        int dataLen = recMessage.getMessageLength();
        if ((long)dataLen > this.maxMessageLength) {
            throw new Exception("The data length [" + dataLen + "] accepted by MQ is too large.");
        }
        byte[] data = new byte[dataLen];
        recMessage.readFully(data);
        this.readerManager.commit();
        map.put(MQ_MESSAGE, data);
        return map;
    }

    public void send(Map<String, Object> params, byte[] data, boolean request) throws MQException, IOException {
        int base100Num;
        MQMessage putMessage = new MQMessage();
        putMessage.format = "        ";
        putMessage.messageId = MQConstants.MQMI_NONE;
        putMessage.correlationId = MQConstants.MQMI_NONE;
        Object obj = params.get(MQ_MESSAGE_ID);
        if (obj != null) {
            putMessage.messageId = ByteTools.getBytes(obj);
        }
        if ((obj = params.get(MQ_CORRELATION_ID)) != null) {
            putMessage.correlationId = ByteTools.getBytes(obj);
        }
        if ((obj = params.get(MQ_APPLICATION_ID_DATA)) != null) {
            putMessage.applicationIdData = params.get(MQ_APPLICATION_ID_DATA).toString();
        }
        if (this.charset > 0) {
            putMessage.characterSet = this.charset;
        }
        if (this.expiry > (base100Num = 100)) {
            putMessage.expiry = this.expiry / 100;
        }
        putMessage.write(data);
        MQPutMessageOptions pmo = new MQPutMessageOptions();
        this.sendQueue.put(putMessage, pmo);
        this.writerManager.commit();
    }

    public void close() throws Exception {
        Exception exc;
        block5: {
            exc = null;
            this.alive = false;
            try {
                this.closeRecQueue();
            }
            catch (Exception e) {
                exc = e;
            }
            try {
                this.closeSendQueue();
            }
            catch (Exception e) {
                if (exc != null) break block5;
                exc = e;
            }
        }
        if (exc != null) {
            throw exc;
        }
    }

    private MQQueue createQueue(MQQueueManager manager, String queueName, boolean isInput) throws Exception {
        MQQueue queue;
        try {
            int options = isInput ? 8194 : 8208;
            queue = manager.accessQueue(queueName, options);
        }
        catch (MQException e) {
            throw new Exception("Initialization queue exception", e);
        }
        return queue;
    }

    private MQQueueManager createQueueManager(String managerName) throws Exception {
        MQQueueManager manager;
        try {
            manager = new MQQueueManager(managerName, this.getProperties());
        }
        catch (MQException e) {
            int base2538Num = 2538;
            int base2537Num = 2537;
            int base2058Num = 2058;
            if (e.reasonCode == base2538Num) {
                throw new Exception("Initializing the queue manager [" + managerName + "] exception, MQ server [" + this.getHostname() + ":" + this.getPort() + "]The queue manager is not started:" + e.reasonCode, e);
            }
            if (e.reasonCode == base2537Num) {
                throw new Exception("Initializing the queue manager [" + managerName + "] exception, MQ server [" + this.getHostname() + ":" + this.getPort() + "]channel[" + this.getChannel() + "]Close:" + e.reasonCode, e);
            }
            if (e.reasonCode == base2058Num) {
                throw new Exception("Initializing the queue manager [" + managerName + "] exception, MQ server [" + this.getHostname() + ":" + this.getPort() + "]Queue Manager[" + managerName + "] does not exist:" + e.reasonCode, e);
            }
            throw new Exception("Initializing the queue manager [" + managerName + "] exception:" + e.reasonCode, e);
        }
        return manager;
    }

    public void closeRecQueue() throws Exception {
        Exception exc;
        block5: {
            exc = null;
            try {
                this.closeQueue(this.recQueue);
            }
            catch (Exception e) {
                exc = e;
            }
            this.recQueue = null;
            try {
                this.closeQueueManager(this.readerManager);
            }
            catch (Exception e) {
                if (exc != null) break block5;
                exc = e;
            }
        }
        this.readerManager = null;
        if (exc != null) {
            throw exc;
        }
    }

    public void closeOnlyRecQueue() throws Exception {
        Exception exc = null;
        try {
            this.closeQueue(this.recQueue);
        }
        catch (Exception e) {
            exc = e;
        }
        this.recQueue = null;
        if (exc != null) {
            throw exc;
        }
    }

    public void closeSendQueue() throws Exception {
        Exception exc;
        block5: {
            exc = null;
            try {
                this.closeQueue(this.sendQueue);
            }
            catch (Exception e) {
                exc = e;
            }
            this.sendQueue = null;
            try {
                this.closeQueueManager(this.writerManager);
            }
            catch (Exception e) {
                if (exc != null) break block5;
                exc = e;
            }
        }
        this.writerManager = null;
        if (exc != null) {
            throw exc;
        }
    }

    private void closeQueueManager(MQQueueManager manager) throws Exception {
        if (manager != null && manager.isOpen()) {
            try {
                manager.disconnect();
            }
            catch (MQException e) {
                int base2009Num = 2009;
                if (e.reasonCode == base2009Num) {
                    throw new Exception("Close the queue manager[" + manager.getName() + "] An exception occurred, the MQ server [" + this.getHostname() + ":" + this.getPort() + "]The queue manager is closed.", e);
                }
                throw new Exception("An exception occurred when closing the queue manager", e);
            }
            finally {
                manager.close();
            }
        }
    }

    private void closeQueue(MQQueue queue) throws Exception {
        if (queue != null && queue.isOpen()) {
            try {
                queue.close();
            }
            catch (MQException e) {
                int base2009Num = 2009;
                if (e.reasonCode == base2009Num) {
                    throw new Exception("Close the queue[" + queue.getName().trim() + "] An exception occurred, the MQ server [" + this.getHostname() + ":" + this.getPort() + "]The queue manager is closed.", e);
                }
                throw new Exception("Close the MQ queue an exception", e);
            }
        }
    }

    public MessageQueueTools(int ccsid) {
        this("", 1414, "", ccsid);
    }

    public MessageQueueTools(int ccsid, String userId, String password) {
        this("", 1414, "", ccsid, userId, password);
    }

    public MessageQueueTools(String hostname, int port, String channel, int ccsid) {
        this.hostname = hostname;
        this.port = port;
        this.channel = channel;
        this.ccsid = ccsid;
        MQException.logExclude((Integer)2033);
        MQException.logExclude((Integer)2019);
    }

    public MessageQueueTools(String hostname, int port, String channel, int ccsid, String userId, String password) {
        this.hostname = hostname;
        this.port = port;
        this.channel = channel;
        this.ccsid = ccsid;
        this.userId = userId;
        this.password = password;
        MQException.logExclude((Integer)2033);
        MQException.logExclude((Integer)2019);
    }

    private Hashtable<String, Object> getProperties() {
        Hashtable<String, Object> mqProperties = new Hashtable<String, Object>();
        mqProperties.put("hostname", this.hostname);
        mqProperties.put("port", this.port);
        mqProperties.put("channel", this.channel);
        mqProperties.put("CCSID", this.ccsid);
        mqProperties.put("transport", "MQSeries");
        if (!StringTools.isEmpty(this.userId) && !StringTools.isEmpty(this.password)) {
            mqProperties.put("userID", this.userId);
            mqProperties.put("password", this.password);
        }
        return mqProperties;
    }

    public String toString() {
        return "MQTools{hostname='" + this.hostname + '\'' + ", port=" + this.port + ", ccsid=" + this.ccsid + ", userId='" + this.userId + '\'' + ", channel='" + this.channel + '\'' + ", readerManager=" + this.readerManager + ", writerManager=" + this.writerManager + ", recQueue=" + this.recQueue + ", sendQueue=" + this.sendQueue + ", charset=" + this.charset + '}';
    }

    public MQQueue getRecQueue() {
        return this.recQueue;
    }

    public MQQueue getSendQueue() {
        return this.sendQueue;
    }

    public long getMaxMessageLength() {
        return this.maxMessageLength;
    }

    public void setMaxMessageLength(long maxMessageLength) {
        this.maxMessageLength = maxMessageLength;
    }

    public String getHostname() {
        return this.hostname;
    }

    public void setHostname(String hostname) {
        this.hostname = hostname;
    }

    public int getPort() {
        return this.port;
    }

    public void setPort(int port) {
        this.port = port;
    }

    public int getCcsid() {
        return this.ccsid;
    }

    public void setCcsid(int ccsid) {
        this.ccsid = ccsid;
    }

    public String getChannel() {
        return this.channel;
    }

    public void setChannel(String channel) {
        this.channel = channel;
    }

    public int getCharset() {
        return this.charset;
    }

    public void setCharset(int charset) {
        this.charset = charset;
    }

    public int getExpiry() {
        return this.expiry;
    }

    public void setExpiry(int expiry) {
        this.expiry = expiry;
    }

    public MQQueueManager getReaderManager() {
        return this.readerManager;
    }

    public MQQueueManager getWriterManager() {
        return this.writerManager;
    }

    public boolean isCloseFlag() {
        return this.closeFlag;
    }

    public void setCloseFlag(boolean closeFlag) {
        this.closeFlag = closeFlag;
    }
}

