/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.yusp.bsp.communication.impl.in.mq;

import cn.com.yusys.yusp.bsp.communication.DataRequest;
import cn.com.yusys.yusp.bsp.communication.IDataAdapter;
import cn.com.yusys.yusp.bsp.communication.IRequest;
import cn.com.yusys.yusp.bsp.communication.in.AbstractInAdapter;
import cn.com.yusys.yusp.bsp.toolkit.common.StringTools;
import cn.com.yusys.yusp.bsp.toolkit.logback.LogbackUtil;
import com.google.common.util.concurrent.ThreadFactoryBuilder;
import com.rabbitmq.client.AMQP;
import com.rabbitmq.client.Channel;
import com.rabbitmq.client.Connection;
import com.rabbitmq.client.ConnectionFactory;
import com.rabbitmq.client.Consumer;
import com.rabbitmq.client.QueueingConsumer;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;

public class RabbitMQInAdapter
extends AbstractInAdapter
implements IDataAdapter {
    private static final String RABBITIN_ADAPTER_NAME = "RabbitMQ access adapter";
    private String host;
    private int port;
    private String userId;
    private String password;
    private String recQName;
    private String sendQName;
    private String messageId;
    private String correlationId;
    private String head;
    private ConnectionFactory connectionFactory;
    private Connection connection;
    private Channel channel;
    private QueueingConsumer queueingConsumer;
    private ExecutorService singleThreadPool;

    @Override
    public String getAdapterTypeName() {
        return RABBITIN_ADAPTER_NAME;
    }

    @Override
    public void doStart() throws Exception {
        this.rabbitfactoryInit();
        this.validateParams();
        super.doStart();
        this.singleThreadPool = new ThreadPoolExecutor(1, 1, 0L, TimeUnit.MILLISECONDS, new LinkedBlockingQueue<Runnable>(1024), new ThreadFactoryBuilder().setNameFormat(this.getBundlerId() + ":" + this.getPort()).build(), new ThreadPoolExecutor.AbortPolicy());
        this.singleThreadPool.execute(this);
    }

    @Override
    public IRequest makeRequest() throws Exception {
        Map headMap;
        String correlationId;
        String messageId;
        DataRequest request = new DataRequest();
        request.setInAdapter(this);
        HashMap<String, Object> context = new HashMap<String, Object>(16);
        request.setContext(context);
        if (this.queueingConsumer == null) {
            throw new Exception("queueingConsumer is null,maybe module close");
        }
        QueueingConsumer.Delivery delivery = this.queueingConsumer.nextDelivery();
        byte[] msg = delivery.getBody();
        AMQP.BasicProperties prop = delivery.getProperties();
        if (!StringTools.isEmpty(this.messageId) && (messageId = prop.getMessageId()) != null) {
            context.put(messageId, messageId);
            this.logger.debug("{} @ MessageId:{}", (Object)this.getAdapterTypeName(), (Object)messageId);
        }
        if (!StringTools.isEmpty(this.correlationId) && (correlationId = prop.getCorrelationId()) != null) {
            context.put(correlationId, correlationId);
            this.logger.debug("{} @ CorrelationId:{}", (Object)this.getAdapterTypeName(), (Object)correlationId);
        }
        if (!StringTools.isEmpty(this.head) && (headMap = prop.getHeaders()) != null) {
            context.put(this.head, headMap);
            this.logger.debug("{} @ MessageHead:{}", (Object)this.getAdapterTypeName(), (Object)headMap);
        }
        request.setData(msg);
        return request;
    }

    @Override
    public void run() {
        String moduleLog = this.getSid().replaceAll("[.]", "/");
        LogbackUtil.putLogInfo(this.bundlerId, this.moduleId, moduleLog, "", "        ", null);
        boolean okLogger = true;
        while (this.isAlive()) {
            try {
                IRequest req;
                try {
                    if (this.connection == null) {
                        this.connection = this.connectionFactory.newConnection();
                        this.channel = this.connection.createChannel();
                        String queueName = this.getRecQName();
                        this.channel.queueDeclare(queueName, true, false, false, null);
                        this.queueingConsumer = new QueueingConsumer(this.channel);
                        this.channel.basicConsume(queueName, true, (Consumer)this.queueingConsumer);
                    }
                    req = this.makeRequest();
                    if (okLogger) {
                        this.logger.debug("{} @ Successfully connected to the MQ server", (Object)this.getAdapterTypeName());
                    }
                    okLogger = false;
                }
                catch (Exception e) {
                    okLogger = true;
                    this.logger.error("{} @ {}", (Object)this.getAdapterTypeName(), (Object)e.getMessage());
                    Thread.sleep(30000L);
                    continue;
                }
                if (req == null) continue;
                this.dispatcher.triggerRequest(req);
            }
            catch (Throwable e) {
                if (!this.isAlive()) continue;
                try {
                    this.doStop();
                }
                catch (Exception e2) {
                    e2.printStackTrace();
                }
                this.logger.error("{} @ Listener error", (Object)this.getAdapterTypeName(), (Object)e);
                try {
                    Thread.sleep(30000L);
                }
                catch (InterruptedException e1) {
                    e1.printStackTrace();
                    Thread.currentThread().interrupt();
                }
            }
        }
        LogbackUtil.removeLogInfo();
    }

    @Override
    public void unmakeRequest(IRequest request) throws Exception {
        if (request.needToClose()) {
            request.close();
        }
    }

    @Override
    public void doStop() throws Exception {
        if (this.singleThreadPool != null) {
            this.singleThreadPool.shutdown();
            this.singleThreadPool = null;
        }
        try {
            this.queueingConsumer = null;
            super.doStop();
            if (this.channel != null && this.channel.isOpen()) {
                this.channel.close();
            }
            if (this.connection != null && this.connection.isOpen()) {
                this.connection.close();
            }
        }
        catch (Exception e2) {
            e2.printStackTrace();
        }
        this.channel = null;
        this.connection = null;
    }

    @Override
    public void send(IRequest request) throws Exception {
        DataRequest req = (DataRequest)request;
        String queueName = this.getSendQName();
        try {
            Object o;
            if (StringTools.isEmpty(queueName)) {
                throw new Exception(this.getAdapterTypeName() + " @ Send queue name is not configured!");
            }
            AMQP.BasicProperties.Builder builder = new AMQP.BasicProperties.Builder();
            if (!StringTools.isEmpty(this.correlationId) && (o = req.getContext().get(this.correlationId)) != null) {
                builder.correlationId(StringTools.getString(o));
            }
            if (!StringTools.isEmpty(this.messageId) && (o = req.getContext().get(this.messageId)) != null) {
                builder.messageId(StringTools.getString(o));
            }
            if (!StringTools.isEmpty(this.head) && (o = req.getContext().get(this.messageId)) instanceof Map) {
                builder.headers((Map)o);
            }
            AMQP.BasicProperties replyProps = builder.build();
            this.channel.basicPublish("", queueName, replyProps, req.getData());
        }
        catch (Exception e) {
            this.logger.error("{} @ Send message error", (Object)this.getAdapterTypeName(), (Object)e);
            request.setCloseFlag(true);
            this.doStop();
            throw new Exception(this.getAdapterTypeName() + " @ Send message error", e);
        }
    }

    private void validateParams() throws Exception {
        if (StringTools.isEmpty(this.getHost())) {
            throw new Exception(this.getAdapterTypeName() + " @ The listening address is not configured!");
        }
        if (this.getPort() == 0) {
            throw new Exception(this.getAdapterTypeName() + " @ The listening port is not configured!");
        }
        if (StringTools.isEmpty(this.getRecQName())) {
            throw new Exception(this.getAdapterTypeName() + " @ The receiving queue name is not configured!");
        }
    }

    private void rabbitfactoryInit() {
        this.connectionFactory = new ConnectionFactory();
        this.connectionFactory.setHost(this.getHost());
        this.connectionFactory.setPort(this.getPort());
        this.connectionFactory.setUsername(this.getUserId());
        this.connectionFactory.setPassword(this.getPassword());
        this.connectionFactory.setVirtualHost("/");
    }

    public String getHost() {
        return this.host;
    }

    public void setHost(String host) {
        this.host = host;
    }

    public int getPort() {
        return this.port;
    }

    public void setPort(int port) {
        this.port = port;
    }

    public String getRecQName() {
        return this.recQName;
    }

    public void setRecQName(String recQName) {
        this.recQName = recQName;
    }

    public String getSendQName() {
        return this.sendQName;
    }

    public void setSendQName(String sendQName) {
        this.sendQName = sendQName;
    }

    public String getUserId() {
        return this.userId;
    }

    public void setUserId(String userId) {
        this.userId = userId;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public String getMessageId() {
        return this.messageId;
    }

    public void setMessageId(String messageId) {
        this.messageId = messageId;
    }

    public String getCorrelationId() {
        return this.correlationId;
    }

    public void setCorrelationId(String correlationId) {
        this.correlationId = correlationId;
    }

    public String getHead() {
        return this.head;
    }

    public void setHead(String head) {
        this.head = head;
    }

    @Override
    public byte[] receive(IRequest request) {
        return null;
    }
}

