/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.yusp.bsp.communication.impl.in.mq;

import cn.com.yusys.yusp.bsp.communication.DataRequest;
import cn.com.yusys.yusp.bsp.communication.IDataAdapter;
import cn.com.yusys.yusp.bsp.communication.IRequest;
import cn.com.yusys.yusp.bsp.communication.impl.mq.MessageQueueTools;
import cn.com.yusys.yusp.bsp.communication.impl.pool.factory.MessageQueueToolsFactory;
import cn.com.yusys.yusp.bsp.communication.in.AbstractInAdapter;
import cn.com.yusys.yusp.bsp.toolkit.common.PwdTools;
import cn.com.yusys.yusp.bsp.toolkit.common.StringTools;
import cn.com.yusys.yusp.bsp.toolkit.el.ognl.OgnlTools;
import cn.com.yusys.yusp.bsp.toolkit.logback.LogbackUtil;
import com.google.common.util.concurrent.ThreadFactoryBuilder;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;

public class MQInAdapter
extends AbstractInAdapter
implements IDataAdapter {
    private static final String IN_ADAPTER_NAME = "MQ access adapter";
    private boolean doBound;
    private String host;
    private int port;
    private String queueManager;
    private String channel;
    private String userId;
    private String password;
    private String recQName;
    private String sendQName;
    private int ccsid;
    private int charset;
    private int expiry;
    private boolean exchangeFlag;
    private String messageId;
    private String correlationId;
    private String applicationIdData;
    private boolean doSend;
    private String matchFlag;
    private String matchValue;
    private MessageQueueTools messageQueueTools;
    private boolean keepRecvQueue = true;
    MessageQueueToolsFactory factory;
    private ExecutorService singleThreadPool;

    @Override
    public String getAdapterTypeName() {
        return IN_ADAPTER_NAME;
    }

    @Override
    public void doStart() throws Exception {
        super.doStart();
        this.validateParams();
        this.messageQueueTools = this.isDoBound() ? new MessageQueueTools(this.getCcsid(), this.getUserId(), PwdTools.decryptStr(this.getUserId(), this.getPassword())) : new MessageQueueTools(this.getHost(), this.getPort(), this.getChannel(), this.getCcsid(), this.getUserId(), PwdTools.decryptStr(this.getUserId(), this.getPassword()));
        this.messageQueueTools.setCharset(this.getCharset());
        this.messageQueueTools.setExpiry(this.getExpiry());
        this.singleThreadPool = new ThreadPoolExecutor(1, 1, 0L, TimeUnit.MILLISECONDS, new LinkedBlockingQueue<Runnable>(1024), new ThreadFactoryBuilder().setNameFormat(this.getBundlerId() + ":" + this.getPort()).build(), new ThreadPoolExecutor.AbortPolicy());
        this.singleThreadPool.execute(this);
    }

    @Override
    public IRequest makeRequest() throws Exception {
        Map<String, Object> map = this.messageQueueTools.receive(1, -1, this.getMatchFlag(), this.getMatchValue());
        DataRequest request = new DataRequest();
        request.setInAdapter(this);
        request.setDatasourceWrapper(this.messageQueueTools);
        HashMap<String, Object> context = new HashMap<String, Object>(16);
        if (!StringTools.isEmpty(this.getMessageId())) {
            OgnlTools.setValue(this.getMessageId(), map.remove("messageId"), context);
        }
        if (!StringTools.isEmpty(this.getCorrelationId())) {
            OgnlTools.setValue(this.getCorrelationId(), map.remove("correlationId"), context);
        }
        if (!StringTools.isEmpty(this.getApplicationIdData())) {
            OgnlTools.setValue(this.getApplicationIdData(), map.remove("applicationIdData"), context);
        }
        request.setContext(context);
        request.setData((byte[])map.remove("message"));
        return request;
    }

    @Override
    public void run() {
        String moduleLog = this.getSid().replaceAll("[.]", "/");
        LogbackUtil.putLogInfo(this.bundlerId, this.moduleId, moduleLog, "", "        ", null);
        boolean okLogger = true;
        while (this.isAlive()) {
            try {
                IRequest req;
                try {
                    this.messageQueueTools.initRecQueue(this.getQueueManager(), this.getRecQName(), this.isKeepRecvQueue());
                    if (okLogger) {
                        this.logger.debug("{} @ Successfully connected to the MQ server", (Object)this.getAdapterTypeName());
                    }
                    req = this.makeRequest();
                    if (!this.isKeepRecvQueue()) {
                        this.messageQueueTools.closeOnlyRecQueue();
                        this.logger.debug("{} @ {}", (Object)this.getAdapterTypeName(), (Object)"Close the receive queue");
                    }
                    okLogger = false;
                }
                catch (Exception e) {
                    okLogger = true;
                    this.logger.error("{} @ {}", (Object)this.getAdapterTypeName(), (Object)e.getMessage());
                    try {
                        this.messageQueueTools.close();
                    }
                    catch (Exception closeE) {
                        this.logger.error("{} @ Close the receive queue error", (Object)this.getAdapterTypeName(), (Object)closeE);
                    }
                    Thread.sleep(30000L);
                    continue;
                }
                if (req == null) continue;
                this.dispatcher.triggerRequest(req);
            }
            catch (Throwable e) {
                if (!this.isAlive()) continue;
                okLogger = true;
                this.logger.error("{} @ Listener exception", (Object)this.getAdapterTypeName(), (Object)e);
                try {
                    Thread.sleep(30000L);
                }
                catch (InterruptedException e1) {
                    e1.printStackTrace();
                    Thread.currentThread().interrupt();
                }
            }
        }
        LogbackUtil.removeLogInfo();
    }

    @Override
    public void unmakeRequest(IRequest request) throws Exception {
        if (request.needToClose()) {
            this.messageQueueTools.close();
        }
    }

    @Override
    public void doStop() {
        if (this.singleThreadPool != null) {
            this.singleThreadPool.shutdown();
            this.singleThreadPool = null;
        }
        try {
            if (this.messageQueueTools != null) {
                this.messageQueueTools.closeRecQueue();
                this.messageQueueTools = null;
            }
            super.doStop();
            this.messageQueueTools.closeSendQueue();
        }
        catch (Exception e) {
            this.logger.error("{} @ Close application error", (Object)this.getAdapterTypeName(), (Object)e);
        }
    }

    @Override
    public void send(IRequest request) throws Exception {
        if (!this.isDoSend()) {
            throw new Exception(this.getAdapterTypeName() + "In the configuration, the sending channel is not established, and the information cannot be sent.\uff01");
        }
        DataRequest req = (DataRequest)request;
        HashMap<String, Object> map = new HashMap<String, Object>(16);
        Object objMessgeId = null;
        Object objCorrelationId = null;
        Object objApplicationIdData = null;
        if (!StringTools.isEmpty(this.getMessageId())) {
            objMessgeId = OgnlTools.getValue(this.getMessageId(), req.getContext());
        }
        if (!StringTools.isEmpty(this.getCorrelationId())) {
            objCorrelationId = OgnlTools.getValue(this.getCorrelationId(), req.getContext());
        }
        if (!StringTools.isEmpty(this.getApplicationIdData())) {
            objApplicationIdData = OgnlTools.getValue(this.getApplicationIdData(), req.getContext());
        }
        if (this.isExchangeFlag()) {
            map.put("messageId", objCorrelationId);
            map.put("correlationId", objMessgeId);
        } else {
            map.put("messageId", objMessgeId);
            map.put("correlationId", objCorrelationId);
        }
        map.put("applicationIdData", objApplicationIdData);
        try {
            this.messageQueueTools.initSendQueue(this.getQueueManager(), this.getSendQName());
            this.messageQueueTools.send(map, req.getData(), false);
        }
        catch (Exception e) {
            this.logger.error("{} @ Send message error", (Object)this.getAdapterTypeName(), (Object)e);
            request.setCloseFlag(true);
            throw new Exception(this.getAdapterTypeName() + " @ Send message error", e);
        }
    }

    private void validateParams() throws Exception {
        if (!this.isDoBound()) {
            if (StringTools.isEmpty(this.getHost())) {
                throw new Exception(this.getAdapterTypeName() + " @ Service address is not configured!");
            }
            if (StringTools.isEmpty(this.getChannel())) {
                throw new Exception(this.getAdapterTypeName() + " @ The connection channel is not configured!");
            }
        }
        if (this.getPort() == 0) {
            throw new Exception(this.getAdapterTypeName() + " @ The listening port is not configured!");
        }
        if (StringTools.isEmpty(this.getQueueManager())) {
            throw new Exception(this.getAdapterTypeName() + " @ The queue manager is not configured!");
        }
        if (StringTools.isEmpty(this.getRecQName())) {
            throw new Exception(this.getAdapterTypeName() + " @ The receiving queue name is not configured!");
        }
        if (this.isDoSend() && StringTools.isEmpty(this.getSendQName())) {
            throw new Exception(this.getAdapterTypeName() + " @ When establishing a sending channel, you need to configure the sending queue name!");
        }
        if (this.getCcsid() == 0) {
            this.setCcsid(1381);
        }
    }

    public boolean isDoBound() {
        return this.doBound;
    }

    public void setDoBound(boolean doBound) {
        this.doBound = doBound;
    }

    public String getHost() {
        return this.host;
    }

    public void setHost(String host) {
        this.host = host;
    }

    public int getPort() {
        return this.port;
    }

    public void setPort(int port) {
        this.port = port;
    }

    public String getQueueManager() {
        return this.queueManager;
    }

    public void setQueueManager(String queueManager) {
        this.queueManager = queueManager;
    }

    public String getChannel() {
        return this.channel;
    }

    public void setChannel(String channel) {
        this.channel = channel;
    }

    public String getRecQName() {
        return this.recQName;
    }

    public void setRecQName(String recQName) {
        this.recQName = recQName;
    }

    public String getSendQName() {
        return this.sendQName;
    }

    public void setSendQName(String sendQName) {
        this.sendQName = sendQName;
    }

    public int getCcsid() {
        return this.ccsid;
    }

    public void setCcsid(int ccsid) {
        this.ccsid = ccsid;
    }

    public int getCharset() {
        return this.charset;
    }

    public void setCharset(int charset) {
        this.charset = charset;
    }

    public int getExpiry() {
        return this.expiry;
    }

    public void setExpiry(int expiry) {
        this.expiry = expiry;
    }

    public boolean isExchangeFlag() {
        return this.exchangeFlag;
    }

    public void setExchangeFlag(boolean exchangeFlag) {
        this.exchangeFlag = exchangeFlag;
    }

    public String getMessageId() {
        return this.messageId;
    }

    public void setMessageId(String messageId) {
        this.messageId = messageId;
    }

    public String getCorrelationId() {
        return this.correlationId;
    }

    public void setCorrelationId(String correlationId) {
        this.correlationId = correlationId;
    }

    public String getApplicationIdData() {
        return this.applicationIdData;
    }

    public void setApplicationIdData(String applicationIdData) {
        this.applicationIdData = applicationIdData;
    }

    public boolean isDoSend() {
        return this.doSend;
    }

    public void setDoSend(boolean doSend) {
        this.doSend = doSend;
    }

    public String getMatchFlag() {
        return this.matchFlag;
    }

    public void setMatchFlag(String matchFlag) {
        this.matchFlag = matchFlag;
    }

    public String getMatchValue() {
        return this.matchValue;
    }

    public void setMatchValue(String matchValue) {
        this.matchValue = matchValue;
    }

    public String getUserId() {
        return this.userId;
    }

    public void setUserId(String userId) {
        this.userId = userId;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public boolean isKeepRecvQueue() {
        return this.keepRecvQueue;
    }

    public void setKeepRecvQueue(boolean keepRecvQueue) {
        this.keepRecvQueue = keepRecvQueue;
    }

    @Override
    public byte[] receive(IRequest request) throws Exception {
        return null;
    }
}

