/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.yusp.bsp.communication.impl.in.mq;

import cn.cfit.cnccq.jms.CnccqDestination;
import cn.cfit.cnccq.jms.CnccqJmsConsumer;
import cn.cfit.cnccq.jms.CnccqJmsContext;
import cn.cfit.cnccq.jms.CnccqMessage;
import cn.cfit.cnccq.jms.CnccqTextMessage;
import cn.cfit.cnccq.netty.TcpConnection;
import cn.cfit.cnccq.pool.CnccqJmsConnectionPooledFactory;
import cn.com.yusys.yusp.bsp.communication.DataRequest;
import cn.com.yusys.yusp.bsp.communication.IDataAdapter;
import cn.com.yusys.yusp.bsp.communication.IRequest;
import cn.com.yusys.yusp.bsp.communication.in.AbstractInAdapter;
import cn.com.yusys.yusp.bsp.toolkit.common.StringTools;
import cn.com.yusys.yusp.bsp.toolkit.logback.LogbackUtil;
import java.time.Duration;
import java.util.HashMap;
import javax.jms.Destination;
import javax.jms.Message;
import javax.jms.MessageListener;
import org.apache.commons.pool2.PooledObjectFactory;
import org.apache.commons.pool2.impl.GenericObjectPool;
import org.apache.commons.pool2.impl.GenericObjectPoolConfig;

public class CnccqMqInAdapter
extends AbstractInAdapter
implements IDataAdapter,
MessageListener {
    private static final String IN_ADAPTER_NAME = "CNCCQ JMS\u63a5\u5165\u9002\u914d\u5668";
    private String host;
    private int port;
    private String queueManager;
    private int priority;
    private int maxTotal;
    private int maxIdle;
    private int minIdle;
    private String consumerQueueName;
    private String producerQueueName;
    private boolean producerAutoCommit;
    private String messageId;
    private String correlationId;
    private long timeBetweenEvictionRunsMillis;
    private long maxWaitMillis;
    private long sleepDate;
    CnccqJmsContext cnccqJmsContext;
    CnccqJmsConsumer consumerCustom;
    CnccqJmsConnectionPooledFactory factory;
    GenericObjectPool<TcpConnection> connectPool;

    @Override
    public String getAdapterTypeName() {
        return IN_ADAPTER_NAME;
    }

    @Override
    public void doStart() throws Exception {
        super.doStart();
        this.validateParams();
        this.factory = new CnccqJmsConnectionPooledFactory(this.host, this.port, this.queueManager);
        this.connectPool = this.connectPool(this.factory);
        new Thread((Runnable)this, this.getSid() + ":" + this.getPort()).start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        block25: {
            String moduleLog = this.getSid().replaceAll("[.]", "/");
            LogbackUtil.putLogInfo(this.bundlerId, this.moduleId, moduleLog, "", "        ", null);
            this.cnccqJmsContext = this.factory.createContext(this.connectPool);
            CnccqDestination cnccqDestination = new CnccqDestination(this.getConsumerQueueName(), this.getQueueManager());
            block15: while (true) {
                while (this.isAlive()) {
                    CnccqTextMessage message = null;
                    try {
                        if (this.consumerCustom == null) {
                            this.consumerCustom = (CnccqJmsConsumer)this.cnccqJmsContext.createConsumer((Destination)cnccqDestination, false);
                        }
                        if ((message = (CnccqTextMessage)this.consumerCustom.receive()) != null) {
                            try {
                                DataRequest req = new DataRequest();
                                req.setData(message.getContent().data);
                                HashMap<String, Object> context = new HashMap<String, Object>();
                                if (message.getJMSCorrelationID() != null && !StringTools.isEmpty(this.getCorrelationId())) {
                                    context.put(this.getCorrelationId(), StringTools.getString(message.getJMSCorrelationID()));
                                }
                                if (!StringTools.isEmpty(this.getMessageId())) {
                                    context.put(this.getMessageId(), message.getJMSMessageID());
                                }
                                req.setContext(context);
                                req.setInAdapter(this);
                                if (req != null) {
                                    this.getDispatcher().triggerRequest(req);
                                }
                                this.consumerCustom.commit();
                            }
                            catch (Exception e) {
                                this.logger.error("{} @ \u63a5\u6536\u6d88\u606f\u5f02\u5e38", (Object)this.getAdapterTypeName(), (Object)e);
                            }
                            continue block15;
                        }
                        this.sleep();
                        continue block15;
                    }
                    catch (Exception var5) {
                        this.logger.error("{} @ CNCCQ\u8fde\u63a5\u5f02\u5e38", (Object)this.getAdapterTypeName(), (Object)var5);
                        try {
                            if (message != null) {
                                this.consumerCustom.rollback();
                            }
                        }
                        catch (Exception e) {
                            this.logger.error("{} @ \u56de\u6eda\u5f02\u5e38", (Object)this.getAdapterTypeName(), (Object)e);
                        }
                        try {
                            Thread.sleep(5000L);
                            continue block15;
                        }
                        catch (InterruptedException interruptedException) {
                        }
                    }
                }
                break block25;
                {
                    continue block15;
                    break;
                }
                break;
            }
            finally {
                try {
                    if (this.consumerCustom != null) {
                        this.consumerCustom.close();
                        this.consumerCustom = null;
                    }
                    if (this.cnccqJmsContext != null) {
                        this.cnccqJmsContext.close();
                    }
                }
                catch (Exception e) {
                    this.logger.error("{} @ \u5173\u95ed\u8fde\u63a5\u5f02\u5e38", (Object)this.getAdapterTypeName(), (Object)e);
                }
            }
        }
    }

    @Override
    public IRequest makeRequest() throws Exception {
        return null;
    }

    @Override
    public void send(IRequest request) throws Exception {
        throw new Exception(this.getAdapterTypeName() + " @ \u6682\u4e0d\u652f\u6301\u53d1\u9001!");
    }

    @Override
    public byte[] receive(IRequest request) throws Exception {
        return null;
    }

    @Override
    public void unmakeRequest(IRequest req) throws Exception {
    }

    @Override
    public void doStop() throws Exception {
    }

    private void validateParams() throws Exception {
        if (StringTools.isEmpty(this.getHost())) {
            throw new Exception(this.getAdapterTypeName() + " @ \u670d\u52a1\u5730\u5740\u672a\u914d\u7f6e!");
        }
        if (this.getPort() == 0) {
            throw new Exception(this.getAdapterTypeName() + " @ \u76d1\u542c\u7aef\u53e3\u672a\u914d\u7f6e!");
        }
        if (StringTools.isEmpty(this.getQueueManager())) {
            throw new Exception(this.getAdapterTypeName() + " @ \u961f\u5217\u7ba1\u7406\u5668\u672a\u914d\u7f6e!");
        }
        if (StringTools.isEmpty(this.getConsumerQueueName())) {
            throw new Exception(this.getAdapterTypeName() + " @ \u76d1\u542c\u961f\u5217\u540d\u79f0\u672a\u914d\u7f6e!");
        }
    }

    public GenericObjectPool<TcpConnection> connectPool(CnccqJmsConnectionPooledFactory pooledFactory) {
        GenericObjectPoolConfig poolConfig = new GenericObjectPoolConfig();
        poolConfig.setMaxIdle(this.getMaxIdle());
        poolConfig.setMaxTotal(this.getMaxTotal());
        poolConfig.setMinIdle(this.getMinIdle());
        poolConfig.setBlockWhenExhausted(true);
        poolConfig.setMaxWait(Duration.ofMinutes(this.getMaxWaitMillis()));
        poolConfig.setTestOnCreate(false);
        poolConfig.setTestOnBorrow(true);
        poolConfig.setTestOnReturn(true);
        poolConfig.setTimeBetweenEvictionRuns(Duration.ofMinutes(this.getTimeBetweenEvictionRunsMillis()));
        poolConfig.setTestWhileIdle(false);
        poolConfig.setJmxEnabled(false);
        return new GenericObjectPool((PooledObjectFactory)pooledFactory, poolConfig);
    }

    public void onMessage(Message message) {
        DataRequest req = new DataRequest();
        try {
            req.setData(((CnccqMessage)message).getContent().data);
            HashMap<String, Object> context = new HashMap<String, Object>();
            if (message.getJMSCorrelationID() != null && !StringTools.isEmpty(this.getCorrelationId())) {
                context.put(this.getCorrelationId(), StringTools.getString(message.getJMSCorrelationID()));
            }
            if (!StringTools.isEmpty(this.getMessageId())) {
                context.put(this.getMessageId(), message.getJMSMessageID());
            }
            req.setContext(context);
            req.setInAdapter(this);
            if (req != null) {
                this.getDispatcher().triggerRequest(req);
            }
        }
        catch (Exception e) {
            this.logger.error("{} @ \u63a5\u6536\u6d88\u606f\u5f02\u5e38", (Object)this.getAdapterTypeName(), (Object)e);
        }
    }

    private void sleep() {
        try {
            Thread.sleep(this.getSleepDate());
        }
        catch (InterruptedException var2) {
            this.logger.info("{} @ CnccqJmsConsumer  error\uff1a{}", (Throwable)var2);
        }
    }

    public String getHost() {
        return this.host;
    }

    public void setHost(String host) {
        this.host = host;
    }

    public int getPort() {
        return this.port;
    }

    public void setPort(int port) {
        this.port = port;
    }

    public String getQueueManager() {
        return this.queueManager;
    }

    public void setQueueManager(String queueManager) {
        this.queueManager = queueManager;
    }

    public int getPriority() {
        return this.priority;
    }

    public void setPriority(int priority) {
        this.priority = priority;
    }

    public int getMaxTotal() {
        return this.maxTotal;
    }

    public void setMaxTotal(int maxTotal) {
        this.maxTotal = maxTotal;
    }

    public int getMaxIdle() {
        return this.maxIdle;
    }

    public void setMaxIdle(int maxIdle) {
        this.maxIdle = maxIdle;
    }

    public int getMinIdle() {
        return this.minIdle;
    }

    public void setMinIdle(int minIdle) {
        this.minIdle = minIdle;
    }

    public String getMessageId() {
        return this.messageId;
    }

    public void setMessageId(String messageId) {
        this.messageId = messageId;
    }

    public String getCorrelationId() {
        return this.correlationId;
    }

    public void setCorrelationId(String correlationId) {
        this.correlationId = correlationId;
    }

    public String getConsumerQueueName() {
        return this.consumerQueueName;
    }

    public void setConsumerQueueName(String consumerQueueName) {
        this.consumerQueueName = consumerQueueName;
    }

    public String getProducerQueueName() {
        return this.producerQueueName;
    }

    public void setProducerQueueName(String producerQueueName) {
        this.producerQueueName = producerQueueName;
    }

    public boolean isProducerAutoCommit() {
        return this.producerAutoCommit;
    }

    public void setProducerAutoCommit(boolean producerAutoCommit) {
        this.producerAutoCommit = producerAutoCommit;
    }

    public long getTimeBetweenEvictionRunsMillis() {
        return this.timeBetweenEvictionRunsMillis;
    }

    public void setTimeBetweenEvictionRunsMillis(long timeBetweenEvictionRunsMillis) {
        this.timeBetweenEvictionRunsMillis = timeBetweenEvictionRunsMillis;
    }

    public long getMaxWaitMillis() {
        return this.maxWaitMillis;
    }

    public void setMaxWaitMillis(long maxWaitMillis) {
        this.maxWaitMillis = maxWaitMillis;
    }

    public long getSleepDate() {
        return this.sleepDate;
    }

    public void setSleepDate(long sleepDate) {
        this.sleepDate = sleepDate;
    }
}

