/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.yusp.bsp.app.config;

import cn.com.yusys.yusp.bsp.app.config.AppStartAssist;
import cn.com.yusys.yusp.bsp.app.config.ModulePath;
import cn.com.yusys.yusp.bsp.config.ModuleHelper;
import cn.com.yusys.yusp.bsp.dataformat.factory.DataFormatFactory;
import cn.com.yusys.yusp.bsp.method.factory.MethodFactory;
import cn.com.yusys.yusp.bsp.resources.ClassLoaderRegistry;
import cn.com.yusys.yusp.bsp.toolkit.common.FileChecker;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.context.ApplicationContext;
import org.springframework.core.env.Environment;

public class BspBoot
implements InitializingBean,
DisposableBean {
    private static final Logger logger = LoggerFactory.getLogger(BspBoot.class);
    public static ApplicationContext applicationContext;
    private final AppStartAssist appStartAssist;

    public BspBoot(ApplicationContext applicationContext, AppStartAssist appStartAssist) {
        BspBoot.applicationContext = applicationContext;
        this.appStartAssist = appStartAssist;
    }

    public void startServer() throws Exception {
        logger.info("Start communication service!");
        Class<BspBoot> clazz = BspBoot.class;
        MethodFactory.registerComponents(clazz);
        DataFormatFactory.registerComponents(clazz);
        ClassLoaderRegistry.registryClassLoader(clazz.getClassLoader());
        Environment env = applicationContext.getEnvironment();
        ModulePath.setModel(env.getProperty("bsp.model"));
        ModulePath.setConfigPath(env.getProperty("bsp.configPath"));
        this.appStartAssist.startModule();
        logger.info("Communication service start completed!");
    }

    public void stopServer() {
        logger.info("Communication service is about to quit...");
        ModuleHelper.stopModule();
        logger.info("Communication service quit successfully!");
    }

    public void destroy() {
        this.stopServer();
    }

    public void afterPropertiesSet() throws Exception {
        FileChecker.getDefaultInstance();
        this.startServer();
    }
}

