/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.yusp.bsp.workflow.comm.out.impl;

import cn.com.yusys.yusp.bsp.communication.AbstractRequest;
import cn.com.yusys.yusp.bsp.communication.SocketWrapper;
import cn.com.yusys.yusp.bsp.communication.StreamRequest;
import cn.com.yusys.yusp.bsp.communication.impl.out.tcp.TcpOutAdapter;
import cn.com.yusys.yusp.bsp.component.exception.ComponentException;
import cn.com.yusys.yusp.bsp.resources.Session;
import cn.com.yusys.yusp.bsp.toolkit.common.Base64Tools;
import cn.com.yusys.yusp.bsp.toolkit.common.ByteTools;
import cn.com.yusys.yusp.bsp.toolkit.common.StringTools;
import cn.com.yusys.yusp.bsp.toolkit.reflect.BeanMapUtil;
import cn.com.yusys.yusp.bsp.workflow.comm.out.AbstractCommOut;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.net.Socket;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.Header;
import org.apache.http.HeaderElement;
import org.apache.http.HttpClientConnection;
import org.apache.http.HttpEntity;
import org.apache.http.HttpException;
import org.apache.http.HttpHost;
import org.apache.http.HttpMessage;
import org.apache.http.HttpRequest;
import org.apache.http.HttpRequestInterceptor;
import org.apache.http.HttpResponse;
import org.apache.http.HttpResponseFactory;
import org.apache.http.HttpResponseInterceptor;
import org.apache.http.HttpVersion;
import org.apache.http.MethodNotSupportedException;
import org.apache.http.NameValuePair;
import org.apache.http.ProtocolException;
import org.apache.http.ProtocolVersion;
import org.apache.http.UnsupportedHttpVersionException;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.entity.AbstractHttpEntity;
import org.apache.http.entity.ByteArrayEntity;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.mime.HttpMultipartMode;
import org.apache.http.entity.mime.MultipartEntityBuilder;
import org.apache.http.impl.DefaultConnectionReuseStrategy;
import org.apache.http.impl.DefaultHttpClientConnection;
import org.apache.http.impl.DefaultHttpResponseFactory;
import org.apache.http.message.BasicHeader;
import org.apache.http.message.BasicHttpEntityEnclosingRequest;
import org.apache.http.message.BasicHttpRequest;
import org.apache.http.message.BasicNameValuePair;
import org.apache.http.params.HttpParams;
import org.apache.http.params.HttpProtocolParams;
import org.apache.http.params.SyncBasicHttpParams;
import org.apache.http.protocol.BasicHttpContext;
import org.apache.http.protocol.HttpContext;
import org.apache.http.protocol.HttpProcessor;
import org.apache.http.protocol.HttpRequestExecutor;
import org.apache.http.protocol.HttpService;
import org.apache.http.protocol.ImmutableHttpProcessor;
import org.apache.http.protocol.RequestConnControl;
import org.apache.http.protocol.RequestContent;
import org.apache.http.protocol.RequestDate;
import org.apache.http.protocol.RequestExpectContinue;
import org.apache.http.protocol.RequestTargetHost;
import org.apache.http.protocol.RequestUserAgent;
import org.apache.http.protocol.ResponseConnControl;
import org.apache.http.protocol.ResponseContent;
import org.apache.http.protocol.ResponseDate;
import org.apache.http.protocol.ResponseServer;
import org.apache.http.util.EntityUtils;

public class HttpCommOut
extends AbstractCommOut
implements Serializable {
    private static final long serialVersionUID = 1L;
    protected static final String COMM_ATTRIBUTE_SEND_HEAD = "sendHead";
    protected static final String HTTP_HEADER_SOAPACTION = "SoapAction";
    protected static final String DEFAULT_VALUE_CONTENT_TYPE = "text/xml; charset=UTF-8";
    protected static final String MULTIPART_FORM_DATA_VALUE = "multipart/form-data";
    protected static final String APPLICATION_FORM_URLENCODED_VALUE = "application/x-www-form-urlencoded";
    protected HttpRequestExecutor httpexecutor = new HttpRequestExecutor();
    HttpService httpService = null;
    protected volatile HttpResponseFactory responseFactory = new DefaultHttpResponseFactory();
    protected static final String HTTP_REQUEST_METHOD_POST = "POST";
    protected static final String HTTP_REQUEST_METHOD_GET = "GET";
    protected String unitName = "HTTP communication dial-out";
    private String method;
    private String contentType;
    private String sendHead;
    private String uri;
    private String soapAction;
    private String userAgent;
    private String recvHead;
    private String trace;

    @Override
    public byte[] processExch(Map<String, Object> context, byte[] sendData, AbstractRequest request) throws Exception {
        String contentType;
        String uri = HttpCommOut.getInExpressStringValue(this.uri, context);
        if (StringTools.isEmpty(uri)) {
            uri = "/";
        }
        if (StringTools.isEmpty(this.method)) {
            this.method = HTTP_REQUEST_METHOD_POST;
        }
        if (StringTools.isEmpty(contentType = HttpCommOut.getInExpressStringValue(this.contentType, context))) {
            contentType = DEFAULT_VALUE_CONTENT_TYPE;
        }
        Map<String, String> headers = new HashMap(16);
        Object sendHead = this.getInExpressObjectValue(this.sendHead, context);
        if (sendHead != null) {
            if (sendHead instanceof Map) {
                headers = (Map)sendHead;
            } else {
                this.logger.debug("{} @ Sending message header is not Map[{}]:{}", new Object[]{this.getUnitName(), COMM_ATTRIBUTE_SEND_HEAD, sendHead});
                headers = StringTools.string2Map(sendHead.toString());
            }
        }
        headers.remove("Content-Length");
        if (!StringTools.isEmpty(this.soapAction)) {
            headers.put(HTTP_HEADER_SOAPACTION, this.soapAction);
        }
        return this.processExch(context, sendData, request, uri, contentType, headers);
    }

    private byte[] processExch(Map<String, Object> context, byte[] sendData, AbstractRequest request, String uri, String contentType, Map<String, String> headers) throws Exception {
        boolean checked;
        String trueFlag = "true";
        String traceValue = HttpCommOut.getInExpressStringValue(this.trace, context);
        if (trueFlag.equals(traceValue)) {
            Session session = (Session)context.get("T_SESSION");
            headers.put("X-B3-TraceId", session.getSessionId());
            headers.put("X-B3-SpanId", session.getSessionId());
            headers.put("X-B3-Sampled", "1");
        }
        HttpParams params = this.getHttpParams(contentType, context);
        HttpProcessor httpProc = this.getHttpClientProcessor();
        BasicHttpContext httpContext = new BasicHttpContext(null);
        DefaultHttpClientConnection conn = new DefaultHttpClientConnection();
        DefaultConnectionReuseStrategy connStrategy = new DefaultConnectionReuseStrategy();
        httpContext.setAttribute("http.connection", (Object)conn);
        if (!conn.isOpen()) {
            this.bindSocket(request, params, conn);
            this.addHost(context, request, headers);
        }
        HttpHost host = new HttpHost(conn.getRemoteAddress().getHostAddress(), conn.getRemotePort());
        httpContext.setAttribute("http.connection", (Object)conn);
        httpContext.setAttribute("http.target_host", (Object)host);
        BasicHttpEntityEnclosingRequest httpRequest = null;
        HttpEntity httpEntity = null;
        if (HTTP_REQUEST_METHOD_POST.equals(this.method)) {
            httpRequest = new BasicHttpEntityEnclosingRequest(HTTP_REQUEST_METHOD_POST, uri, (ProtocolVersion)HttpVersion.HTTP_1_1);
            String charset = HttpProtocolParams.getContentCharset((HttpParams)params);
            if (contentType.startsWith(MULTIPART_FORM_DATA_VALUE)) {
                httpEntity = this.buildMultipartEntity(sendData, charset);
            } else if (contentType.startsWith(APPLICATION_FORM_URLENCODED_VALUE)) {
                httpEntity = this.buildUrlEncodedFormEntity(sendData, charset);
            } else {
                httpEntity = new ByteArrayEntity(sendData);
                ((AbstractHttpEntity)httpEntity).setContentType(contentType);
            }
            httpRequest.setEntity(httpEntity);
        } else if (HTTP_REQUEST_METHOD_GET.equals(this.method)) {
            httpRequest = new BasicHttpRequest(HTTP_REQUEST_METHOD_GET, uri);
        } else {
            throw new Exception("Type not supported");
        }
        httpRequest.setHeaders(this.buildHeader(headers));
        httpRequest.setParams(params);
        this.httpexecutor.preProcess((HttpRequest)httpRequest, httpProc, (HttpContext)httpContext);
        this.logHeader((HttpRequest)httpRequest);
        boolean bl = checked = httpEntity != null && (contentType.startsWith(MULTIPART_FORM_DATA_VALUE) || contentType.startsWith(APPLICATION_FORM_URLENCODED_VALUE));
        if (checked) {
            sendData = this.getSendDataFromEntity(httpEntity);
        }
        this.printSendData(sendData);
        HttpResponse httpResponse = this.httpexecutor.execute((HttpRequest)httpRequest, (HttpClientConnection)conn, (HttpContext)httpContext);
        httpResponse.setParams(params);
        this.httpexecutor.postProcess(httpResponse, httpProc, (HttpContext)httpContext);
        headers = this.parserHeader((HttpMessage)httpResponse);
        int base200Num = 200;
        if (httpResponse.getStatusLine().getStatusCode() != base200Num) {
            throw new ComponentException("Return status error:" + httpResponse + "\n" + EntityUtils.toString((HttpEntity)httpResponse.getEntity()));
        }
        context.put(this.recvHead, headers);
        this.logHeader(httpResponse);
        HttpEntity responseEntity = httpResponse.getEntity();
        byte[] rspData = new byte[]{};
        if (responseEntity != null) {
            rspData = EntityUtils.toByteArray((HttpEntity)responseEntity);
            this.printRecvData(rspData);
        }
        if (!connStrategy.keepAlive(httpResponse, (HttpContext)httpContext)) {
            request.setCloseFlag(true);
        }
        return rspData;
    }

    private void bindSocket(AbstractRequest request, HttpParams params, DefaultHttpClientConnection conn) throws Exception {
        Socket socket = null;
        if (request instanceof StreamRequest) {
            Object dw = request.getDatasourceWrapper();
            if (dw instanceof SocketWrapper) {
                socket = ((SocketWrapper)dw).getSocket();
            } else if (dw instanceof Socket) {
                socket = (Socket)dw;
            }
            if (socket == null) {
                throw new Exception("Get connection is empty");
            }
            if (params.getParameter("http.socket.timeout") == null) {
                params.setIntParameter("http.socket.timeout", socket.getSoTimeout());
            }
            conn.bind(socket, params);
        }
    }

    private void addHost(Map<String, Object> context, AbstractRequest request, Map<String, String> headers) {
        String baseHostString = "Host";
        if (headers.get(baseHostString) == null && request.getOutAdapter() instanceof TcpOutAdapter) {
            Object op;
            TcpOutAdapter tcpOutAdapter = (TcpOutAdapter)request.getOutAdapter();
            String hostValue = tcpOutAdapter.getHost();
            String portValue = tcpOutAdapter.getPort();
            Object oh = context.get(hostValue);
            if (oh == null) {
                oh = hostValue;
            }
            if ((op = context.get(portValue)) == null) {
                op = portValue;
            }
            String base80String = "80";
            String base443String = "443";
            if (base80String.equals(op) || base443String.equals(op)) {
                headers.put("Host", StringTools.getString(oh));
            } else {
                headers.put("Host", StringTools.getString(oh) + ":" + StringTools.getString(op));
            }
        }
    }

    public String getMethod() {
        return this.method;
    }

    public void setMethod(String method) {
        this.method = method;
    }

    public String getContentType() {
        return this.contentType;
    }

    public void setContentType(String contentType) {
        this.contentType = contentType;
    }

    public String getSendHead() {
        return this.sendHead;
    }

    public void setSendHead(String sendHead) {
        this.sendHead = sendHead;
    }

    public String getUri() {
        return this.uri;
    }

    public void setUri(String uri) {
        this.uri = uri;
    }

    public String getSoapAction() {
        return this.soapAction;
    }

    public void setSoapAction(String soapAction) {
        this.soapAction = soapAction;
    }

    public String getUserAgent() {
        return this.userAgent;
    }

    public void setUserAgent(String userAgent) {
        this.userAgent = userAgent;
    }

    public String getRecvHead() {
        return this.recvHead;
    }

    public void setRecvHead(String recvHead) {
        this.recvHead = recvHead;
    }

    public String getTrace() {
        return this.trace;
    }

    public void setTrace(String trace) {
        this.trace = trace;
    }

    @Override
    public String getUnitName() {
        return this.unitName;
    }

    public void setUnitName(String unitName) {
        this.unitName = unitName;
    }

    protected Map<String, String> parserHeader(HttpMessage httpMessage) {
        HashMap<String, String> map = new HashMap<String, String>(16);
        if (httpMessage instanceof HttpRequest) {
            HttpRequest req = (HttpRequest)httpMessage;
            map.put("method", req.getRequestLine().getMethod());
            map.put("uri", req.getRequestLine().getUri());
            map.put("protocol", req.getRequestLine().getProtocolVersion().getProtocol());
        }
        for (Header h : httpMessage.getAllHeaders()) {
            map.put(h.getName(), h.getValue());
        }
        return map;
    }

    private void logParams(Map<String, String> map, String headkey) {
        if (this.logger.isDebugEnabled()) {
            StringBuilder sb = new StringBuilder();
            for (Map.Entry<String, String> entry : map.entrySet()) {
                String key = entry.getKey();
                String value = entry.getValue();
                sb.append(headkey).append(".").append(key);
                sb.append("=");
                sb.append(value);
                sb.append("\n");
            }
            this.logger.debug(sb.toString());
        }
    }

    protected void logHeader(HttpRequest request) {
        if (this.logger.isInfoEnabled()) {
            this.logger.info("{} @ Reuqest HTTP header:\n{}", (Object)this.getUnitName(), (Object)request);
        }
    }

    protected void logHeader(HttpResponse response) {
        if (this.logger.isInfoEnabled()) {
            this.logger.info("{} @ Return HTTP header:\n{}", (Object)this.getUnitName(), (Object)response);
        }
    }

    protected Header[] buildHeader(Map<String, String> headers) {
        Header[] heads = new Header[headers.size()];
        int i = 0;
        for (String key : headers.keySet()) {
            BasicHeader head = new BasicHeader(key, headers.get(key));
            heads[i] = head;
            ++i;
        }
        return heads;
    }

    protected HttpParams getHttpParams(String contentType, Map<String, Object> context) throws Exception {
        NameValuePair param;
        BasicHeader header;
        HeaderElement[] values;
        String charset = "UTF-8";
        if (contentType != null && (values = (header = new BasicHeader("Content-Type", contentType)).getElements()).length > 0 && (param = values[0].getParameterByName("charset")) != null) {
            charset = param.getValue();
        }
        SyncBasicHttpParams params = new SyncBasicHttpParams();
        HttpProtocolParams.setVersion((HttpParams)params, (ProtocolVersion)HttpVersion.HTTP_1_1);
        HttpProtocolParams.setContentCharset((HttpParams)params, (String)charset);
        String userAgent = HttpCommOut.getInExpressStringValue(this.userAgent, context);
        if (userAgent == null || userAgent.length() == 0) {
            userAgent = "BSP-HttpClient/1.1";
        }
        HttpProtocolParams.setUserAgent((HttpParams)params, (String)userAgent);
        HttpProtocolParams.setUseExpectContinue((HttpParams)params, (boolean)false);
        params.setParameter("http.origin-server", (Object)"BSP-HttpServer/1.1");
        params.setIntParameter("http.socket.buffer-size", 8192).setBooleanParameter("http.connection.stalecheck", false).setBooleanParameter("http.tcp.nodelay", true);
        params.setIntParameter("http.connection.timeout", 10000);
        return params;
    }

    protected HttpProcessor getHttpClientProcessor() {
        return new ImmutableHttpProcessor(new HttpRequestInterceptor[]{new RequestContent(), new RequestTargetHost(), new RequestConnControl(), new RequestUserAgent(), new RequestExpectContinue(), new RequestDate()});
    }

    protected HttpProcessor getHttpServerProcessor() {
        return new ImmutableHttpProcessor(new HttpResponseInterceptor[]{new ResponseContent(), new ResponseConnControl(), new ResponseServer(), new ResponseDate()});
    }

    protected void handleException(HttpException ex, HttpResponse response) throws UnsupportedEncodingException {
        if (ex instanceof MethodNotSupportedException) {
            response.setStatusCode(501);
        } else if (ex instanceof UnsupportedHttpVersionException) {
            response.setStatusCode(505);
        } else if (ex instanceof ProtocolException) {
            response.setStatusCode(400);
        } else {
            response.setStatusCode(500);
        }
        byte[] msg = ByteTools.getBytes(StringTools.printExceptionStackTrace(ex), "UTF-8");
        ByteArrayEntity entity = new ByteArrayEntity(msg);
        entity.setContentType("text/plain; charset=UTF-8");
        response.setEntity((HttpEntity)entity);
    }

    protected HttpEntity buildMultipartEntity(Object data, String charset) throws Exception {
        Map<String, Object> parse;
        if (data == null) {
            throw new ComponentException("MultipartEntity data is empty", this.getUnitName(), this.getUnitName());
        }
        try {
            BeanMapUtil util = new BeanMapUtil();
            parse = util.jsonToMap(StringTools.getString(data, charset));
        }
        catch (Exception e) {
            throw new ComponentException("Failed to parse MultipartEntity data", (Throwable)e, this.getUnitName(), this.getUnitName());
        }
        MultipartEntityBuilder builder = MultipartEntityBuilder.create().setMode(HttpMultipartMode.RFC6532);
        Iterator<Map.Entry<String, Object>> iterator = parse.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<String, Object> o;
            Map.Entry<String, Object> next = o = iterator.next();
            String key = next.getKey();
            Map valMap = (Map)next.getValue();
            String filename = (String)valMap.get("fileName");
            String value = (String)valMap.get("value");
            String contentType = (String)valMap.get("contentType");
            if (valMap.containsKey("fileName") && !StringTools.isEmpty(filename)) {
                builder.addBinaryBody(key, Base64Tools.decode(value), this.getContentType(contentType, ContentType.DEFAULT_BINARY, charset), filename);
                continue;
            }
            builder.addTextBody(key, value, this.getContentType(contentType, ContentType.DEFAULT_TEXT, charset));
        }
        return builder.build();
    }

    protected UrlEncodedFormEntity buildUrlEncodedFormEntity(Object data, String charset) throws Exception {
        Map<String, Object> parse;
        if (data == null) {
            throw new ComponentException("UrlEncodedFormEntity data is empty", this.getUnitName(), this.getUnitName());
        }
        try {
            BeanMapUtil util = new BeanMapUtil();
            parse = util.jsonToMap(StringTools.getString(data, charset));
        }
        catch (Exception e) {
            throw new ComponentException("Failed to parse UrlEncodedFormEntity data", (Throwable)e, this.getUnitName(), this.getUnitName());
        }
        ArrayList<BasicNameValuePair> sendData = new ArrayList<BasicNameValuePair>();
        for (String obj : parse.keySet()) {
            sendData.add(new BasicNameValuePair(Objects.requireNonNull(StringTools.getString(obj)), StringTools.getString(parse.get(obj))));
        }
        return new UrlEncodedFormEntity(sendData, charset);
    }

    protected byte[] getSendDataFromEntity(HttpEntity httpEntity) throws IOException {
        ByteArrayOutputStream outstream = new ByteArrayOutputStream();
        httpEntity.writeTo((OutputStream)outstream);
        outstream.flush();
        return outstream.toByteArray();
    }

    private ContentType getContentType(String content, ContentType defaultContentType, String charset) {
        ContentType contentType = defaultContentType;
        if (!StringUtils.isEmpty((CharSequence)content)) {
            contentType = ContentType.create((String)content, (String)charset);
        }
        return contentType;
    }
}

