/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.yusp.bsp.toolkit.xml;

import cn.com.yusys.yusp.bsp.toolkit.xml.XMLNode;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.xml.stream.XMLEventFactory;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLEventWriter;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.events.Attribute;
import javax.xml.stream.events.Characters;
import javax.xml.stream.events.Namespace;
import javax.xml.stream.events.StartElement;
import javax.xml.stream.events.XMLEvent;

public class StaxTools {
    private static XMLEventFactory eventFactory = XMLEventFactory.newInstance();
    private static XMLInputFactory inputFactory = XMLInputFactory.newInstance();
    private static XMLOutputFactory outputFactory = XMLOutputFactory.newInstance();
    private String encoding = "utf-8";
    private boolean packXml = true;

    public StaxTools() {
    }

    public StaxTools(String encoding) {
        this.encoding = encoding;
    }

    public XMLNode readerXML(byte[] data) throws Exception {
        LinkedList<String> nodeList = new LinkedList<String>();
        String str = null;
        XMLEvent event = null;
        XMLNode xml = null;
        XMLNode node = null;
        try (XMLEventReader reader = null;){
            reader = inputFactory.createXMLEventReader(new ByteArrayInputStream(data), this.encoding);
            while (reader.hasNext()) {
                event = reader.nextEvent();
                if (event.isStartDocument()) continue;
                if (event.isStartElement()) {
                    StartElement startElement = event.asStartElement();
                    String nodeName = startElement.getName().getLocalPart();
                    nodeList.add(nodeName);
                    node = new XMLNode(nodeName);
                    Iterator<Namespace> nameSpaces = startElement.getNamespaces();
                    Namespace nameSpace = null;
                    while (nameSpaces.hasNext()) {
                        nameSpace = nameSpaces.next();
                        node.addNamespace(nameSpace.getPrefix(), nameSpace.getNamespaceURI());
                    }
                    Iterator<Attribute> attrs = startElement.getAttributes();
                    Attribute attr = null;
                    while (attrs.hasNext()) {
                        attr = attrs.next();
                        node.addAttrs(attr.getName().getLocalPart(), attr.getValue());
                    }
                    if (xml == null) {
                        xml = node;
                        continue;
                    }
                    this.getFatherNode(xml, nodeList).addChild(node);
                    continue;
                }
                if (event.isCharacters()) {
                    Characters character = event.asCharacters();
                    if (character.isWhiteSpace()) continue;
                    if (character.isCData()) {
                        str = event.asCharacters().getData();
                        node.setCDATA(str);
                        continue;
                    }
                    str = event.asCharacters().getData();
                    node.setValue(str);
                    continue;
                }
                if (event.isEndElement()) {
                    nodeList.removeLast();
                    continue;
                }
                if (!event.isEndDocument()) continue;
                break;
            }
        }
        return xml;
    }

    public byte[] writeXML(XMLNode xml) throws Exception {
        ByteArrayOutputStream buildStream = new ByteArrayOutputStream();
        byte[] data = null;
        XMLEventWriter writer = null;
        try {
            writer = outputFactory.createXMLEventWriter(buildStream, this.getEncoding());
            if (this.isPackXml()) {
                writer.add(eventFactory.createStartDocument(this.getEncoding()));
            }
            this.writeXMLNode(writer, xml);
            if (this.isPackXml()) {
                writer.add(eventFactory.createEndDocument());
            }
            writer.flush();
            data = buildStream.toByteArray();
        }
        catch (Exception e) {
            throw new Exception("\u4f7f\u7528Stax\u5199XML\u7684\u65f6\u5019\u5f02\u5e38", e);
        }
        finally {
            buildStream.close();
            if (writer != null) {
                writer.close();
            }
        }
        return data;
    }

    private void writeXMLNode(XMLEventWriter writer, XMLNode root) throws XMLStreamException {
        ArrayList<Attribute> attrs = new ArrayList<Attribute>();
        Attribute attr = null;
        for (int i = 0; i < root.getAttrs().size(); ++i) {
            attr = eventFactory.createAttribute(root.getAttrs().get(i).getPrefix(), null, root.getAttrs().get(i).getName(), root.getAttrs().get(i).getValue());
            attrs.add(attr);
        }
        ArrayList<Namespace> namespaces = new ArrayList<Namespace>();
        Namespace ns = null;
        for (int i = 0; i < root.getNamespaces().size(); ++i) {
            ns = eventFactory.createNamespace(root.getNamespaces().get(i).getPrefix(), root.getNamespaces().get(i).getUri());
            namespaces.add(ns);
        }
        writer.add(eventFactory.createStartElement(root.getPrefix(), null, root.getName(), attrs.iterator(), namespaces.iterator()));
        if (root.getCDATA() != null) {
            writer.add(eventFactory.createCData(root.getCDATA()));
        }
        Map<String, Object> children = root.getChildren();
        for (Object obj : children.values()) {
            if (obj instanceof XMLNode) {
                this.writeXMLNode(writer, (XMLNode)obj);
                continue;
            }
            if (!(obj instanceof List)) continue;
            for (XMLNode node : (List)obj) {
                this.writeXMLNode(writer, node);
            }
        }
        writer.add(eventFactory.createCharacters(root.getValue()));
        writer.add(eventFactory.createEndElement(root.getPrefix(), null, root.getName()));
    }

    private XMLNode getFatherNode(XMLNode xml, List<String> nodeList) {
        XMLNode root = xml;
        Object obj = null;
        String nodeName = null;
        if (nodeList == null) {
            return root;
        }
        for (int i = 1; i < nodeList.size() - 1; ++i) {
            nodeName = nodeList.get(i);
            obj = root.getChildren().get(nodeName);
            if (obj instanceof XMLNode) {
                root = (XMLNode)obj;
                continue;
            }
            if (!(obj instanceof List)) continue;
            root = (XMLNode)((LinkedList)obj).getLast();
        }
        return root;
    }

    public static XMLEventFactory getEventFactory() {
        return eventFactory;
    }

    public static XMLInputFactory getInputFactory() {
        return inputFactory;
    }

    public static XMLOutputFactory getOutputFactory() {
        return outputFactory;
    }

    public String getEncoding() {
        return this.encoding;
    }

    public void setEncoding(String encoding) {
        this.encoding = encoding;
    }

    public boolean isPackXml() {
        return this.packXml;
    }

    public void setPackXml(boolean packXml) {
        this.packXml = packXml;
    }

    static {
        inputFactory.setProperty("javax.xml.stream.supportDTD", false);
        inputFactory.setProperty("javax.xml.stream.isSupportingExternalEntities", false);
        inputFactory.setProperty("javax.xml.stream.isCoalescing", true);
    }
}

