/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.yusp.bsp.component;

import cn.com.yusys.yusp.bsp.app.config.ModulePath;
import cn.com.yusys.yusp.bsp.component.IComponent;
import cn.com.yusys.yusp.bsp.component.exception.ComponentException;
import cn.com.yusys.yusp.bsp.resources.ExceptionAnalyzer;
import cn.com.yusys.yusp.bsp.resources.Session;
import cn.com.yusys.yusp.bsp.toolkit.common.StringTools;
import cn.com.yusys.yusp.bsp.toolkit.el.ExpressTools;
import cn.com.yusys.yusp.bsp.toolkit.el.ognl.OgnlTools;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractComponent
implements IComponent {
    protected Logger logger = LoggerFactory.getLogger(this.getClass());
    private String errMsg;
    private String errCode;
    private static final String EXCEPTION_HANDLER_TYPE_IGNORE = "ignore";
    public static final String EXCEPTION_HANDLER_TYPE_PASS = "pass";
    private String exceptionHandlerType = "pass";
    protected boolean printHex = false;

    @Override
    public void execute(Map<String, Object> context) throws ComponentException {
        try {
            Session session = (Session)context.get("T_SESSION");
            this.printHex = session.isPrintHex();
            this.executeComponent(context);
        }
        catch (Throwable t) {
            this.onException(context, t);
        }
    }

    protected abstract void executeComponent(Map<String, Object> var1) throws Exception;

    @Override
    public void onException(Map<String, Object> context, Throwable t) throws ComponentException {
        String errCodeValue = this.errCode;
        if (!StringTools.isEmpty(this.errCode)) {
            try {
                errCodeValue = StringTools.getString(OgnlTools.getValue(this.errCode, context));
                context.put("G_RET_CODE", errCodeValue);
            }
            catch (Exception e) {
                this.logger.debug("errorCode [{}] set error,ignore", (Object)this.errCode);
            }
        }
        String errMsgValue = this.errMsg;
        if (!StringTools.isEmpty(this.errMsg)) {
            try {
                errMsgValue = StringTools.getString(OgnlTools.getValue(this.errMsg, context));
                context.put("G_RET_MSG", errMsgValue);
            }
            catch (Exception e) {
                this.logger.debug("errMsg [{}] set error,ignore", (Object)this.errMsg);
            }
        }
        ExceptionAnalyzer.setContextExceptionInfos(context, t, errCodeValue, errMsgValue);
        if (EXCEPTION_HANDLER_TYPE_IGNORE.equals(this.exceptionHandlerType)) {
            return;
        }
        if (t instanceof ComponentException) {
            throw (ComponentException)t;
        }
        throw new ComponentException(t);
    }

    protected String getModulePath(Map<String, Object> context) {
        Session session = (Session)context.get("T_SESSION");
        String modulePath = null;
        if (session != null) {
            String moduleName = session.getModuleName();
            modulePath = ModulePath.getModulePath(moduleName, false);
        }
        return modulePath;
    }

    public static String getInExpressStringValue(String expr, Map<String, Object> context) throws Exception {
        Object value = ExpressTools.getValue(expr, context);
        if (value == null) {
            return null;
        }
        return String.valueOf(value);
    }

    public static byte[] getInExpressByteValue(String expr, Map<String, Object> context) throws Exception {
        Object value = ExpressTools.getValue(expr, context);
        if (value == null) {
            return null;
        }
        try {
            return (byte[])value;
        }
        catch (ClassCastException e) {
            throw new ClassCastException("The type of expression value is not byte[]");
        }
    }

    public static boolean getInExpressBooleanValue(String expr, Map<String, Object> context) throws Exception {
        Object value = ExpressTools.getValue(expr, context);
        if (value == null) {
            return false;
        }
        return Boolean.parseBoolean(String.valueOf(value));
    }

    protected Object getInExpressObjectValue(String expr, Map<String, Object> context) throws Exception {
        return ExpressTools.getValue(expr, context);
    }

    public Logger getLogger() {
        return this.logger;
    }

    public void setLogger(Logger logger) {
        this.logger = logger;
    }

    public String getErrCode() {
        return this.errCode;
    }

    public void setErrCode(String errCode) {
        this.errCode = errCode;
    }

    public String getErrMsg() {
        return this.errMsg;
    }

    public void setErrMsg(String errMsg) {
        this.errMsg = errMsg;
    }

    public String getExceptionHandlerType() {
        return this.exceptionHandlerType;
    }

    public void setExceptionHandlerType(String exceptionHandlerType) {
        this.exceptionHandlerType = exceptionHandlerType;
    }
}

