/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.yusp.bsp.dataformat.impl;

import cn.com.yusys.yusp.bsp.dataformat.exe.AbstractExecutor;
import cn.com.yusys.yusp.bsp.schema.dataformat.def.Group;
import cn.com.yusys.yusp.bsp.schema.dataformat.def.Item;
import cn.com.yusys.yusp.bsp.schema.dataformat.def.While;
import cn.com.yusys.yusp.bsp.toolkit.common.BCCPTools;
import cn.com.yusys.yusp.bsp.toolkit.common.ByteTools;
import cn.com.yusys.yusp.bsp.toolkit.common.StringTools;
import cn.com.yusys.yusp.bsp.toolkit.el.ognl.OgnlTools;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class BCCPExecutor
extends AbstractExecutor<byte[]> {
    private static final String DATA_FORMAT_NAME = "BCCP";
    private static final String DATA_FORMAT_VALUE_TYPE = "valueType";
    private static final String ITEM_ATTRIBUTE_DATA_VARIABLE = "varName";
    private boolean isStr;
    private Map<String, Object> protocol;
    private ByteArrayOutputStream baos;
    private DataOutputStream dos;
    private final BCCPTools tool = new BCCPTools();
    private int currentIndex;

    @Override
    public String getExecutorName() {
        return DATA_FORMAT_NAME;
    }

    @Override
    public void init(Map<String, String> property) {
        String attr = property.get(DATA_FORMAT_VALUE_TYPE);
        if ("string".equals(attr)) {
            this.isStr = true;
        }
        if (this.getPackType() == DATAFORMAT_PACK) {
            this.baos = new ByteArrayOutputStream();
            this.dos = new DataOutputStream(this.baos);
        }
    }

    @Override
    public byte[] outputInner() throws Exception {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        byte[] dataEncode = this.getEncoding().getBytes();
        out.write(dataEncode.length);
        out.write(dataEncode);
        out.write(this.baos.toByteArray());
        return out.toByteArray();
    }

    @Override
    public void inputData(byte[] inputData) throws Exception {
        int encodeLen = inputData[0] & 0xFF;
        byte[] data = new byte[inputData.length - encodeLen - 1];
        System.arraycopy(inputData, encodeLen + 1, data, 0, data.length);
        super.inputData(data);
        try {
            this.protocol = this.unpackData(data, this.isStr, this.getEncoding());
        }
        catch (Exception e) {
            throw new Exception("[" + this.getExecutorName() + "] unpack exception", e);
        }
    }

    @Override
    public void packItem(Item item, byte[] data, Map<String, String> paras) throws Exception {
        String dataVar = paras.get(ITEM_ATTRIBUTE_DATA_VARIABLE);
        if (StringTools.isEmpty(dataVar)) {
            dataVar = item.getName();
        }
        byte[] key = dataVar.getBytes(this.getEncoding());
        this.dos.write(key.length);
        this.dos.write(key);
        this.tool.cutOperation(data, this.baos);
    }

    @Override
    public void packGroup(Group group) throws Exception {
        String name = group.getName();
        this.dos.write(254);
        byte[] byteName = name.getBytes(this.getEncoding());
        this.dos.write(byteName.length);
        this.dos.write(byteName);
        ByteArrayOutputStream tmpBaos = this.baos;
        DataOutputStream tmpDos = this.dos;
        this.baos = new ByteArrayOutputStream();
        this.dos = new DataOutputStream(this.baos);
        super.packGroup(group);
        byte[] body = this.baos.toByteArray();
        tmpDos.writeInt(body.length);
        tmpDos.write(body);
        this.baos = tmpBaos;
        this.dos = tmpDos;
    }

    @Override
    public void packWhile(While whileObject) throws Exception {
        String name = whileObject.getName();
        String varname = whileObject.getVar();
        int nCount = this.parseLoopCount(whileObject);
        this.logger.debug("{} @ Loop packing message, loop name: {}, times: {}, variable: {}", new Object[]{this.getExecutorName(), name, nCount, varname});
        this.dos.write(255);
        byte[] byteName = name.getBytes(this.getEncoding());
        this.dos.write(byteName.length);
        this.dos.write(byteName);
        this.dos.writeInt(nCount);
        for (int i = 0; i < nCount; ++i) {
            ByteArrayOutputStream tmpBaos = this.baos;
            DataOutputStream tmpDos = this.dos;
            this.baos = new ByteArrayOutputStream();
            this.dos = new DataOutputStream(this.baos);
            this.rootContext.put(varname, i);
            this.packBody(whileObject.getBody());
            byte[] body = this.baos.toByteArray();
            tmpDos.writeInt(body.length);
            this.baos.reset();
            tmpDos.write(body);
            this.baos = tmpBaos;
            this.dos = tmpDos;
        }
        this.rootContext.remove(varname);
    }

    @Override
    public byte[] autoPack(Map<String, Object> map) throws Exception {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        byte[] dataEncode = this.getEncoding().getBytes();
        out.write(dataEncode.length);
        out.write(dataEncode);
        ArrayList<String> path = new ArrayList<String>();
        out.write(this.packData(map, path));
        byte[] retData = out.toByteArray();
        out.close();
        return retData;
    }

    private byte[] packData(Map<String, Object> data, List<String> path) throws Exception {
        byte[] value;
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        for (String key : data.keySet()) {
            byte[] name = key.getBytes(this.getEncoding());
            int len = name.length;
            if (len > 250) {
                throw new Exception(this.getExecutorName() + " @  Field name [" + this.pathToString(path) + key + "] is longer than 250");
            }
            Object tempObj = data.get(key);
            if (!this.isSimpleType(tempObj)) {
                if (tempObj instanceof Map) {
                    this.valueInstanceOfMap(path, os, name, (Map)tempObj, len, key);
                    continue;
                }
                if (tempObj instanceof List) {
                    this.valueInstanceofList(path, os, name, (List)tempObj, len, key);
                    continue;
                }
                this.valueInstanceOther(path, tempObj, key);
                continue;
            }
            value = ByteTools.getBytes(tempObj, this.getEncoding());
            if (this.isFilterEmpty() && value.length == 0) {
                if (!this.logger.isDebugEnabled()) continue;
                this.logger.debug("{} @ Auto packing: {}, filtering empty string", new Object[]{this.getExecutorName(), this.pathToString(path) + key});
                continue;
            }
            os.write(len);
            os.write(name);
            value = (byte[])this.invokeMethods(this.getGlobalBuildMethod(), value, 1);
            this.tool.cutOperation(value, os);
            if (!this.logger.isDebugEnabled()) continue;
            this.logger.debug("{} @ Auto packing:{}=[{}]", new Object[]{this.getExecutorName(), this.pathToString(path) + key, StringTools.getString(tempObj, this.getEncoding())});
        }
        value = os.toByteArray();
        os.close();
        return value;
    }

    private void valueInstanceOther(List<String> path, Object tempObj, String key) {
        if (this.logger.isDebugEnabled()) {
            if (tempObj != null) {
                this.logger.debug("{} @ Auto packing: {}, type [{}] is not supported", new Object[]{this.getExecutorName(), this.pathToString(path) + key, tempObj.getClass().getName()});
            } else {
                this.logger.debug("{} @ Auto packing: {}, ignore(value is null)", new Object[]{this.getExecutorName(), this.pathToString(path) + key});
            }
        }
    }

    private void valueInstanceofList(List<String> path, ByteArrayOutputStream os, byte[] name, List<Map<String, Object>> tempObj, int len, String key) throws Exception {
        os.write(255);
        os.write(len);
        os.write(name);
        List<Map<String, Object>> list = tempObj;
        os.write(ByteTools.int2byte(list.size()));
        int index = 0;
        for (Map<String, Object> map : list) {
            path.add(key + "[" + index++ + "]");
            byte[] value = this.packData(map, path);
            os.write(ByteTools.int2byte(value.length));
            os.write(value);
            path.remove(path.size() - 1);
        }
    }

    private void valueInstanceOfMap(List<String> path, ByteArrayOutputStream os, byte[] name, Map<String, Object> tempObj, int len, String key) throws Exception {
        path.add(key);
        os.write(254);
        os.write(len);
        os.write(name);
        byte[] value = this.packData(tempObj, path);
        os.write(ByteTools.int2byte(value.length));
        os.write(value);
        path.remove(path.size() - 1);
    }

    private Map<String, Object> unpackData(byte[] data, boolean stringValue, String encoding) throws Exception {
        if (encoding == null || encoding.trim().equals("")) {
            encoding = "UTF-8";
        }
        HashMap<String, Object> map = new HashMap<String, Object>(16);
        int index = 0;
        int dataLen = data.length;
        while (index < dataLen) {
            int valueLen;
            byte[] value;
            byte[] name;
            int nameLen;
            if ((nameLen = 0xFF & data[index++]) <= 250) {
                name = new byte[nameLen];
                System.arraycopy(data, index, name, 0, nameLen);
                value = this.linkOpreation(data, index += nameLen);
                index = this.currentIndex;
                value = (byte[])this.invokeMethods(this.getGlobalParseMethod(), value, 1);
                if (stringValue) {
                    map.put(new String(name, encoding), new String(value, encoding));
                    continue;
                }
                map.put(new String(name, encoding), value);
                continue;
            }
            if (nameLen == 254) {
                nameLen = 0xFF & data[index++];
                name = new byte[nameLen];
                System.arraycopy(data, index, name, 0, nameLen);
                value = new byte[4];
                System.arraycopy(data, index += nameLen, value, 0, 4);
                valueLen = ByteTools.byte2int(value);
                value = new byte[valueLen];
                System.arraycopy(data, index += 4, value, 0, valueLen);
                index += valueLen;
                map.put(new String(name, encoding), this.unpackData(value, stringValue, encoding));
                continue;
            }
            if (nameLen == 255) {
                nameLen = 0xFF & data[index++];
                name = new byte[nameLen];
                System.arraycopy(data, index, name, 0, nameLen);
                value = new byte[4];
                System.arraycopy(data, index += nameLen, value, 0, 4);
                index += 4;
                int loopCount = ByteTools.byte2int(value);
                ArrayList<Map<String, Object>> list = new ArrayList<Map<String, Object>>();
                for (int i = 0; i < loopCount; ++i) {
                    value = new byte[4];
                    System.arraycopy(data, index, value, 0, 4);
                    valueLen = ByteTools.byte2int(value);
                    value = new byte[valueLen];
                    System.arraycopy(data, index += 4, value, 0, valueLen);
                    index += valueLen;
                    list.add(this.unpackData(value, stringValue, encoding));
                }
                map.put(new String(name, encoding), list);
                continue;
            }
            throw new Exception("Field name length is not supported:" + nameLen);
        }
        return map;
    }

    private byte[] linkOpreation(byte[] data, int index) throws Exception {
        int valueLen;
        int baseNum = 255;
        if ((valueLen = baseNum & data[index++]) != baseNum) {
            byte[] value = new byte[valueLen];
            System.arraycopy(data, index, value, 0, valueLen);
            this.currentIndex = index + valueLen;
            return value;
        }
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        while (valueLen == baseNum) {
            os.write(data, index, 250);
            index += 250;
            valueLen = 0xFF & data[index++];
        }
        os.write(data, index, valueLen);
        os.close();
        this.currentIndex = index + valueLen;
        return os.toByteArray();
    }

    private String pathToString(List<String> path) {
        if (path.size() == 0) {
            return "";
        }
        StringBuilder buf = new StringBuilder();
        for (String str : path) {
            buf.append(str);
            buf.append(".");
        }
        return buf.toString();
    }

    @Override
    public Map<String, Object> autoUnpack() {
        return this.protocol;
    }

    @Override
    public byte[] unPackItem(Item item, Map<String, String> paras) throws Exception {
        String dataVar = paras.get(ITEM_ATTRIBUTE_DATA_VARIABLE);
        if (StringTools.isEmpty(dataVar)) {
            dataVar = item.getPath();
        }
        dataVar = OgnlTools.parseXmlPath(dataVar, this.getRootContext());
        Object value = OgnlTools.getValue(dataVar, this.protocol);
        return ByteTools.getBytes(value, this.getEncoding());
    }

    @Override
    protected void unPackWhile(While whileObject) throws Exception {
        String name = whileObject.getName();
        String varname = whileObject.getVar();
        int nCount = this.parseLoopCount(whileObject, this.protocol);
        this.logger.debug("{} @ Loop unpacking message, loop name: {}, times: {}, variable: {}", new Object[]{this.getExecutorName(), name, nCount, varname});
        super.unPackWhile(nCount, name, varname, whileObject);
    }

    @Override
    protected boolean supportItemMust() {
        return true;
    }

    @Override
    public int getSearchIndex() {
        return -1;
    }
}

