/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.yusp.bsp.core;

import cn.com.yusys.yusp.bsp.communication.IRequest;
import cn.com.yusys.yusp.bsp.communication.SocketWrapper;
import cn.com.yusys.yusp.bsp.communication.StreamRequest;
import cn.com.yusys.yusp.bsp.component.IComponent;
import cn.com.yusys.yusp.bsp.component.exception.BizException;
import cn.com.yusys.yusp.bsp.component.exception.IgnorePrintException;
import cn.com.yusys.yusp.bsp.core.IResponseCallback;
import cn.com.yusys.yusp.bsp.core.IWorkflowHandler;
import cn.com.yusys.yusp.bsp.resources.BspContextHolder;
import cn.com.yusys.yusp.bsp.resources.BspDataContext;
import cn.com.yusys.yusp.bsp.resources.Session;
import cn.com.yusys.yusp.bsp.toolkit.common.StringTools;
import cn.com.yusys.yusp.bsp.workflow.component.ServiceNonExistException;
import java.io.BufferedInputStream;
import java.io.DataInputStream;
import java.net.Socket;
import java.net.SocketException;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultWorkflowHandler
implements IWorkflowHandler {
    private static final Logger logger = LoggerFactory.getLogger(DefaultWorkflowHandler.class);
    private static final Logger f5Logger = LoggerFactory.getLogger((String)"cn.com.yusys.yusp.bsp.workflow.worker.F5Logger");
    private IComponent component;
    private Session session;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        try {
            if (this.session.getInRequest().isTimeStart()) {
                this.session.setTradeStartTime(System.currentTimeMillis());
            }
            if (this.session.isF5Check() && this.f5Check()) {
                this.session.destory();
                return;
            }
            this.initBspDataContext(this.session.getContext());
            this.component.execute(this.session.getContext());
            IResponseCallback<Map<String, Object>> responseCallback = this.session.getResponseCallback();
            if (!this.session.isAsyn() && responseCallback != null) {
                responseCallback.response(this.session.getContext());
            }
        }
        catch (ServiceNonExistException e) {
            logger.error("Execute not found", (Throwable)e);
            this.session.getResponseCallback().notfound();
        }
        catch (IgnorePrintException e) {
            this.session.destory();
        }
        catch (BizException e) {
            Map<String, Object> tmpContext = this.session.getContext();
            BizException bizException = e;
            tmpContext.put("G_RET_CODE", bizException.getExceptionCode());
            tmpContext.put("G_RET_MSG", bizException.getExceptionMsg());
            this.session.getResponseCallback().error(tmpContext);
        }
        catch (Exception e) {
            logger.error("Execute with Exception", (Throwable)e);
            this.session.getResponseCallback().error(this.session.getContext());
        }
        finally {
            BspContextHolder.getInstance().remvoeBspDataContext();
        }
    }

    private void initBspDataContext(Map<String, Object> context) {
        BspDataContext bspDataContext = new BspDataContext(context);
        BspContextHolder.getInstance().putBspDataContext(bspDataContext);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean f5Check() {
        IRequest request = this.session.getInRequest();
        if (request.getRequestType() == 1) {
            SocketWrapper socketWrapper;
            StreamRequest streamRequest = (StreamRequest)request;
            Object datasourceWrapper = streamRequest.getDatasourceWrapper();
            if (datasourceWrapper instanceof SocketWrapper) {
                socketWrapper = (SocketWrapper)datasourceWrapper;
                if (!socketWrapper.isFirst()) {
                    return false;
                }
            } else {
                return false;
            }
            socketWrapper.setFirst(false);
            Socket socket = socketWrapper.getSocket();
            int timeout = -1;
            try {
                timeout = socket.getSoTimeout();
                socket.setSoTimeout(10000);
                if (this.f5Check(socketWrapper)) {
                    request.setCloseFlag(true);
                    boolean bl = true;
                    return bl;
                }
            }
            catch (Exception exception) {
            }
            finally {
                try {
                    socket.setSoTimeout(timeout);
                }
                catch (SocketException socketException) {}
            }
        }
        return false;
    }

    private boolean f5Check(SocketWrapper socketWrapper) throws Exception {
        BufferedInputStream bis = socketWrapper.getBis();
        String f5ReqMsg = this.session.getF5Reqmsg();
        if (!StringTools.isEmpty(f5ReqMsg)) {
            byte[] src = this.f5Msg2byte(f5ReqMsg);
            int f5ReqLen = src.length;
            bis.mark(f5ReqLen);
            byte[] f5Data = new byte[f5ReqLen];
            DataInputStream dis = new DataInputStream(bis);
            try {
                dis.readFully(f5Data);
                if (this.byteCompare(src, f5Data)) {
                    f5Logger.info("Packet detection: {},data:{}", (Object)socketWrapper.getSocket(), (Object)f5ReqMsg);
                    String f5RespMsg = this.session.getF5Respmsg();
                    if (!StringTools.isEmpty(f5RespMsg)) {
                        socketWrapper.getBos().write(this.f5Msg2byte(f5RespMsg));
                        socketWrapper.getBos().flush();
                    }
                    return true;
                }
            }
            catch (Exception exception) {}
        } else {
            bis.mark(1);
            int c = bis.read();
            if (c == -1) {
                f5Logger.info("Packet detection: {}", (Object)socketWrapper.getSocket());
                return true;
            }
        }
        bis.reset();
        return false;
    }

    public byte[] f5Msg2byte(String msg) throws Exception {
        String startWith0x = "0x";
        String startWith0X = "0X";
        if (msg.startsWith(startWith0x) || msg.startsWith(startWith0X)) {
            msg = msg.substring(2);
            return StringTools.string2Byte(msg);
        }
        return msg.getBytes();
    }

    public boolean byteCompare(byte[] src, byte[] dest) {
        if (src.length != dest.length) {
            return false;
        }
        for (int i = 0; i < dest.length; ++i) {
            if ((src[i] & 0xFF) == (dest[i] & 0xFF)) continue;
            return false;
        }
        return true;
    }

    @Override
    public void setSession(Session session) {
        this.session = session;
    }

    public IComponent getComponent() {
        return this.component;
    }

    @Override
    public void setComponent(IComponent component) {
        this.component = component;
    }
}

