/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.yusp.bsp.config;

import cn.com.yusys.yusp.bsp.app.config.ModulePath;
import cn.com.yusys.yusp.bsp.config.ModuleHelper;
import cn.com.yusys.yusp.bsp.toolkit.common.FileTools;
import java.io.File;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.io.Resource;
import org.springframework.core.io.support.PathMatchingResourcePatternResolver;

public interface ModuleConfig {
    public static final Logger logger = LoggerFactory.getLogger(ModuleConfig.class);

    default public void loadModuleConfig() throws Exception {
        this.loadModuleConfig(null, false);
    }

    default public void loadModuleConfig(List<String> list, boolean button) throws Exception {
        String endWithStr;
        String path = ModulePath.getModulePath();
        if (!path.endsWith(endWithStr = "/")) {
            path = path + "/";
        }
        String locationPattern = path + "*/*/module.mrd";
        logger.info("Load communication configuration[{}]", (Object)locationPattern);
        String threadName = Thread.currentThread().getName();
        if (ModulePath.isFileModel()) {
            String[] reses;
            File rootFile = new File(path);
            for (String res : reses = FileTools.recursiveListFileBySuffix(rootFile, "module.mrd").toArray(new String[0])) {
                String modulePath = new File(res).toURI().toString();
                String serviceName = ModuleHelper.fetchService(modulePath);
                if (!this.isLoad(list, button, serviceName)) continue;
                ModuleHelper.loadModule(modulePath);
            }
        } else {
            Resource[] reses;
            PathMatchingResourcePatternResolver pmrpr = new PathMatchingResourcePatternResolver();
            for (Resource res : reses = pmrpr.getResources(locationPattern)) {
                String modulePath = res.getURL().toString();
                String serviceName = ModuleHelper.fetchService(modulePath);
                if (!this.isLoad(list, button, serviceName)) continue;
                ModuleHelper.loadModule(modulePath);
            }
        }
        Thread.currentThread().setName(threadName);
        logger.info("Load communication configuration successfully!");
    }

    default public boolean isLoad(List<String> list, boolean button, String serviceName) {
        boolean load = true;
        if (list != null && !list.isEmpty()) {
            load = !button ? !list.contains(serviceName) : list.contains(serviceName);
        }
        return load;
    }
}

