/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.yusp.bsp.component.impl.comm;

import cn.com.yusys.yusp.bsp.communication.AbstractRequest;
import cn.com.yusys.yusp.bsp.communication.DataRequest;
import cn.com.yusys.yusp.bsp.communication.IRequest;
import cn.com.yusys.yusp.bsp.communication.SocketWrapper;
import cn.com.yusys.yusp.bsp.communication.StreamRequest;
import cn.com.yusys.yusp.bsp.communication.in.AbstractInAdapter;
import cn.com.yusys.yusp.bsp.communication.out.IOutAdapter;
import cn.com.yusys.yusp.bsp.component.AbstractComponent;
import cn.com.yusys.yusp.bsp.component.exception.ComponentException;
import cn.com.yusys.yusp.bsp.component.exception.IgnorePrintException;
import cn.com.yusys.yusp.bsp.component.impl.comm.AbstractCommRouteConfig;
import cn.com.yusys.yusp.bsp.resources.BspAppContext;
import cn.com.yusys.yusp.bsp.resources.ResourcePortal;
import cn.com.yusys.yusp.bsp.resources.Session;
import cn.com.yusys.yusp.bsp.resources.core.VarDef;
import cn.com.yusys.yusp.bsp.toolkit.common.Assert;
import cn.com.yusys.yusp.bsp.toolkit.common.Base64Tools;
import cn.com.yusys.yusp.bsp.toolkit.common.ByteTools;
import cn.com.yusys.yusp.bsp.toolkit.common.StringTools;
import cn.com.yusys.yusp.bsp.workflow.IComm;
import java.io.IOException;
import java.net.Socket;
import java.util.Map;

public abstract class AbstractComm
extends AbstractComponent
implements IComm {
    private static final String T_SELECT_OUTADAPTER_EXPR = "T_SELECT_OUTADAPTER_EXPR";
    public static final String ACTION_EXCH = "Exchange";
    public static final String ACTION_RECV = "Receive";
    public static final String ACTION_SEND = "Send";
    private String[] outAdapterNameArr;
    private String actionType;
    private String adapterName;
    private String recvVar;
    private String sendVar;
    private String timeout;
    private int policy = 0;
    private volatile AbstractCommRouteConfig routeConfig;
    private final Object lock = new Object();

    @Override
    public String getComponentName() {
        return this.getUnitName();
    }

    @Override
    public void executeComponent(Map<String, Object> context) throws Exception {
        Assert.notNull(this.getActionType(), "[Action type] cannot be empty");
        Session session = (Session)context.get("T_SESSION");
        IRequest request = this.getUseRequest(context, session);
        if (request.getRequestType() == 1) {
            StreamRequest srt = (StreamRequest)request;
            Socket socket = this.parseDatasourceWrapper(srt);
            int timeoutCondition = this.parseTimeout(context);
            if (socket != null) {
                this.logger.info("{} @ Connection:{}", new Object[]{this.getUnitName(), socket});
                int soTimeOut = socket.getSoTimeout();
                try {
                    if (!request.isTimeStart()) {
                        socket.setSoTimeout(0);
                    } else if (timeoutCondition > 0) {
                        socket.setSoTimeout(timeoutCondition);
                        this.logger.debug("{} @ Timeout: use custom value:{}", new Object[]{this.getUnitName(), String.valueOf(timeoutCondition)});
                    } else {
                        this.logger.debug("{} @ Timeout: use default value:{}", new Object[]{this.getUnitName(), String.valueOf(soTimeOut)});
                    }
                    this.executeCommAction(session, context, (AbstractRequest)request);
                }
                catch (Throwable e) {
                    String longServerInAdapter;
                    request.setCloseFlag(true);
                    if (request.getInAdapter() != null && (longServerInAdapter = "longServerInAdapter").equals(((AbstractInAdapter)request.getInAdapter()).getBeanName()) && e instanceof IOException) {
                        throw new IgnorePrintException();
                    }
                    throw e;
                }
                finally {
                    if (!(request.isTimeStart() && timeoutCondition <= 0 || socket.isClosed())) {
                        socket.setSoTimeout(soTimeOut);
                    }
                }
            }
            throw new ComponentException("Socket is null");
        }
        DataRequest srt = (DataRequest)request;
        Object wrapper = srt.getDatasourceWrapper();
        this.logger.info("{} @ Connection:{}", new Object[]{this.getUnitName(), wrapper});
        try {
            this.executeCommAction(session, context, (AbstractRequest)request);
        }
        catch (Exception e) {
            srt.setCloseFlag(true);
            throw e;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void executeCommAction(Session session, Map<String, Object> context, AbstractRequest request) throws Exception {
        if (ACTION_RECV.equals(this.getActionType())) {
            Assert.notNull(this.getRecvVar(), "[Receive var name] cannot be empty");
            try {
                byte[] tradeData = this.processRecv(context, request);
                context.put(this.getRecvVar(), tradeData);
            }
            finally {
                if (!request.isTimeStart()) {
                    request.setTimeStart(true);
                    session.setTradeStartTime(System.currentTimeMillis());
                }
            }
        } else {
            Assert.notNull(this.getSendVar(), "[Send var name] cannot be empty");
            Object object = this.getInExpressObjectValue(this.getSendVar(), context);
            if (object == null) {
                throw new Exception("Send var does not exist");
            }
            byte[] tradeData = ByteTools.getBytes(object);
            if (ACTION_SEND.equals(this.getActionType())) {
                this.processSend(context, tradeData, request);
            } else if (ACTION_EXCH.equals(this.getActionType())) {
                Assert.notNull(this.getRecvVar(), "[Receive var name] cannot be empty");
                tradeData = this.processExch(context, tradeData, request);
                context.put(this.getRecvVar(), tradeData);
            } else {
                throw new Exception("Action type not supported: [" + this.getActionType() + "]");
            }
        }
    }

    protected int parseTimeout(Map<String, Object> context) {
        int intTimeOut = -1;
        try {
            String timeout = AbstractComm.getInExpressStringValue(this.getTimeout(), context);
            if (timeout != null) {
                intTimeOut = Integer.parseInt(timeout);
            }
        }
        catch (Exception e) {
            this.logger.warn("{} @ The timeout setting is invalid, use the default value", (Object)this.getUnitName(), (Object)e);
        }
        return intTimeOut;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected IRequest getUseRequest(Map<String, Object> context, Session session) throws Exception {
        String adapterNameExpr;
        String startWithCommIn;
        String moduleName = session.getModuleName();
        if (moduleName.startsWith(startWithCommIn = "commIn.")) {
            return session.getInRequest();
        }
        Assert.notNull(this.getAdapterName(), "[Adapter name] cannot be empty");
        if (this.outAdapterNameArr == null) {
            this.outAdapterNameArr = this.getAdapterName().split(",");
        }
        if (this.outAdapterNameArr.length > 1) {
            AbstractCommRouteConfig localRouteConfig = this.routeConfig;
            if (localRouteConfig == null) {
                Object object = this.lock;
                synchronized (object) {
                    localRouteConfig = this.routeConfig;
                    if (localRouteConfig == null) {
                        this.routeConfig = new AbstractCommRouteConfig(this.outAdapterNameArr, this.getPolicy());
                    }
                }
            }
            adapterNameExpr = this.routeConfig.selectAdapter();
            context.put(T_SELECT_OUTADAPTER_EXPR, adapterNameExpr);
        } else {
            adapterNameExpr = this.outAdapterNameArr[0];
        }
        String adapterName = StringTools.getString(AbstractComm.getInExpressStringValue(adapterNameExpr, context));
        if (StringTools.isEmpty(adapterName)) {
            throw new Exception("[Adapter name] is empty");
        }
        this.logger.debug("Used Adapter name is: [{}]", (Object)adapterName);
        BspAppContext xc = ResourcePortal.getInstance().getSpringContextRegistry().getAppContext(moduleName);
        IOutAdapter outAdapter = (IOutAdapter)xc.getBean(adapterName);
        IRequest request = outAdapter.borrowRequest(session);
        if (request == null) {
            throw new Exception("Service[" + moduleName + "]get communication receive exception");
        }
        if (request instanceof StreamRequest && ((StreamRequest)request).getSocketWrapper().getBos() == null) {
            throw new ComponentException("Service[" + moduleName + "]does not support data sending operation, output stream is empty");
        }
        return request;
    }

    protected Socket parseDatasourceWrapper(StreamRequest srt) throws Exception {
        Socket socket;
        Object o = srt.getDatasourceWrapper();
        if (o instanceof SocketWrapper) {
            socket = ((SocketWrapper)o).getSocket();
        } else if (o instanceof Socket) {
            socket = (Socket)o;
        } else {
            throw new Exception("StreamRequest does not support this type temporarily[" + o.getClass().getName() + "]");
        }
        return socket;
    }

    protected void printCommData(String descStr, byte[] bytes) {
        if (!this.logger.isInfoEnabled()) {
            return;
        }
        int length = bytes.length;
        if (VarDef.LOGMESSAGE) {
            String logSend = this.printHex ? Base64Tools.base64Encode2String(bytes) : StringTools.getString(bytes);
            this.logger.info("{} @ {} [{}]:{}", new Object[]{this.getUnitName(), descStr, length, logSend});
        } else {
            this.logger.info("{} @ {} [{}], message data will not be recorded!", new Object[]{this.getUnitName(), descStr, length});
        }
    }

    protected void printSendData(byte[] bsend) {
        this.printCommData("Send data", bsend);
    }

    protected void printRecvData(byte[] bRecv) {
        this.printCommData("Receive data", bRecv);
    }

    public String getActionType() {
        return this.actionType;
    }

    public void setActionType(String actionType) {
        this.actionType = actionType;
    }

    public String getAdapterName() {
        return this.adapterName;
    }

    public void setAdapterName(String adapterName) {
        this.adapterName = adapterName;
    }

    public String getRecvVar() {
        return this.recvVar;
    }

    public void setRecvVar(String recvVar) {
        this.recvVar = recvVar;
    }

    public String getSendVar() {
        return this.sendVar;
    }

    public void setSendVar(String sendVar) {
        this.sendVar = sendVar;
    }

    public String getTimeout() {
        return this.timeout;
    }

    public void setTimeout(String timeout) {
        this.timeout = timeout;
    }

    public int getPolicy() {
        return this.policy;
    }

    public void setPolicy(int policy) {
        this.policy = policy;
    }
}

