/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.yusp.commons.module.standard.impl;

import cn.com.yusys.yusp.commons.module.standard.Dict;
import cn.com.yusys.yusp.commons.module.standard.DictItem;
import cn.com.yusys.yusp.commons.module.standard.impl.DictItemImpl;
import cn.com.yusys.yusp.commons.util.ArrayUtils;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;

public class DictImpl
implements Dict {
    private final String dictCode;
    private Map<String, String> dictNames;
    private DictItem[] dictItems;

    private DictImpl(String dictCode) {
        this.dictCode = dictCode;
        this.dictNames = new HashMap<String, String>();
    }

    @Override
    public String dictCode() {
        return this.dictCode;
    }

    @Override
    public String dictName(Locale locale) {
        return this.dictNames.get(locale.toString());
    }

    @Override
    public DictItem[] items() {
        return this.dictItems;
    }

    public static DictImpl of(String dictCode) {
        return new DictImpl(dictCode);
    }

    public DictImpl setDictNames(Map<String, String> dictNames) {
        this.dictNames = dictNames;
        return this;
    }

    public DictImpl addDictName(String locale, String dictName) {
        this.dictNames.putIfAbsent(locale, dictName);
        return this;
    }

    public DictImpl addDictName(Locale locale, String dictName) {
        return this.addDictName(locale.toString(), dictName);
    }

    public DictImpl setDictItems(DictItem[] dictItems) {
        this.dictItems = dictItems;
        return this;
    }

    public DictImpl addDictItem(DictItem dictItem) {
        this.dictItems = (DictItem[])ArrayUtils.append((Object[])this.dictItems, (Object[])new DictItem[]{dictItem});
        return this;
    }

    public DictImpl addDictItem(Locale locale, String itemCode, String itemName) {
        DictItemImpl dictItem = DictItemImpl.of(this, itemCode).addItemName(locale, itemName);
        this.addDictItem(dictItem);
        return this;
    }

    public DictImpl addDictItem(String locale, String itemCode, String itemName) {
        DictItemImpl dictItem = DictItemImpl.of(this, itemCode).addItemName(locale, itemName);
        this.addDictItem(dictItem);
        return this;
    }
}

