/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.yusp.commons.module.standard;

import cn.com.yusys.yusp.commons.core.FactoryObjects;
import cn.com.yusys.yusp.commons.module.standard.Dict;
import cn.com.yusys.yusp.commons.module.standard.DictFactory;
import cn.com.yusys.yusp.commons.module.standard.DictItem;
import cn.com.yusys.yusp.commons.module.standard.FactoryDict;
import cn.com.yusys.yusp.commons.util.StringUtils;
import cn.com.yusys.yusp.commons.util.collection.CollectionUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Dicts {
    private static final Logger logger = LoggerFactory.getLogger(Dicts.class);
    private static final Map<String, Dict> DICT_VALUE_CACHE = new ConcurrentHashMap<String, Dict>(8);
    private static final List<DictFactory> FACTORIES = new ArrayList<DictFactory>();
    private static final ThreadLocal<Dicts> LOCAL_INSTANCE = new ThreadLocal();
    private final Map<String, Dict> CLEANABLE_DICT_VALUE_CACHE = new ConcurrentHashMap<String, Dict>(8);

    public static void clearThreadLocal() {
        LOCAL_INSTANCE.remove();
    }

    private Dicts() {
    }

    public static Dicts fromThreadLocal() {
        Dicts instace = LOCAL_INSTANCE.get();
        if (instace == null) {
            instace = new Dicts();
            LOCAL_INSTANCE.set(instace);
        }
        return instace;
    }

    public static void registerFactoryDict(FactoryDict factoryDict) {
        Dicts.registerFactoryDict(Collections.singletonList(factoryDict));
    }

    public static void registerFactoryDict(Collection<FactoryDict> factoryDicts) {
        if (CollectionUtils.nonEmpty(factoryDicts)) {
            factoryDicts.stream().map(FactoryObjects::getObjects).filter(CollectionUtils::nonEmpty).flatMap(Collection::stream).filter(Objects::nonNull).forEach(dict -> DICT_VALUE_CACHE.putIfAbsent(dict.dictCode(), (Dict)dict));
        }
    }

    public static void registerDictFactory(DictFactory dictFactory) {
        if (Objects.nonNull(dictFactory)) {
            FACTORIES.add(dictFactory);
        }
    }

    public static void registerDictFactory(Collection<DictFactory> dictFactory) {
        if (CollectionUtils.nonEmpty(dictFactory)) {
            FACTORIES.addAll(dictFactory);
        }
    }

    private static DictItem getDictItem(Dict dict, String value, Locale locale, boolean export) {
        if (logger.isDebugEnabled()) {
            logger.debug("Get DictItem.Current Locale is [{}], value is [{}]", (Object)locale, (Object)value);
        }
        return StringUtils.isEmpty((CharSequence)value) ? null : (DictItem)Optional.ofNullable(dict.items()).flatMap(items -> Arrays.stream(items).filter(Objects::nonNull).filter(item -> value.equals(export ? item.itemCode() : item.itemName(locale))).findFirst()).orElse(null);
    }

    public DictItem valueOf(String dictCode, String value, Locale locale, boolean export) {
        Dict dict = null;
        if (DICT_VALUE_CACHE.containsKey(dictCode)) {
            dict = DICT_VALUE_CACHE.get(dictCode);
        }
        if (dict == null) {
            dict = this.CLEANABLE_DICT_VALUE_CACHE.getOrDefault(dictCode, null);
        }
        if (dict == null) {
            for (DictFactory dictFactory : FACTORIES) {
                Dict factoryDict = dictFactory.create(dictCode);
                if (!Objects.nonNull(factoryDict)) continue;
                this.CLEANABLE_DICT_VALUE_CACHE.putIfAbsent(dictCode, factoryDict);
                dict = factoryDict;
                break;
            }
        }
        if (dict != null) {
            return Dicts.getDictItem(dict, value, locale, export);
        }
        return null;
    }
}

