/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.yusp.commons.module.standard.impl;

import cn.com.yusys.yusp.commons.module.standard.Dict;
import cn.com.yusys.yusp.commons.module.standard.FactoryDict;
import cn.com.yusys.yusp.commons.module.standard.impl.DictImpl;
import cn.com.yusys.yusp.commons.module.standard.impl.DictItemImpl;
import cn.com.yusys.yusp.commons.util.ArrayUtils;
import cn.com.yusys.yusp.commons.util.StringUtils;
import cn.com.yusys.yusp.commons.util.collection.CollectionUtils;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.env.MapPropertySource;
import org.springframework.core.io.Resource;
import org.springframework.core.io.support.EncodedResource;
import org.springframework.core.io.support.PathMatchingResourcePatternResolver;
import org.springframework.core.io.support.ResourcePropertySource;

public class ConfigurationFactoryDict
implements FactoryDict {
    private static final Logger logger = LoggerFactory.getLogger(ConfigurationFactoryDict.class);
    public static final String DEFAULT_CONFIG_PATH = "classpath*:dict/*.properties";
    private static final int DICT_KEYS_LENGTH = 2;
    private static final int DICT_ITEM_KEYS_LENGTH = 3;
    private final String configPath;
    private final String charset;

    public ConfigurationFactoryDict() {
        this(null);
    }

    public ConfigurationFactoryDict(String configPath) {
        this(configPath, null);
    }

    public ConfigurationFactoryDict(String configPath, String charset) {
        this.configPath = StringUtils.isEmpty((CharSequence)configPath) ? DEFAULT_CONFIG_PATH : configPath;
        this.charset = StringUtils.isEmpty((CharSequence)configPath) ? StandardCharsets.UTF_8.name() : charset;
    }

    @Override
    public List<Dict> getObjects() {
        return StringUtils.startsWith((String)this.configPath, (String)"classpath") ? this.byClassPath() : this.byAbsolutePath();
    }

    private List<Dict> byAbsolutePath() {
        return Collections.emptyList();
    }

    private List<Dict> byClassPath() {
        HashMap<String, Dict> dictMap = new HashMap<String, Dict>(8);
        try {
            PathMatchingResourcePatternResolver resourcePatternResolver = new PathMatchingResourcePatternResolver();
            Object[] resources = resourcePatternResolver.getResources(this.configPath);
            if (ArrayUtils.nonEmpty((Object[])resources)) {
                for (Object resource : resources) {
                    ResourcePropertySource propertySource = new ResourcePropertySource(new EncodedResource((Resource)resource, this.charset));
                    this.handlePropertySource(dictMap, (MapPropertySource)propertySource);
                }
            }
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
        return CollectionUtils.nonEmpty(dictMap) ? new ArrayList(dictMap.values()) : Collections.emptyList();
    }

    private void handlePropertySource(Map<String, Dict> dictMap, MapPropertySource mapPropertySource) {
        Map sources = (Map)mapPropertySource.getSource();
        if (CollectionUtils.nonEmpty((Map)sources)) {
            sources.entrySet().forEach(entry -> this.handleProperty(dictMap, (Map.Entry<String, Object>)entry));
        }
    }

    private void handleProperty(Map<String, Dict> dictMap, Map.Entry<String, Object> entry) {
        Object[] keys = StringUtils.split((String)entry.getKey(), (String)"\\.");
        if (ArrayUtils.nonEmpty((Object[])keys)) {
            if (keys.length == 2) {
                this.handleDict(dictMap, (String)keys[0], (String)keys[1], StringUtils.replaceObjNull((Object)entry.getValue()));
            } else if (keys.length == 3) {
                this.handleDictItem(dictMap, (String)keys[0], (String)keys[1], (String)keys[2], StringUtils.replaceObjNull((Object)entry.getValue()));
            } else {
                logger.warn("key:{}, value{} not supported convert dict object", (Object)entry.getKey(), entry.getValue());
            }
        }
    }

    private void handleDict(Map<String, Dict> dictMap, String locale, String dictCode, String dictName) {
        if (!dictMap.containsKey(dictCode)) {
            dictMap.put(dictCode, DictImpl.of(dictCode));
        }
        DictImpl dict = (DictImpl)dictMap.get(dictCode);
        dict.addDictName(locale, dictName);
    }

    private void handleDictItem(Map<String, Dict> dictMap, String locale, String dictCode, String itemCode, String itemName) {
        DictImpl dict;
        DictItemImpl dictItemImpl;
        if (!dictMap.containsKey(dictCode)) {
            dictMap.put(dictCode, DictImpl.of(dictCode));
        }
        if ((dictItemImpl = (DictItemImpl)Optional.ofNullable((dict = (DictImpl)dictMap.get(dictCode)).items()).flatMap(dictItems -> Arrays.stream(dictItems).filter(item -> item.itemCode().equals(itemCode)).findFirst()).orElse(null)) == null) {
            dict.addDictItem(DictItemImpl.of(dict, itemCode).addItemName(locale, itemName));
        } else {
            dictItemImpl.addItemName(locale, itemName);
        }
    }
}

