/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.yusp.commons.module.standard;

import cn.com.yusys.yusp.commons.module.standard.StandardField;
import java.util.Collection;
import java.util.HashMap;
import java.util.Objects;

public class StandardFields {
    private static final HashMap<String, StandardField> FIELD_MAPPING = new HashMap(1000);

    public static <T extends StandardField> void register(T ... fields) {
        if (Objects.isNull(fields)) {
            return;
        }
        for (T field : fields) {
            FIELD_MAPPING.put(field.fieldName(), (StandardField)field);
        }
    }

    public static <T extends StandardField> void register(Collection<StandardField> fields) {
        if (Objects.isNull(fields)) {
            return;
        }
        for (StandardField field : fields) {
            FIELD_MAPPING.put(field.fieldName(), field);
        }
    }

    public static StandardField getField(String fieldName) {
        return FIELD_MAPPING.get(fieldName);
    }

    private StandardFields() {
    }
}

