/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.yusp.commons.autoconfigure.mybatis;

import com.baomidou.mybatisplus.extension.spring.MybatisSqlSessionFactoryBean;
import java.sql.SQLException;
import java.util.Map;
import javax.sql.DataSource;
import org.apache.ibatis.session.SqlSessionFactory;
import org.mybatis.spring.SqlSessionFactoryBean;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.actuate.autoconfigure.jdbc.DataSourceHealthContributorAutoConfiguration;
import org.springframework.boot.actuate.health.AbstractHealthIndicator;
import org.springframework.boot.actuate.jdbc.DataSourceHealthIndicator;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.jdbc.metadata.DataSourcePoolMetadataProvider;
import org.springframework.context.annotation.Configuration;
import org.springframework.util.StringUtils;

@Configuration
@ConditionalOnClass(value={SqlSessionFactory.class, SqlSessionFactoryBean.class, MybatisSqlSessionFactoryBean.class})
public class DataSourceHealthConfig
extends DataSourceHealthContributorAutoConfiguration {
    @Value(value="${mybatis-plus.validation-query:select 1}")
    public String validationQuery;

    protected AbstractHealthIndicator createIndicator(DataSource source) {
        DataSourceHealthIndicator indicator = (DataSourceHealthIndicator)super.createIndicator(source);
        String driverName = null;
        try {
            driverName = source.getConnection().getMetaData().getDriverName().toLowerCase();
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        if (null != driverName && driverName.contains("oracle")) {
            this.validationQuery = "SELECT 1 FROM DUAL";
        }
        if (!StringUtils.hasText((String)indicator.getQuery())) {
            indicator.setQuery(this.validationQuery);
        }
        return indicator;
    }

    public DataSourceHealthConfig(Map<String, DataSource> dataSources, ObjectProvider<DataSourcePoolMetadataProvider> metadataProviders) {
        super(dataSources, metadataProviders);
    }
}

