/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.yusp.commons.autoconfigure.file;

import cn.com.yusys.yusp.commons.autoconfigure.file.FileAutoConfiguration;
import cn.com.yusys.yusp.commons.autoconfigure.file.FileClientRegister;
import cn.com.yusys.yusp.commons.autoconfigure.file.FileProperties;
import cn.com.yusys.yusp.commons.file.client.ConnectConfig;
import cn.com.yusys.yusp.commons.file.client.tencentcos.ContentType;
import cn.com.yusys.yusp.commons.file.client.tencentcos.CosConfig;
import cn.com.yusys.yusp.commons.file.client.tencentcos.CosConfigUtils;
import cn.com.yusys.yusp.commons.file.client.tencentcos.CosFileClient;
import cn.com.yusys.yusp.commons.file.client.tencentcos.CosFileSystemTemplate;
import cn.com.yusys.yusp.commons.file.client.tencentcos.DefaultCosClientPostProcessor;
import cn.com.yusys.yusp.commons.file.client.tencentcos.InstantiationCosClientPostProcessor;
import cn.com.yusys.yusp.commons.file.template.FileSystemTemplate;
import cn.com.yusys.yusp.commons.file.template.FileSystemTemplateRegister;
import cn.com.yusys.yusp.commons.util.StringUtils;
import cn.com.yusys.yusp.commons.util.collection.CollectionUtils;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.boot.autoconfigure.AutoConfigureBefore;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.context.annotation.Bean;
import org.springframework.core.env.Environment;

@ConditionalOnClass(value={ConnectConfig.class, CosFileClient.class})
@AutoConfigureBefore(value={FileAutoConfiguration.class})
public class TencentCosFileAutoConfiguration {
    @Bean
    public InstantiationCosClientPostProcessor defaultCosClientPostProcessor() {
        return new DefaultCosClientPostProcessor();
    }

    @Bean
    public FileClientRegister tencentCosFileClientRegister(final List<InstantiationCosClientPostProcessor> postProcessors) {
        return new FileClientRegister.AbstractFileClientRegister(){

            @Override
            public void register(BeanDefinitionRegistry registry, Environment environment, List<FileSystemTemplateRegister> fileSystemTemplateRegisters, FileProperties fileProperties) {
                CosConfig cosConfig = this.objectBind(environment, CosConfig.class, StringUtils.builder0((Object[])new Object[]{"yusp.file", ".", "tencent-cos"}));
                if (Objects.isNull(cosConfig)) {
                    return;
                }
                List cosConnectConfigs = cosConfig.getCosConfigs();
                if (CollectionUtils.nonEmpty((Collection)cosConnectConfigs)) {
                    cosConnectConfigs.forEach(cosConnectConfig -> {
                        cosConnectConfig.setHttp(CosConfigUtils.httpSet((CosConfig.Http)cosConfig.getHttp(), (CosConfig.Http)cosConnectConfig.getHttp()));
                        cosConnectConfig.setSecret(CosConfigUtils.secretSet((CosConfig.Secret)cosConfig.getSecret(), (CosConfig.Secret)cosConnectConfig.getSecret()));
                        cosConnectConfig.setRetry(CosConfigUtils.retrySet((CosConfig.Retry)cosConfig.getRetry(), (CosConfig.Retry)cosConnectConfig.getRetry()));
                    });
                }
                super.register(registry, CosFileClient.class, cosConnectConfigs, fileProperties.getConnectionPool(), fileSystemTemplateRegisters, beanDefinitionBuilder -> beanDefinitionBuilder.addConstructorArgValue((Object)postProcessors));
                if (CollectionUtils.nonEmpty((Map)cosConfig.getContentTypes())) {
                    ContentType.addContentTypes((Map)cosConfig.getContentTypes());
                }
            }
        };
    }

    @Bean
    public FileSystemTemplate cosFileSystemTemplate(CosFileClient fileClient) {
        return new CosFileSystemTemplate(fileClient);
    }
}

