/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.yusp.commons.autoconfigure.file;

import cn.com.yusys.yusp.commons.autoconfigure.file.FileClientRegister;
import cn.com.yusys.yusp.commons.autoconfigure.file.FileProperties;
import cn.com.yusys.yusp.commons.file.FileClient;
import cn.com.yusys.yusp.commons.file.template.FileSystemTemplateFactory;
import cn.com.yusys.yusp.commons.file.template.FileSystemTemplateRegister;
import cn.com.yusys.yusp.commons.util.StringUtils;
import cn.com.yusys.yusp.commons.util.collection.CollectionUtils;
import java.lang.annotation.Annotation;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.beans.factory.support.BeanDefinitionRegistryPostProcessor;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.boot.context.properties.bind.Bindable;
import org.springframework.boot.context.properties.bind.Binder;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.context.annotation.Bean;
import org.springframework.core.env.Environment;

@ConditionalOnClass(value={FileClient.class})
@EnableConfigurationProperties(value={FileProperties.class})
public class FileAutoConfiguration {
    @Bean
    public FileClientPostProcessor fileClientPostProcessor(ObjectProvider<List<FileSystemTemplateRegister>> fileSystemTemplateRegisters, ObjectProvider<List<FileClientRegister>> fileClientRegisters) {
        return new FileClientPostProcessor((List)fileSystemTemplateRegisters.getIfAvailable(), (List)fileClientRegisters.getIfAvailable());
    }

    static class FileClientPostProcessor
    implements BeanDefinitionRegistryPostProcessor,
    ApplicationContextAware {
        private static final Logger logger = LoggerFactory.getLogger(FileClientPostProcessor.class);
        private BeanDefinitionRegistry registry;
        private ApplicationContext applicationContext;
        private final List<FileSystemTemplateRegister> fileSystemTemplateRegisters;
        private final List<FileClientRegister> fileClientRegisters;

        public FileClientPostProcessor(List<FileSystemTemplateRegister> fileSystemTemplateRegisters, List<FileClientRegister> fileClientRegisters) {
            this.fileSystemTemplateRegisters = fileSystemTemplateRegisters;
            this.fileClientRegisters = fileClientRegisters;
        }

        public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
            this.applicationContext = applicationContext;
        }

        public void postProcessBeanDefinitionRegistry(BeanDefinitionRegistry registry) throws BeansException {
            this.registry = registry;
        }

        public void postProcessBeanFactory(ConfigurableListableBeanFactory beanFactory) throws BeansException {
            ConfigurationProperties annotation = FileProperties.class.getAnnotation(ConfigurationProperties.class);
            FileProperties properties = new FileProperties();
            Binder binder = Binder.get((Environment)this.applicationContext.getEnvironment());
            binder.bind(annotation.prefix(), Bindable.ofInstance((Object)properties).withAnnotations(new Annotation[]{annotation}));
            this.register(properties);
            logger.info("File server and File system template bean has register finish!");
        }

        private void register(FileProperties fileProperties) {
            if (CollectionUtils.nonEmpty(this.fileClientRegisters)) {
                for (FileClientRegister register : this.fileClientRegisters) {
                    register.register(this.registry, this.applicationContext.getEnvironment(), this.fileSystemTemplateRegisters, fileProperties);
                }
                FileProperties.Temp temp = fileProperties.getTemp();
                if (StringUtils.nonBlank((CharSequence)temp.getClientNameRef()) && StringUtils.nonBlank((CharSequence)temp.getDefaultPath())) {
                    BeanDefinitionBuilder tempBeanBuilder = BeanDefinitionBuilder.genericBeanDefinition(FileSystemTemplateFactory.class);
                    tempBeanBuilder.addConstructorArgReference(temp.getClientNameRef());
                    tempBeanBuilder.addConstructorArgValue(this.fileSystemTemplateRegisters);
                    tempBeanBuilder.addConstructorArgValue((Object)temp.getDefaultPath());
                    this.registry.registerBeanDefinition("tmpFileTemplate", (BeanDefinition)tempBeanBuilder.getBeanDefinition());
                }
            }
        }
    }
}

