/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.yusp.commons.autoconfigure.exception;

import cn.com.yusys.yusp.commons.rest.AbstractClientHttpRequestInterceptor;
import java.util.List;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.boot.autoconfigure.AutoConfigureBefore;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.web.client.RestTemplateAutoConfiguration;
import org.springframework.boot.web.client.RestTemplateCustomizer;
import org.springframework.context.annotation.Bean;
import org.springframework.core.annotation.AnnotationAwareOrderComparator;
import org.springframework.web.client.RestTemplate;

@AutoConfigureBefore(value={RestTemplateAutoConfiguration.class})
@ConditionalOnClass(value={RestTemplate.class, RestTemplateCustomizer.class})
public class YuRestTemplateAutoConfiguration {
    private static final Logger log = LoggerFactory.getLogger(YuRestTemplateAutoConfiguration.class);

    @Bean
    @ConditionalOnMissingBean
    public InterceptorsRestTemplateCustomizer bizExceptionRestTemplateCustomizer(ObjectProvider<AbstractClientHttpRequestInterceptor> interceptorsProvider) {
        return new InterceptorsRestTemplateCustomizer(interceptorsProvider);
    }

    static class InterceptorsRestTemplateCustomizer
    implements RestTemplateCustomizer {
        private final ObjectProvider<AbstractClientHttpRequestInterceptor> interceptorsProvider;

        public InterceptorsRestTemplateCustomizer(ObjectProvider<AbstractClientHttpRequestInterceptor> interceptorsProvider) {
            this.interceptorsProvider = interceptorsProvider;
        }

        public void customize(RestTemplate restTemplate) {
            List interceptors = this.interceptorsProvider.stream().collect(Collectors.toList());
            List interceptorList = restTemplate.getInterceptors();
            interceptors.addAll(interceptorList);
            List requestInterceptors = interceptors.stream().distinct().sorted(AnnotationAwareOrderComparator.INSTANCE).collect(Collectors.toList());
            log.debug("\u6dfb\u52a0RestTemplate\u62e6\u622a\u5668:{}", requestInterceptors);
            restTemplate.setInterceptors(requestInterceptors);
        }
    }
}

