/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.yusp.commons.autoconfigure.exception;

import cn.com.yusys.yusp.commons.autoconfigure.context.MessageSpecProperties;
import cn.com.yusys.yusp.commons.biz.BizMvcHandlerInterceptor;
import cn.com.yusys.yusp.commons.exception.rest.BizExceptionResponseInterceptor;
import cn.com.yusys.yusp.commons.exception.web.ExceptionTranslator;
import cn.com.yusys.yusp.commons.exception.web.adapter.BizMvcHandlerInterceptAdapter;
import cn.com.yusys.yusp.commons.exception.web.handler.IExceptionAfterHandler;
import cn.com.yusys.yusp.commons.exception.web.handler.IExceptionHandler;
import cn.com.yusys.yusp.commons.exception.web.handler.impl.ExceptionAfterHandlerImpl;
import cn.com.yusys.yusp.commons.exception.web.handler.impl.ExceptionHandlerImpl;
import cn.com.yusys.yusp.commons.exception.web.handler.impl.ExceptionLogImpl;
import cn.com.yusys.yusp.commons.exception.web.handler.impl.ExceptionSqlHandlerImpl;
import cn.com.yusys.yusp.commons.security.exception.AuthExceptionHandler;
import cn.com.yusys.yusp.commons.util.collection.CollectionUtils;
import java.util.Collection;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.boot.web.client.RestTemplateCustomizer;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.annotation.AnnotationAwareOrderComparator;
import org.springframework.core.annotation.Order;
import org.springframework.web.client.RestTemplate;

@Configuration
@EnableConfigurationProperties(value={MessageSpecProperties.class})
@ConditionalOnClass(value={ExceptionTranslator.class})
@ConditionalOnProperty(name={"yusp.exception.enabled"}, havingValue="true", matchIfMissing=true)
public class WebExceptionAutoConfiguration {
    private static final Logger log = LoggerFactory.getLogger(WebExceptionAutoConfiguration.class);

    @Bean
    public ExceptionAfterHandlerImpl exceptionAfterHandlerImpl() {
        return new ExceptionAfterHandlerImpl();
    }

    @Bean
    @ConditionalOnMissingBean
    public ExceptionHandlerImpl exceptionHandlerImpl(ObjectProvider<IExceptionAfterHandler> provider, MessageSpecProperties properties) {
        ExceptionHandlerImpl exceptionHandler = new ExceptionHandlerImpl((IExceptionAfterHandler)provider.getIfAvailable());
        exceptionHandler.setSeverExceptionMessage(properties.getServerExceptionMsg());
        return exceptionHandler;
    }

    @Bean
    @Order(value=0)
    @ConditionalOnProperty(name={"yusp.online-log.enabled"}, havingValue="true")
    public ExceptionLogImpl exceptionLogInterface() {
        return new ExceptionLogImpl();
    }

    @Bean
    @Order(value=0)
    public ExceptionSqlHandlerImpl exceptionSqlHandler() {
        return new ExceptionSqlHandlerImpl();
    }

    @Bean
    public ExceptionTranslator exceptionTranslator(ObjectProvider<List<IExceptionHandler<?>>> listObjectProvider) {
        List exceptionHandlers = (List)listObjectProvider.getIfAvailable();
        if (CollectionUtils.nonEmpty((Collection)exceptionHandlers)) {
            AnnotationAwareOrderComparator.sort((List)exceptionHandlers);
        }
        return new ExceptionTranslator(exceptionHandlers);
    }

    @Configuration
    @ConditionalOnClass(value={BizMvcHandlerInterceptor.class, ExceptionTranslator.class})
    @AutoConfigureAfter(value={WebExceptionAutoConfiguration.class})
    static class BizMvcHandlerInterceptorAdapterAutoConfiguration {
        BizMvcHandlerInterceptorAdapterAutoConfiguration() {
        }

        @Bean
        @Order(value=-2147483648)
        public BizMvcHandlerInterceptor webExceptionHandlerAdapter(ExceptionTranslator exceptionTranslator) {
            return new BizMvcHandlerInterceptAdapter(exceptionTranslator);
        }
    }

    @Configuration
    @ConditionalOnClass(value={AuthExceptionHandler.class})
    static class SecurityExceptionConfiguration {
        SecurityExceptionConfiguration() {
        }

        @Bean
        @Order(value=0)
        public AuthExceptionHandler authExceptionHandler(ObjectProvider<IExceptionAfterHandler> afterHandlerInterfaces, MessageSpecProperties messageSpecProperties) {
            AuthExceptionHandler authExceptionHandler = new AuthExceptionHandler((IExceptionAfterHandler)afterHandlerInterfaces.getIfAvailable());
            authExceptionHandler.setSeverExceptionMessage(messageSpecProperties.getServerExceptionMsg());
            return authExceptionHandler;
        }
    }

    @Configuration
    @ConditionalOnClass(value={RestTemplate.class, RestTemplateCustomizer.class, BizExceptionResponseInterceptor.class})
    static class RestExceptionConfiguration {
        RestExceptionConfiguration() {
        }

        @Order(value=2147483627)
        @Bean
        @ConditionalOnMissingBean
        public BizExceptionResponseInterceptor bizExceptionResponseInterceptor() {
            log.debug("Inject BizExceptionResponseInterceptor.");
            return new BizExceptionResponseInterceptor();
        }
    }
}

