/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.yusp.commons.autoconfigure.crypt;

import cn.com.yusys.yusp.commons.crypt.DecryptPropertyService;
import cn.com.yusys.yusp.commons.crypt.EncryptionPropertyResolver;
import cn.com.yusys.yusp.commons.util.StringUtils;
import com.ulisesbocchio.jasyptspringboot.EncryptablePropertySourceConverter;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.beans.factory.support.BeanDefinitionRegistryPostProcessor;
import org.springframework.boot.origin.OriginTrackedValue;
import org.springframework.core.Ordered;
import org.springframework.core.env.ConfigurableEnvironment;
import org.springframework.core.env.MutablePropertySources;

public class EnableEncryptablePropertiesBeanFactoryPostProcessor
implements BeanDefinitionRegistryPostProcessor,
Ordered {
    private static final Logger LOG = LoggerFactory.getLogger(EnableEncryptablePropertiesBeanFactoryPostProcessor.class);
    private final ConfigurableEnvironment environment;
    private final EncryptablePropertySourceConverter converter;
    private final DecryptPropertyService resolver;

    public EnableEncryptablePropertiesBeanFactoryPostProcessor(ConfigurableEnvironment environment, EncryptablePropertySourceConverter converter, DecryptPropertyService resolver) {
        this.environment = environment;
        this.converter = converter;
        this.resolver = resolver;
    }

    public void postProcessBeanFactory(ConfigurableListableBeanFactory beanFactory) throws BeansException {
        LOG.info("Post-processing PropertySource instances");
        MutablePropertySources propSources = this.environment.getPropertySources();
        this.customizedPropertyEncryp();
        this.converter.convertPropertySources(propSources);
    }

    public int getOrder() {
        return Integer.MIN_VALUE;
    }

    public void postProcessBeanDefinitionRegistry(BeanDefinitionRegistry beanDefinitionRegistry) throws BeansException {
    }

    private void customizedPropertyEncryp() {
        MutablePropertySources propSources = this.environment.getPropertySources();
        propSources.forEach(propertySource -> {
            Object source = propertySource.getSource();
            if (source instanceof Map) {
                Map sourcemap = (Map)source;
                Set entries = sourcemap.entrySet();
                for (Map.Entry entry : entries) {
                    Object val;
                    Object value = entry.getValue();
                    if (!(value instanceof OriginTrackedValue) || !((String)entry.getKey()).contains("message") || !((val = ((OriginTrackedValue)value).getValue()) instanceof String) || StringUtils.isEmpty((CharSequence)((String)val)) || !((String)val).startsWith("DECRYPT")) continue;
                    String decryptedVal = this.resolver.doDecrypt(((String)val).substring(EncryptionPropertyResolver.ENCRYPT_INDEX_PREFIX_LENGTH));
                    System.setProperty((String)entry.getKey(), decryptedVal);
                }
            }
        });
    }
}

