/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.yusp.commons.autoconfigure.context;

import brave.propagation.B3Propagation;
import brave.propagation.ExtraFieldCustomizer;
import brave.propagation.ExtraFieldPropagation;
import brave.propagation.Propagation;
import cn.com.yusys.yusp.commons.autoconfigure.context.ContextFactoryBuilder;
import cn.com.yusys.yusp.commons.autoconfigure.context.FactoryBuilder;
import cn.com.yusys.yusp.commons.context.ContextProcessorFactory;
import cn.com.yusys.yusp.commons.context.brave.TraceContextProcessorFactory;
import cn.com.yusys.yusp.commons.context.feign.EnhanceContextResponseOutAdvice;
import cn.com.yusys.yusp.commons.context.trace.span.ClassSpanNamer;
import cn.com.yusys.yusp.commons.util.collection.CollectionUtils;
import java.util.Collection;
import java.util.List;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.AutoConfigureBefore;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.cloud.sleuth.autoconfig.SleuthProperties;
import org.springframework.cloud.sleuth.autoconfig.TraceAutoConfiguration;
import org.springframework.cloud.sleuth.sampler.SamplerAutoConfiguration;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
@ConditionalOnClass(value={Propagation.Factory.class, ContextProcessorFactory.class})
@EnableConfigurationProperties(value={SleuthProperties.class})
@AutoConfigureBefore(value={TraceAutoConfiguration.class})
@AutoConfigureAfter(value={SamplerAutoConfiguration.class})
public class ContextTracingAutoConfiguration {
    @Bean
    public ClassSpanNamer spanNamer() {
        return new ClassSpanNamer();
    }

    @Bean
    @ConditionalOnMissingBean
    public ContextProcessorFactory contextProcessorFactory() {
        return new TraceContextProcessorFactory();
    }

    @Bean
    @ConditionalOnMissingBean
    public EnhanceContextResponseOutAdvice enhanceContextResponseOutAdvice(ContextProcessorFactory contextProcessorFactory) {
        return new EnhanceContextResponseOutAdvice(contextProcessorFactory);
    }

    @Bean
    @ConditionalOnMissingBean
    public FactoryBuilder factoryBuilder(ContextProcessorFactory contextProcessorFactory) {
        return new ContextFactoryBuilder(B3Propagation.FACTORY, contextProcessorFactory);
    }

    @Bean
    @ConditionalOnBean(value={ExtraFieldCustomizer.class})
    public Propagation.Factory extraFieldsFactory(SleuthProperties sleuthProperties, FactoryBuilder factoryBuilder, @Autowired(required=false) ExtraFieldPropagation.FactoryBuilder extraFieldFactory, ObjectProvider<List<ExtraFieldCustomizer>> tracingCustomizerProvider) {
        List extraFieldCustomizers;
        ExtraFieldPropagation.FactoryBuilder builder = extraFieldFactory != null ? extraFieldFactory : ExtraFieldPropagation.newFactoryBuilder((Propagation.Factory)factoryBuilder.build());
        if (!sleuthProperties.getBaggageKeys().isEmpty()) {
            builder = builder.addPrefixedFields("baggage-", (Collection)sleuthProperties.getBaggageKeys()).addPrefixedFields("baggage_", (Collection)sleuthProperties.getBaggageKeys());
        }
        if (!sleuthProperties.getPropagationKeys().isEmpty()) {
            for (String key : sleuthProperties.getPropagationKeys()) {
                builder = builder.addField(key);
            }
        }
        if (CollectionUtils.nonEmpty((Collection)(extraFieldCustomizers = (List)tracingCustomizerProvider.getIfAvailable()))) {
            for (ExtraFieldCustomizer customizer : extraFieldCustomizers) {
                customizer.customize(builder);
            }
        }
        return builder.build();
    }
}

