/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.yusp.commons.autoconfigure.swagger;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.context.annotation.Bean;
import org.springframework.http.HttpMethod;
import org.springframework.security.config.annotation.web.WebSecurityConfigurer;
import org.springframework.security.config.annotation.web.builders.WebSecurity;

@ConditionalOnClass(name={"org.springframework.security.config.annotation.web.configuration.WebSecurityConfigurerAdapter", "cn.com.yusys.yusp.commons.swagger.filter.ProductionSecurityFilter"})
public class YuSwaggerSecurityConfiguration {
    private static final Logger log = LoggerFactory.getLogger(YuSwaggerSecurityConfiguration.class);

    @Bean
    @ConditionalOnMissingBean
    public SwaggerSecurityConfiguration swaggerSecurityConfiguration() {
        return new SwaggerSecurityConfiguration();
    }

    static class SwaggerSecurityConfiguration
    implements WebSecurityConfigurer<WebSecurity> {
        SwaggerSecurityConfiguration() {
        }

        public void init(WebSecurity builder) throws Exception {
        }

        public void configure(WebSecurity web) throws Exception {
            log.debug("Init swagger resource that need't validate");
            web.ignoring().mvcMatchers(HttpMethod.GET, "/doc.html,/swagger-ui*.html,/webjars/bycdao-ui/**,/swagger-resources/**,/v2/api-docs,/*/v2/api-docs".split(","));
        }
    }
}

