/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.yusp.commons.autoconfigure.swagger;

import cn.com.yusys.yusp.commons.autoconfigure.ribbon.OrderedRibbonRuleFactory;
import cn.com.yusys.yusp.commons.ribbon.RibbonRuleFactory;
import cn.com.yusys.yusp.commons.swagger.config.SwaggerConfigurer;
import cn.com.yusys.yusp.commons.swagger.zuul.RoutesProvider;
import cn.com.yusys.yusp.commons.swagger.zuul.ZuulHostPortPreferRule;
import cn.com.yusys.yusp.commons.swagger.zuul.ZuulRoutesProvider;
import cn.com.yusys.yusp.commons.swagger.zuul.ZuulSwaggerResourcesProvider;
import cn.com.yusys.yusp.commons.swagger.zuul.web.rest.ZuulSwaggerResources;
import com.netflix.loadbalancer.IRule;
import com.netflix.zuul.ZuulFilter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.cloud.client.discovery.DiscoveryClient;
import org.springframework.cloud.client.discovery.simple.SimpleDiscoveryClientAutoConfiguration;
import org.springframework.cloud.netflix.zuul.filters.RouteLocator;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Primary;
import org.springframework.core.annotation.Order;
import springfox.documentation.swagger.web.InMemorySwaggerResourcesProvider;

@ConditionalOnClass(value={ZuulFilter.class, IRule.class, RoutesProvider.class})
@AutoConfigureAfter(value={SimpleDiscoveryClientAutoConfiguration.class})
public class SwaggerZuulGatewayAutoConfiguration {
    private static final Logger log = LoggerFactory.getLogger(SwaggerZuulGatewayAutoConfiguration.class);
    public static final String HOST_PORT_PREFER_RIBBON_RULE_FACTORY = "hostPortPreferRibbonRuleFactory";

    @Bean
    @ConditionalOnMissingBean
    @ConditionalOnClass(name={"org.springframework.cloud.netflix.zuul.filters.RouteLocator"})
    public ZuulRoutesProvider zuulRoutesProvider(RouteLocator routeLocator) {
        log.debug("Load zuul route locator to impl RoutesProvider");
        return new ZuulRoutesProvider(routeLocator);
    }

    @Bean(name={"hostPortPreferRibbonRuleFactory"})
    @ConditionalOnMissingBean(name={"hostPortPreferRibbonRuleFactory"})
    public RibbonRuleFactory hostPortPreferRibbonRuleFactory() {
        return new OrderedRibbonRuleFactory(){

            public IRule getRibbonRule() {
                log.debug("Load ZuulHostPortPreferRule apply swagger page");
                return new ZuulHostPortPreferRule();
            }

            public int getOrder() {
                return -2147483638;
            }
        };
    }

    @Bean
    @Primary
    public ZuulSwaggerResourcesProvider resourcesProvider(RoutesProvider routesProvider, InMemorySwaggerResourcesProvider swaggerResourcesProvider) {
        log.debug("load custom SwaggerResourcesProvider: ZuulSwaggerResourcesProvider");
        return new ZuulSwaggerResourcesProvider(routesProvider, swaggerResourcesProvider);
    }

    @Bean
    @ConditionalOnMissingBean
    public ZuulSwaggerResources gatewayResources(DiscoveryClient discoveryClient) {
        log.debug("Load gateway resources: GatewayResources");
        return new ZuulSwaggerResources(discoveryClient);
    }

    @Bean
    @Order
    public SwaggerConfigurer configurer() {
        log.debug("Setting ui show mode is gateway");
        return ui -> ui.showExtensions(Boolean.valueOf(true));
    }
}

