/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.yusp.commons.autoconfigure.session;

import brave.Tracing;
import brave.baggage.BaggageField;
import brave.baggage.BaggagePropagation;
import brave.baggage.BaggagePropagationConfig;
import brave.baggage.BaggagePropagationCustomizer;
import brave.propagation.B3Propagation;
import brave.propagation.ExtraFieldCustomizer;
import brave.propagation.ExtraFieldPropagation;
import brave.propagation.Propagation;
import cn.com.yusys.yusp.commons.autoconfigure.context.ContextTracingAutoConfiguration;
import cn.com.yusys.yusp.commons.session.SessionContext;
import cn.com.yusys.yusp.commons.session.SessionService;
import cn.com.yusys.yusp.commons.session.compatible.UserService;
import cn.com.yusys.yusp.commons.session.compatible.impl.UserServiceCacheImpl;
import cn.com.yusys.yusp.commons.session.web.filter.SessionServletFilter;
import cn.com.yusys.yusp.commons.util.StringUtils;
import cn.com.yusys.yusp.commons.util.collection.CollectionUtils;
import java.util.Collection;
import java.util.EnumSet;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.servlet.DispatcherType;
import javax.servlet.Filter;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.AutoConfigureBefore;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.autoconfigure.condition.ConditionalOnWebApplication;
import org.springframework.boot.web.servlet.FilterRegistrationBean;
import org.springframework.cloud.sleuth.autoconfig.SleuthProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.annotation.AnnotationAwareOrderComparator;
import org.springframework.core.annotation.Order;

@Configuration
@AutoConfigureBefore(value={ContextTracingAutoConfiguration.class})
@ConditionalOnClass(value={SessionContext.class, SessionService.class, Tracing.class})
public class YuSessionAutoConfiguration {
    @Bean
    @Order
    public SessionPropagationCustomizer sessionPropagationCustomizer() {
        return new SessionPropagationCustomizer();
    }

    @Bean
    @ConditionalOnMissingBean
    public Propagation.Factory extraFieldsFactory(SleuthProperties sleuthProperties, @Autowired(required=false) BaggagePropagation.FactoryBuilder factoryBuilder, ObjectProvider<List<BaggagePropagationCustomizer>> baggagePropagationProviders) {
        List extraFieldCustomizers;
        BaggagePropagation.FactoryBuilder builder = factoryBuilder != null ? factoryBuilder : BaggagePropagation.newFactoryBuilder((Propagation.Factory)B3Propagation.FACTORY);
        if (!sleuthProperties.getBaggageKeys().isEmpty()) {
            BaggagePropagation.FactoryBuilder finalBuilder = builder;
            sleuthProperties.getBaggageKeys().stream().filter(StringUtils::nonEmpty).forEach(key -> {
                finalBuilder.add((BaggagePropagationConfig)BaggagePropagationConfig.SingleBaggageField.newBuilder((BaggageField)BaggageField.create((String)key)).addKeyName("baggage-" + key).build());
                finalBuilder.add((BaggagePropagationConfig)BaggagePropagationConfig.SingleBaggageField.newBuilder((BaggageField)BaggageField.create((String)key)).addKeyName("baggage_" + key).build());
            });
        }
        if (!sleuthProperties.getPropagationKeys().isEmpty()) {
            for (String key2 : sleuthProperties.getPropagationKeys()) {
                builder = builder.add((BaggagePropagationConfig)BaggagePropagationConfig.SingleBaggageField.newBuilder((BaggageField)BaggageField.create((String)key2)).build());
            }
        }
        if (CollectionUtils.nonEmpty((Collection)(extraFieldCustomizers = (List)baggagePropagationProviders.getIfAvailable()))) {
            AnnotationAwareOrderComparator.sort((List)extraFieldCustomizers);
            for (BaggagePropagationCustomizer customizer : extraFieldCustomizers) {
                customizer.customize(builder);
            }
        }
        return builder.build();
    }

    static class SessionPropagationCustomizer
    implements BaggagePropagationCustomizer,
    ExtraFieldCustomizer {
        private static final AtomicBoolean initlizating = new AtomicBoolean(false);

        SessionPropagationCustomizer() {
        }

        public void customize(BaggagePropagation.FactoryBuilder builder) {
            if (initlizating.compareAndSet(false, true)) {
                builder.add((BaggagePropagationConfig)BaggagePropagationConfig.SingleBaggageField.newBuilder((BaggageField)BaggageField.create((String)"session-context")).addKeyName("baggage-session-context").build());
            }
        }

        public void customize(ExtraFieldPropagation.FactoryBuilder builder) {
            if (initlizating.compareAndSet(false, true)) {
                builder.addRedactedField("baggage-session-context");
            }
        }
    }

    @Deprecated
    @Configuration
    @ConditionalOnClass(value={UserService.class})
    @ConditionalOnProperty(prefix="application", value={"cache.user.enabled"}, havingValue="true")
    public static class SessionCompatibleAutoConfiguration {
        @Bean
        @ConditionalOnMissingBean(value={UserService.class})
        public UserService userCacheService() {
            return new UserServiceCacheImpl();
        }
    }

    @Configuration
    @ConditionalOnClass(name={"javax.servlet.Filter", "cn.com.yusys.yusp.commons.session.web.filter.SessionServletFilter"})
    static class SessionFilterAutoConfiguration {
        SessionFilterAutoConfiguration() {
        }

        @Bean
        @ConditionalOnWebApplication(type=ConditionalOnWebApplication.Type.SERVLET)
        public FilterRegistrationBean<Filter> sessionFilterRegistrationBean() {
            FilterRegistrationBean registration = new FilterRegistrationBean();
            registration.setFilter((Filter)new SessionServletFilter());
            registration.addUrlPatterns(new String[]{"/*"});
            EnumSet<DispatcherType> dispatcherTypes = EnumSet.of(DispatcherType.REQUEST, DispatcherType.FORWARD, DispatcherType.ASYNC);
            registration.setDispatcherTypes(dispatcherTypes);
            registration.setOrder(Integer.MIN_VALUE);
            return registration;
        }
    }
}

