/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.yusp.commons.autoconfigure.ribbon;

import brave.propagation.ExtraFieldCustomizer;
import cn.com.yusys.yusp.commons.autoconfigure.ribbon.DevModeExtraFieldCustomizer;
import cn.com.yusys.yusp.commons.autoconfigure.ribbon.OrderedRibbonRuleFactory;
import cn.com.yusys.yusp.commons.autoconfigure.ribbon.TracingDevModePreferRule;
import cn.com.yusys.yusp.commons.autoconfigure.ribbon.YuRibbonAutoConfiguration;
import cn.com.yusys.yusp.commons.ribbon.CompositeRule;
import cn.com.yusys.yusp.commons.ribbon.RibbonRuleFactory;
import cn.com.yusys.yusp.commons.ribbon.dev.DevModePreferRule;
import com.netflix.loadbalancer.ILoadBalancer;
import com.netflix.loadbalancer.IRule;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.AutoConfigureBefore;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.cloud.netflix.ribbon.RibbonClientConfiguration;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;
import org.springframework.context.annotation.Profile;

@Profile(value={"dev"})
@Configuration
@Import(value={TracingDevModeConfiguration.class})
@AutoConfigureBefore(value={YuRibbonAutoConfiguration.class})
@ConditionalOnClass(value={IRule.class, RibbonClientConfiguration.class, ILoadBalancer.class, CompositeRule.class})
public class RibbonDevAutoConfiguration {
    private static final Logger log = LoggerFactory.getLogger(RibbonDevAutoConfiguration.class);
    public static final String DEV_MODE_RIBBON_RULE = "devModeRibbonRuleFactory";

    @Bean(name={"devModeRibbonRuleFactory"})
    @ConditionalOnMissingBean(name={"devModeRibbonRuleFactory"})
    public RibbonRuleFactory devModeRibbonRuleFactory() {
        return new OrderedRibbonRuleFactory(){

            public int getOrder() {
                return -2147483633;
            }

            public IRule getRibbonRule() {
                log.debug("Load devModeRule.");
                return new DevModePreferRule();
            }
        };
    }

    @Configuration
    @ConditionalOnClass(value={ExtraFieldCustomizer.class, DevModePreferRule.class})
    static class TracingDevModeConfiguration {
        TracingDevModeConfiguration() {
        }

        @Bean
        @ConditionalOnClass
        @ConditionalOnMissingBean
        public DevModeExtraFieldCustomizer devModeExtraFieldCustomizer() {
            return new DevModeExtraFieldCustomizer();
        }

        @Bean(name={"devModeRibbonRuleFactory"})
        @ConditionalOnMissingBean(name={"devModeRibbonRuleFactory"})
        public RibbonRuleFactory devModeRibbonRuleFactory() {
            return new OrderedRibbonRuleFactory(){

                public int getOrder() {
                    return -2147483633;
                }

                public IRule getRibbonRule() {
                    log.debug("Load devModeRule with tracing.");
                    return new TracingDevModePreferRule();
                }
            };
        }
    }
}

