/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.yusp.commons.autoconfigure.ribbon;

import cn.com.yusys.yusp.commons.ribbon.CompositeRule;
import cn.com.yusys.yusp.commons.ribbon.RibbonRuleFactory;
import cn.com.yusys.yusp.commons.ribbon.dev.DevLoadBalancer;
import cn.com.yusys.yusp.commons.util.SpringContextUtils;
import com.netflix.client.config.CommonClientConfigKey;
import com.netflix.client.config.DefaultClientConfigImpl;
import com.netflix.client.config.IClientConfig;
import com.netflix.client.config.IClientConfigKey;
import com.netflix.loadbalancer.ILoadBalancer;
import com.netflix.loadbalancer.IPing;
import com.netflix.loadbalancer.IRule;
import com.netflix.loadbalancer.RoundRobinRule;
import com.netflix.loadbalancer.Server;
import com.netflix.loadbalancer.ServerList;
import com.netflix.loadbalancer.ServerListFilter;
import com.netflix.loadbalancer.ServerListUpdater;
import com.netflix.loadbalancer.ZoneAwareLoadBalancer;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.SearchStrategy;
import org.springframework.cloud.netflix.ribbon.PropertiesFactory;
import org.springframework.cloud.netflix.ribbon.RibbonClientName;
import org.springframework.context.annotation.Bean;

public class RibbonConfiguration {
    private static final Logger log = LoggerFactory.getLogger(RibbonConfiguration.class);
    public static final String ROUND_ROBIN_RULE = "roundRobinRuleConfigurer";
    @RibbonClientName
    private String name = "client";
    private PropertiesFactory propertiesFactory;

    public RibbonConfiguration(PropertiesFactory propertiesFactory) {
        this.propertiesFactory = propertiesFactory;
    }

    @Bean
    @ConditionalOnMissingBean
    public IClientConfig ribbonClientConfig(ObjectProvider<RibbonRuleFactory> ribbonRuleFactories) {
        DefaultClientConfigImpl config = new DefaultClientConfigImpl();
        config.loadProperties(this.name);
        config.set(CommonClientConfigKey.ConnectTimeout, (Object)1000);
        config.set(CommonClientConfigKey.ReadTimeout, (Object)1000);
        config.set(CommonClientConfigKey.GZipPayload, (Object)true);
        List rules = ribbonRuleFactories.orderedStream().map(RibbonRuleFactory::getRibbonRule).collect(Collectors.toList());
        CompositeRule rule = new CompositeRule();
        rule.setRuleList(rules);
        config.set((IClientConfigKey)CompositeRule.getInstance(), (Object)rule);
        return config;
    }

    @Bean(name={"roundRobinRuleConfigurer"})
    @ConditionalOnMissingBean(name={"roundRobinRuleConfigurer"})
    public RibbonRuleFactory roundRobinRuleConfigurer() {
        return () -> {
            log.debug("\u52a0\u8f7d\u8f6e\u8be2\u7b56\u7565.");
            return new RoundRobinRule();
        };
    }

    @Bean
    @ConditionalOnMissingBean(search=SearchStrategy.CURRENT)
    public ILoadBalancer ribbonLoadBalancer(IClientConfig config, ServerList<Server> serverList, ServerListFilter<Server> serverListFilter, IPing ping, ServerListUpdater serverListUpdater) {
        IRule rule;
        if (this.propertiesFactory.isSet(ILoadBalancer.class, this.name)) {
            return (ILoadBalancer)this.propertiesFactory.get(ILoadBalancer.class, config, this.name);
        }
        if (this.propertiesFactory.isSet(IRule.class, this.name)) {
            rule = (IRule)this.propertiesFactory.get(IRule.class, config, this.name);
        } else {
            log.debug("Load Composite Rule,when first rule return null,it will be exec continue!");
            CompositeRule compositeRule = new CompositeRule();
            compositeRule.initWithNiwsConfig(config);
            rule = compositeRule;
        }
        String[] profiles = SpringContextUtils.getApplicationContext().getEnvironment().getActiveProfiles();
        if (profiles.length > 0 && Arrays.stream(profiles).anyMatch("dev"::equalsIgnoreCase)) {
            log.info("Load DevLoadBalancer use Composite Rule!");
            return new DevLoadBalancer(config, rule, ping, serverList, serverListFilter, serverListUpdater);
        }
        log.debug("Load default ZoneAwareLoadBalancer use Composite Rule!");
        return new ZoneAwareLoadBalancer(config, rule, ping, serverList, serverListFilter, serverListUpdater);
    }
}

