/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.yusp.commons.autoconfigure.oplog;

import cn.com.yusys.yusp.commons.autoconfigure.oplog.OnlineLogProperties;
import cn.com.yusys.yusp.commons.autoconfigure.oplog.RabbitProperties;
import cn.com.yusys.yusp.commons.biz.bizlog.IBizExceptionLogSender;
import cn.com.yusys.yusp.commons.oplog.oplog.IOpLogSender;
import cn.com.yusys.yusp.commons.oplog.sender.BizLogSender;
import cn.com.yusys.yusp.commons.oplog.sender.OnlineLogBatchUpload;
import cn.com.yusys.yusp.commons.oplog.sender.OpLogHandlerInterceptor;
import cn.com.yusys.yusp.commons.oplog.sender.OpLogSender;
import java.util.HashSet;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.amqp.rabbit.connection.CachingConnectionFactory;
import org.springframework.amqp.rabbit.connection.ConnectionFactory;
import org.springframework.amqp.rabbit.core.RabbitTemplate;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.boot.autoconfigure.AutoConfigureBefore;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.EnvironmentAware;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Import;
import org.springframework.context.annotation.ImportBeanDefinitionRegistrar;
import org.springframework.core.env.Environment;
import org.springframework.core.type.AnnotationMetadata;
import org.springframework.lang.NonNull;
import org.springframework.util.CollectionUtils;

@ConditionalOnProperty(name={"yusp.online-log.enabled"}, havingValue="true")
@EnableConfigurationProperties(value={org.springframework.boot.autoconfigure.amqp.RabbitProperties.class, RabbitProperties.class, OnlineLogProperties.class})
@Import(value={RabbitDrivenImportBeanDefinitionRegistrar.class})
@AutoConfigureBefore(name={"cn.com.yusys.yusp.commons.autoconfigure.oplog.onlinelog.DefaultConfiguration"})
public class OnlineLogAutoConfiguration {
    public static final String ONLINE_LOG_ENABLED = "yusp.online-log.enabled";
    public static final String ONLINE_LOG_ENABLED_DEFAULT = "true";

    @Bean(name={"logRabbmitConnection"})
    public ConnectionFactory yuspRabbmitFactory(RabbitProperties properties) {
        CachingConnectionFactory connectionFactory = new CachingConnectionFactory();
        connectionFactory.setAddresses(properties.getAddresses());
        connectionFactory.setUsername(properties.getUsername());
        connectionFactory.setPassword(properties.getPassword());
        String virtualHost = properties.getVirtualHost();
        if (null != virtualHost && !"".equals(virtualHost)) {
            connectionFactory.setVirtualHost(virtualHost);
        }
        connectionFactory.setChannelCacheSize(5);
        return connectionFactory;
    }

    @Bean(name={"logRabbitTemplate"})
    public RabbitTemplate yuspRabbitTemplate(@Qualifier(value="logRabbmitConnection") ConnectionFactory connectionFactory) {
        RabbitTemplate rabbitTemplate = new RabbitTemplate(connectionFactory);
        rabbitTemplate.execute(channel -> {
            channel.queueDeclare("online-bizlog", true, false, false, null);
            channel.queueDeclare("online-oplog", true, false, false, null);
            return null;
        });
        return rabbitTemplate;
    }

    @Bean
    public OnlineLogBatchUpload opLogUpload(@Qualifier(value="logRabbitTemplate") RabbitTemplate rabbitTemplate, OnlineLogProperties opLogProperties) {
        return new OnlineLogBatchUpload(rabbitTemplate, opLogProperties.getBatchSize());
    }

    @Bean
    public IBizExceptionLogSender bizLogSender(OnlineLogBatchUpload logUpload) {
        return new BizLogSender(logUpload);
    }

    @Bean
    public IOpLogSender opLogSender(OnlineLogBatchUpload logUpload) {
        return new OpLogSender(logUpload);
    }

    @Bean
    public OpLogHandlerInterceptor onLineBizHandlerInterceptor(IOpLogSender logSender, OnlineLogProperties onlineLogProperties) {
        HashSet<String> urlSet = null;
        HashSet<String> ignoreUrlSet = null;
        List<String> urlList = onlineLogProperties.getUrls();
        List<String> ignoreUrlList = onlineLogProperties.getIgnoreUrls();
        if (!CollectionUtils.isEmpty(urlList)) {
            urlSet = new HashSet<String>(urlList);
        }
        if (!CollectionUtils.isEmpty(ignoreUrlList)) {
            ignoreUrlSet = new HashSet<String>(ignoreUrlList);
        }
        return new OpLogHandlerInterceptor(logSender, urlSet, ignoreUrlSet);
    }

    static class RabbitDrivenImportBeanDefinitionRegistrar
    implements ImportBeanDefinitionRegistrar,
    EnvironmentAware {
        public static final String RABBIT_DRIVEN_DEFINITION = "rabbitAnnotationDrivenConfiguration";
        private static final Logger LOG = LoggerFactory.getLogger(RabbitDrivenImportBeanDefinitionRegistrar.class);
        private static final String RABBIT_DRIVEN_CLASS = "org.springframework.boot.autoconfigure.amqp.RabbitAnnotationDrivenConfiguration";
        private Environment environment;

        RabbitDrivenImportBeanDefinitionRegistrar() {
        }

        public void registerBeanDefinitions(@NonNull AnnotationMetadata importingClassMetadata, @NonNull BeanDefinitionRegistry registry) {
            if (Boolean.TRUE.equals(Boolean.valueOf(this.environment.getProperty(OnlineLogAutoConfiguration.ONLINE_LOG_ENABLED))) && !registry.containsBeanDefinition(RABBIT_DRIVEN_DEFINITION)) {
                LOG.debug("online log enabled,import :{}", (Object)RABBIT_DRIVEN_CLASS);
                registry.registerBeanDefinition(RABBIT_DRIVEN_DEFINITION, (BeanDefinition)BeanDefinitionBuilder.genericBeanDefinition((String)RABBIT_DRIVEN_CLASS).getBeanDefinition());
            }
        }

        public void setEnvironment(@NonNull Environment environment) {
            this.environment = environment;
        }
    }
}

