/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.yusp.commons.autoconfigure.okhttp;

import cn.com.yusys.yusp.commons.session.util.SecurityUtils;
import cn.com.yusys.yusp.commons.util.StringUtils;
import cn.com.yusys.yusp.commons.util.encrypt.AESUtils;
import java.io.IOException;
import okhttp3.Interceptor;
import okhttp3.Request;
import okhttp3.Response;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TokenCopyInterceptor
implements Interceptor {
    private static final Logger logger = LoggerFactory.getLogger(TokenCopyInterceptor.class);
    private String appName;

    public TokenCopyInterceptor(String serviceName) {
        this.appName = serviceName;
    }

    public Response intercept(Interceptor.Chain chain) throws IOException {
        Request request;
        Request original;
        String accessToken = SecurityUtils.getCurrentUserToken();
        String encryptName = "";
        if (StringUtils.nonBlank((CharSequence)this.appName)) {
            encryptName = AESUtils.encrypt((String)this.appName, (String)"YUSP");
        }
        if (accessToken != null && !"".equals(accessToken)) {
            logger.info("Start injecting ,token[{}].", (Object)accessToken);
            original = chain.request();
            Request.Builder requestBuilder = original.newBuilder().addHeader("Authorization", "Bearer " + SecurityUtils.getCurrentUserToken());
            if (StringUtils.nonBlank((CharSequence)this.appName)) {
                requestBuilder.addHeader("appName", encryptName);
            }
            request = requestBuilder.build();
        } else {
            logger.info("No injection ,token[{}].", (Object)accessToken);
            original = chain.request();
            Request.Builder requestBuilder = original.newBuilder();
            if (StringUtils.nonBlank((CharSequence)this.appName)) {
                requestBuilder.addHeader("appName", encryptName);
            }
            request = requestBuilder.build();
        }
        logger.info("Send request ,url[{}].", (Object)request.url());
        Response response = chain.proceed(request);
        logger.info("Token injection completed, response code[{}]", (Object)response.code());
        return response;
    }
}

