/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.yusp.commons.autoconfigure.log;

import cn.com.yusys.yusp.commons.context.brave.ContextHolder;
import cn.com.yusys.yusp.commons.log.ApiData;
import cn.com.yusys.yusp.commons.log.ApiLogHelper;
import cn.com.yusys.yusp.commons.log.ApiReporter;
import cn.com.yusys.yusp.commons.util.LogUtils;
import cn.com.yusys.yusp.commons.util.ObjectMapperUtils;
import cn.com.yusys.yusp.commons.util.StringUtils;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.Map;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ContextApiLogHelper
implements ApiLogHelper {
    private static final Logger log = LoggerFactory.getLogger(ContextApiLogHelper.class);
    private static final String CONTEXT_REST_LOG_TEMPLATE = "[{}] --- \u5165\u53c2:{} \u8bf7\u6c42\u4e0a\u4e0b\u6587:{} \u8fd4\u56de\u7ed3\u679c:{} \u54cd\u5e94\u4e0a\u4e0b\u6587:{} \u6267\u884c\u72b6\u6001:{} \u8017\u65f6 :{} \u6beb\u79d2.";
    protected ObjectMapper objectMapper;
    private final ApiReporter apiReporter;

    public ContextApiLogHelper(ApiReporter apiReporter) {
        this.apiReporter = Objects.isNull(apiReporter) ? new ApiReporter.None() : apiReporter;
    }

    public ApiData before() {
        this.initObjectMapper();
        long begin = System.currentTimeMillis();
        ApiData apiData = new ApiData();
        apiData.setBeginTime(begin);
        apiData.setInputContext(LogUtils.parseParams(this.getContextHolder(), (ObjectMapper)this.objectMapper));
        return apiData;
    }

    public void afterComplete(ApiData apiData) {
        LogUtils.traceDebug((Logger)log, traceEnable -> StringUtils.format((String)CONTEXT_REST_LOG_TEMPLATE, (Object[])new Object[]{apiData.getPath(), LogUtils.parseParams((Object[])apiData.getArgs(), (traceEnable == false ? 1 : 0) != 0), apiData.getInputContext(), LogUtils.parseParam((Object)apiData.getResult(), (ObjectMapper)this.objectMapper, (traceEnable == false ? 1 : 0) != 0), LogUtils.parseParams(this.getContextHolder(), (ObjectMapper)this.objectMapper), apiData.getExecStatus(), apiData.getEndTime() - apiData.getBeginTime()}));
        if (apiData.isReport()) {
            this.apiReporter.report(apiData);
        }
    }

    Map<String, Object> getContextHolder() {
        return ContextHolder.get().getItems();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void initObjectMapper() {
        if (Objects.isNull(this.objectMapper)) {
            ContextApiLogHelper contextApiLogHelper = this;
            synchronized (contextApiLogHelper) {
                if (Objects.isNull(this.objectMapper)) {
                    this.objectMapper = ObjectMapperUtils.instance().copy();
                }
            }
        }
    }
}

