/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.yusp.commons.autoconfigure.job;

import cn.com.yusys.yusp.commons.autoconfigure.job.XxlJobProperties;
import cn.com.yusys.yusp.commons.job.core.executor.XxlJobExecutor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeansException;
import org.springframework.boot.ApplicationArguments;
import org.springframework.boot.ApplicationRunner;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.context.annotation.Bean;

@ConditionalOnProperty(name={"yusp.xxl.job.enabled"}, havingValue="true")
@EnableConfigurationProperties(value={XxlJobProperties.class})
public class XxlJobClientAutoConfiguration {
    private static final Logger logger = LoggerFactory.getLogger(XxlJobClientAutoConfiguration.class);
    private XxlJobProperties properties;

    public XxlJobClientAutoConfiguration(XxlJobProperties properties) {
        this.properties = properties;
    }

    @Bean(destroyMethod="destroy")
    public XxlJobExecutor xxlJobExecutor() {
        XxlJobExecutor xxlJobExecutor = new XxlJobExecutor();
        xxlJobExecutor.setAdminAddresses(this.properties.getAdmin().getAddresses());
        xxlJobExecutor.setAppName(this.properties.getExecutor().getAppname());
        xxlJobExecutor.setIp(this.properties.getExecutor().getIp());
        xxlJobExecutor.setPort(this.properties.getExecutor().getPort());
        xxlJobExecutor.setLogPath(this.properties.getExecutor().getLogpath());
        xxlJobExecutor.setLogRetentionDays(this.properties.getExecutor().getLogretentiondays());
        xxlJobExecutor.setPermission(this.properties.getPermission());
        logger.info(">>>>>>>>>>> xxl-job config init finish!");
        return xxlJobExecutor;
    }

    @Bean
    public XxlJobStartup xxlJobStartup() {
        return new XxlJobStartup();
    }

    public static class XxlJobStartup
    implements ApplicationRunner,
    ApplicationContextAware {
        private static final Logger logger = LoggerFactory.getLogger(XxlJobStartup.class);
        private ApplicationContext ctx = null;

        public void run(ApplicationArguments args) {
            XxlJobExecutor executor = (XxlJobExecutor)this.ctx.getBean(XxlJobExecutor.class);
            try {
                executor.start();
            }
            catch (Exception e) {
                logger.error("xxl-job failed to start!", (Throwable)e);
                throw new RuntimeException(e);
            }
            logger.info("xxl-job started successfully!");
        }

        public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
            this.ctx = applicationContext;
        }
    }
}

