/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.yusp.commons.autoconfigure.idempotent;

import cn.com.yusys.yusp.commons.autoconfigure.idempotent.IdempotentProperties;
import cn.com.yusys.yusp.commons.idempotent.IdempotentAspect;
import cn.com.yusys.yusp.commons.idempotent.IdempotentStore;
import cn.com.yusys.yusp.commons.idempotent.IdempotentUtils;
import cn.com.yusys.yusp.commons.idempotent.annotation.Idempotent;
import cn.com.yusys.yusp.commons.idempotent.support.DatabaseIdempotentStore;
import cn.com.yusys.yusp.commons.idempotent.support.RedisIdempotentStore;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.autoconfigure.data.redis.RedisAutoConfiguration;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.EnableAspectJAutoProxy;
import org.springframework.core.annotation.Order;
import org.springframework.data.redis.core.StringRedisTemplate;
import org.springframework.jdbc.core.JdbcTemplate;

@Configuration
@EnableAspectJAutoProxy(proxyTargetClass=true)
@ConditionalOnClass(value={Idempotent.class})
@EnableConfigurationProperties(value={IdempotentProperties.class})
public class IdempotentAutoConfiguration {
    @Bean
    @Order
    public IdempotentAspect idempotentAspect() {
        return new IdempotentAspect();
    }

    @Configuration
    @ConditionalOnClass(value={Idempotent.class})
    @AutoConfigureAfter(value={DatabaseIdempotentAutoConfiguration.class, RedisIdempotentAutoConfiguration.class})
    public static class InitIdempotentAutoConfiguration {
        public InitIdempotentAutoConfiguration(IdempotentStore idempotentStore) {
            IdempotentUtils.setGlobalParams((IdempotentStore)idempotentStore);
        }
    }

    @Configuration
    @ConditionalOnClass(value={Idempotent.class})
    @ConditionalOnProperty(prefix="yusp.idempotent", name={"store-type"}, havingValue="database")
    public static class DatabaseIdempotentAutoConfiguration {
        @Bean
        public IdempotentStore dbIdempotentStore(JdbcTemplate jdbcTemplate, IdempotentProperties properties) {
            return new DatabaseIdempotentStore(jdbcTemplate, properties.getDatabase().getTableName(), properties.getDatabase().isEnabledInit());
        }
    }

    @Configuration
    @ConditionalOnProperty(prefix="yusp.idempotent", name={"store-type"}, havingValue="redis", matchIfMissing=true)
    @ConditionalOnClass(value={Idempotent.class})
    @AutoConfigureAfter(value={RedisAutoConfiguration.class})
    public static class RedisIdempotentAutoConfiguration {
        @Bean
        public IdempotentStore redisIdempotentStore(StringRedisTemplate redisTemplate, IdempotentProperties properties) {
            return new RedisIdempotentStore(redisTemplate, properties.getRedis().getCacheName(), properties.getRedis().getExpire());
        }
    }
}

