/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.yusp.commons.autoconfigure.file;

import cn.com.yusys.yusp.commons.autoconfigure.file.FileAutoConfiguration;
import cn.com.yusys.yusp.commons.autoconfigure.file.FileClientRegister;
import cn.com.yusys.yusp.commons.autoconfigure.file.FileProperties;
import cn.com.yusys.yusp.commons.file.client.ConnectConfig;
import cn.com.yusys.yusp.commons.file.client.sftp.SftpConfig;
import cn.com.yusys.yusp.commons.file.client.sftp.SftpFileClient;
import cn.com.yusys.yusp.commons.file.client.sftp.SftpFileSystemTemplate;
import cn.com.yusys.yusp.commons.file.template.FileSystemTemplateRegister;
import cn.com.yusys.yusp.commons.util.StringUtils;
import java.util.List;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.boot.autoconfigure.AutoConfigureBefore;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.context.annotation.Bean;
import org.springframework.core.env.Environment;

@ConditionalOnClass(value={ConnectConfig.class, SftpFileClient.class})
@AutoConfigureBefore(value={FileAutoConfiguration.class})
public class SftpFileAutoConfiguration {
    @Bean
    public FileClientRegister sftpFileClientRegister() {
        return new FileClientRegister.AbstractFileClientRegister(){

            @Override
            public void register(BeanDefinitionRegistry registry, Environment environment, List<FileSystemTemplateRegister> fileSystemTemplateRegisters, FileProperties fileProperties) {
                List<SftpConfig> sftpConfigs = this.listBind(environment, SftpConfig.class, StringUtils.builder0((Object[])new Object[]{"yusp.file", ".", "sftps"}));
                super.register(registry, SftpFileClient.class, sftpConfigs, fileProperties.getConnectionPool(), fileSystemTemplateRegisters, null);
            }
        };
    }

    @Bean
    public FileSystemTemplateRegister sftpFileSystemTemplateRegister() {
        return fileClient -> fileClient instanceof SftpFileClient ? new SftpFileSystemTemplate((SftpFileClient)fileClient) : null;
    }
}

