/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.yusp.commons.autoconfigure.file;

import cn.com.yusys.yusp.commons.autoconfigure.file.FileAutoConfiguration;
import cn.com.yusys.yusp.commons.autoconfigure.file.FileClientRegister;
import cn.com.yusys.yusp.commons.autoconfigure.file.FileProperties;
import cn.com.yusys.yusp.commons.file.client.ConnectConfig;
import cn.com.yusys.yusp.commons.file.client.localdisk.LocalDiskConfig;
import cn.com.yusys.yusp.commons.file.client.localdisk.LocalDiskFileClient;
import cn.com.yusys.yusp.commons.file.template.DefaultFileSystemTemplate;
import cn.com.yusys.yusp.commons.file.template.FileSystemTemplateRegister;
import cn.com.yusys.yusp.commons.util.StringUtils;
import java.util.List;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.boot.autoconfigure.AutoConfigureBefore;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.context.annotation.Bean;
import org.springframework.core.env.Environment;

@ConditionalOnClass(value={ConnectConfig.class, LocalDiskFileClient.class})
@AutoConfigureBefore(value={FileAutoConfiguration.class})
public class LocalDiskFileAutoConfiguration {
    @Bean
    public FileClientRegister localDiskFileClientRegister() {
        return new FileClientRegister.AbstractFileClientRegister(){

            @Override
            public void register(BeanDefinitionRegistry registry, Environment environment, List<FileSystemTemplateRegister> fileSystemTemplateRegisters, FileProperties fileProperties) {
                List<LocalDiskConfig> localDiskConfigs = this.listBind(environment, LocalDiskConfig.class, StringUtils.builder0((Object[])new Object[]{"yusp.file", ".", "localdisks"}));
                super.register(registry, LocalDiskFileClient.class, localDiskConfigs, fileProperties.getConnectionPool(), fileSystemTemplateRegisters, null);
            }
        };
    }

    @Bean
    public FileSystemTemplateRegister localDiskFileSystemTemplateRegister() {
        return fileClient -> fileClient instanceof LocalDiskFileClient ? new DefaultFileSystemTemplate(fileClient) : null;
    }
}

