/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.yusp.commons.autoconfigure.config.nacos;

import cn.com.yusys.yusp.commons.autoconfigure.config.ConfigAutoConfiguration;
import cn.com.yusys.yusp.commons.config.annotation.DataIdConverter;
import cn.com.yusys.yusp.commons.config.core.ConfigTemplate;
import cn.com.yusys.yusp.commons.config.nacos.NacosConfigApplicationListener;
import cn.com.yusys.yusp.commons.config.nacos.NacosConfigTemplate;
import cn.com.yusys.yusp.commons.config.nacos.NacosDataIdConverter;
import com.alibaba.cloud.nacos.NacosConfigManager;
import org.springframework.boot.autoconfigure.AutoConfigureBefore;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration(proxyBeanMethods=false)
@ConditionalOnClass(value={ConfigTemplate.class, NacosConfigManager.class})
@ConditionalOnProperty(name={"spring.cloud.nacos.config.enabled"}, matchIfMissing=true)
@AutoConfigureBefore(value={ConfigAutoConfiguration.class})
public class NacosConfigAutoConfiguration {
    @Bean
    public ConfigTemplate nacosConfigTemplate(NacosConfigManager configManager) {
        return new NacosConfigTemplate(configManager);
    }

    @Bean
    @ConditionalOnProperty(name={"spring.cloud.nacos.config.eagerLoad.enabled"}, havingValue="true")
    public NacosConfigApplicationListener nacosConfigApplicationListener() {
        return new NacosConfigApplicationListener();
    }

    @Bean
    @ConditionalOnMissingBean
    @ConditionalOnProperty(prefix="yusp.config.nacos", name={"yml-converter"})
    public DataIdConverter nacosDataIdConverter() {
        return new NacosDataIdConverter();
    }
}

