/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.yusp.commons.autoconfigure.shardingjdbc;

import cn.com.yusys.yusp.commons.autoconfigure.shardingjdbc.DataSourceRouteProperties;
import cn.com.yusys.yusp.commons.autoconfigure.shardingjdbc.SpringBootPropertiesConfigurationProperties;
import cn.com.yusys.yusp.commons.autoconfigure.shardingjdbc.SpringBootShardingRuleConfigurationProperties;
import cn.com.yusys.yusp.commons.shardingjdbc.ext.DataSourceRoutePropertiesDto;
import cn.com.yusys.yusp.commons.shardingjdbc.ext.mybatis.DataSourceNameInterceptor;
import cn.com.yusys.yusp.commons.util.Asserts;
import cn.com.yusys.yusp.commons.util.StringUtils;
import java.sql.SQLException;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import javax.naming.NamingException;
import javax.sql.DataSource;
import org.apache.ibatis.plugin.Interceptor;
import org.apache.shardingsphere.api.config.sharding.ShardingRuleConfiguration;
import org.apache.shardingsphere.core.yaml.config.sharding.YamlShardingRuleConfiguration;
import org.apache.shardingsphere.core.yaml.swapper.ShardingRuleConfigurationYamlSwapper;
import org.apache.shardingsphere.shardingjdbc.api.ShardingDataSourceFactory;
import org.apache.shardingsphere.spring.boot.datasource.DataSourcePropertiesSetter;
import org.apache.shardingsphere.spring.boot.datasource.DataSourcePropertiesSetterHolder;
import org.apache.shardingsphere.spring.boot.util.DataSourceUtil;
import org.apache.shardingsphere.spring.boot.util.PropertyUtil;
import org.apache.shardingsphere.underlying.common.config.DataSourceConfiguration;
import org.apache.shardingsphere.underlying.common.config.inline.InlineExpressionParser;
import org.apache.shardingsphere.underlying.common.exception.ShardingSphereException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.AutoConfigureBefore;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.autoconfigure.jdbc.DataSourceAutoConfiguration;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.EnvironmentAware;
import org.springframework.context.annotation.Bean;
import org.springframework.core.env.Environment;
import org.springframework.core.env.StandardEnvironment;
import org.springframework.jndi.JndiObjectFactoryBean;

@ConditionalOnClass(value={DataSourceConfiguration.class, DataSourceNameInterceptor.class})
@EnableConfigurationProperties(value={SpringBootShardingRuleConfigurationProperties.class, SpringBootPropertiesConfigurationProperties.class, DataSourceRouteProperties.class})
@ConditionalOnProperty(name={"spring.shardingsphere.enabled"}, matchIfMissing=true)
@AutoConfigureBefore(value={DataSourceAutoConfiguration.class})
public class ShardingJdbcAutoConfiguration
implements EnvironmentAware {
    private static final Logger log = LoggerFactory.getLogger(ShardingJdbcAutoConfiguration.class);
    private SpringBootShardingRuleConfigurationProperties shardingRule;
    private SpringBootPropertiesConfigurationProperties props;
    private Map<String, DataSource> dataSourceMap = new LinkedHashMap<String, DataSource>();
    private static final String JNDI_NAME = "jndi-name";
    private DataSourceRouteProperties dataSourceRouteProperties;

    public ShardingJdbcAutoConfiguration(SpringBootShardingRuleConfigurationProperties shardingRule, SpringBootPropertiesConfigurationProperties springBootPropertiesConfigurationProperties, DataSourceRouteProperties dataSourceRouteProperties) {
        this.shardingRule = shardingRule;
        this.props = springBootPropertiesConfigurationProperties;
        this.dataSourceRouteProperties = dataSourceRouteProperties;
    }

    @Bean
    public DataSource shardingDataSource() throws SQLException {
        return ShardingDataSourceFactory.createDataSource(this.dataSourceMap, (ShardingRuleConfiguration)new ShardingRuleConfigurationYamlSwapper().swap((YamlShardingRuleConfiguration)this.shardingRule), (Properties)this.props.getProps());
    }

    public final void setEnvironment(Environment environment) {
        String prefix = "spring.shardingsphere.datasource.";
        for (String each : this.getDataSourceNames(environment, prefix)) {
            try {
                this.dataSourceMap.put(each, this.getDataSource(environment, prefix, each));
            }
            catch (ReflectiveOperationException ex) {
                throw new ShardingSphereException("Can't find datasource type!", (Exception)ex);
            }
            catch (NamingException namingEx) {
                throw new ShardingSphereException("Can't find JNDI datasource!", (Exception)namingEx);
            }
        }
    }

    private List<String> getDataSourceNames(Environment environment, String prefix) {
        StandardEnvironment standardEnv = (StandardEnvironment)environment;
        standardEnv.setIgnoreUnresolvableNestedPlaceholders(true);
        return null == standardEnv.getProperty(prefix + "name") ? new InlineExpressionParser(standardEnv.getProperty(prefix + "names")).splitAndEvaluate() : Collections.singletonList(standardEnv.getProperty(prefix + "name"));
    }

    private DataSource getDataSource(Environment environment, String prefix, String dataSourceName) throws ReflectiveOperationException, NamingException {
        Map dataSourceProps = (Map)PropertyUtil.handle((Environment)environment, (String)(prefix + dataSourceName.trim()), Map.class);
        Asserts.isTrue((!dataSourceProps.isEmpty() ? 1 : 0) != 0, (String[])new String[]{"Wrong datasource properties!"});
        if (dataSourceProps.containsKey(JNDI_NAME)) {
            return this.getJndiDataSource(dataSourceProps.get(JNDI_NAME).toString());
        }
        DataSource result = DataSourceUtil.getDataSource((String)dataSourceProps.get("type").toString(), (Map)dataSourceProps);
        Optional dataSourcePropertiesSetter = DataSourcePropertiesSetterHolder.getDataSourcePropertiesSetterByType((String)dataSourceProps.get("type").toString());
        if (dataSourcePropertiesSetter.isPresent()) {
            ((DataSourcePropertiesSetter)dataSourcePropertiesSetter.get()).propertiesSet(environment, prefix, dataSourceName, result);
        }
        return result;
    }

    private DataSource getJndiDataSource(String jndiName) throws NamingException {
        JndiObjectFactoryBean bean = new JndiObjectFactoryBean();
        bean.setResourceRef(true);
        bean.setJndiName(jndiName);
        bean.setProxyInterface(DataSource.class);
        bean.afterPropertiesSet();
        return (DataSource)bean.getObject();
    }

    @Bean
    public Interceptor dataSourceNameInterceptor() {
        DataSourceNameInterceptor interceptor = new DataSourceNameInterceptor();
        DataSourceRoutePropertiesDto propertiesDto = new DataSourceRoutePropertiesDto();
        propertiesDto.setDefaultDataSourceName(this.dataSourceRouteProperties.getDefaultDataSourceName());
        Optional.ofNullable(this.dataSourceRouteProperties.getMultiple()).ifPresent(namespaces -> namespaces.stream().filter(StringUtils::nonEmpty).map(namespace -> StringUtils.split((String)StringUtils.trim((String)namespace), (String)"->")).forEach(strArr -> propertiesDto.addNameSpace(StringUtils.trim((String)strArr[0]), StringUtils.trim((String)strArr[1]))));
        Optional.ofNullable(this.dataSourceRouteProperties.getSharding()).ifPresent(sharding -> sharding.stream().filter(StringUtils::nonEmpty).map(StringUtils::trim).forEach(arg_0 -> ((DataSourceRoutePropertiesDto)propertiesDto).addOut(arg_0)));
        interceptor.setDataSourceRouteDto(propertiesDto);
        return interceptor;
    }
}

