/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.yusp.commons.autoconfigure.mybatis.tkmapper;

import cn.com.yusys.yusp.commons.autoconfigure.mybatis.tkmapper.MapperMybatisAutoConfiguration;
import cn.com.yusys.yusp.commons.autoconfigure.mybatis.tkmapper.MapperProperties;
import cn.com.yusys.yusp.commons.autoconfigure.mybatis.tkmapper.entity.EntityScannerRegistrarConfigurer;
import cn.com.yusys.yusp.commons.mapper.executor.SqlExecutor;
import cn.com.yusys.yusp.commons.mapper.sql.SqlHelper;
import cn.com.yusys.yusp.commons.mapper.util.MapperUtils;
import cn.com.yusys.yusp.commons.util.StringUtils;
import org.apache.ibatis.session.SqlSessionFactory;
import org.mybatis.spring.SqlSessionFactoryBean;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.context.ApplicationContext;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;

@Configuration
@ConditionalOnClass(value={SqlSessionFactory.class, SqlSessionFactoryBean.class, SqlExecutor.class})
@ConditionalOnBean(value={MapperMybatisAutoConfiguration.class})
@AutoConfigureAfter(value={MapperMybatisAutoConfiguration.class})
public class MapperAutoConfiguration {
    private static final Logger log = LoggerFactory.getLogger(MapperAutoConfiguration.class);

    public MapperAutoConfiguration(MapperProperties properties, ApplicationContext applicationContext) {
        SqlExecutor sqlExecutor = null;
        if (StringUtils.nonEmpty((CharSequence)properties.getSqlExecutor())) {
            try {
                sqlExecutor = (SqlExecutor)applicationContext.getBean(properties.getSqlExecutor(), SqlExecutor.class);
            }
            catch (BeansException e) {
                log.error("can not find {} bean that impl SqlExecutor", (Object)properties.getSqlExecutor());
            }
        } else {
            try {
                sqlExecutor = (SqlExecutor)applicationContext.getBean(SqlExecutor.class);
            }
            catch (BeansException e) {
                log.error("load SqlExecutor error", (Throwable)e);
            }
        }
        SqlHelper sqlHelper = null;
        if (StringUtils.nonEmpty((CharSequence)properties.getSqlHelper())) {
            try {
                sqlHelper = (SqlHelper)applicationContext.getBean(properties.getSqlHelper(), SqlHelper.class);
            }
            catch (BeansException e) {
                log.error("can not find {} bean that impl SqlHelper", (Object)properties.getSqlHelper());
            }
        } else {
            try {
                sqlHelper = (SqlHelper)applicationContext.getBean(SqlHelper.class);
            }
            catch (BeansException e) {
                log.error("load SqlHelper error", (Throwable)e);
            }
        }
        MapperUtils.init((SqlHelper)sqlHelper, (SqlExecutor)sqlExecutor);
        log.debug("init mapperUtils compete with SqlHelper and SqlExecutor");
    }

    @Configuration
    @Import(value={EntityScannerRegistrarConfigurer.class})
    public class EntityScannerRegistrarAutoConfiguration
    implements InitializingBean {
        public void afterPropertiesSet() {
        }
    }
}

