/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.yusp.commons.autoconfigure.mybatis.tkmapper;

import cn.com.yusys.yusp.commons.autoconfigure.mybatis.tkmapper.MapperMybatisAutoConfiguration;
import cn.com.yusys.yusp.commons.mapper.executor.SqlExecutor;
import cn.com.yusys.yusp.commons.mapper.sql.SqlHelper;
import cn.com.yusys.yusp.commons.mybatis.MapperScanBasePackage;
import cn.com.yusys.yusp.commons.scan.BasePackage;
import cn.com.yusys.yusp.commons.util.collection.CollectionUtils;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.ibatis.session.SqlSessionFactory;
import org.mybatis.spring.SqlSessionFactoryBean;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.beans.factory.support.BeanDefinitionRegistryPostProcessor;
import org.springframework.beans.factory.support.DefaultListableBeanFactory;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.context.annotation.Bean;
import org.springframework.core.env.Environment;
import org.springframework.util.StringUtils;
import tk.mybatis.spring.mapper.ClassPathMapperScanner;

@AutoConfigureAfter(value={MapperMybatisAutoConfiguration.class})
@ConditionalOnClass(value={SqlSessionFactory.class, SqlSessionFactoryBean.class, SqlExecutor.class, SqlHelper.class})
public class MapperAfterAutoConfiguration {
    @Bean
    public MapperBeanDefinitionRegistryPostProcessor mapperBeanDefinitionRegistryPostProcessor() {
        return new MapperBeanDefinitionRegistryPostProcessor();
    }

    static class MapperBeanDefinitionRegistryPostProcessor
    implements BeanDefinitionRegistryPostProcessor {
        private static final Logger logger = LoggerFactory.getLogger(MapperBeanDefinitionRegistryPostProcessor.class);

        MapperBeanDefinitionRegistryPostProcessor() {
        }

        public void postProcessBeanDefinitionRegistry(BeanDefinitionRegistry registry) throws BeansException {
            if (registry instanceof DefaultListableBeanFactory) {
                DefaultListableBeanFactory beanFactory = (DefaultListableBeanFactory)registry;
                List<String> packages = null;
                try {
                    String[] beanNames = beanFactory.getBeanNamesForType(MapperScanBasePackage.class);
                    packages = Arrays.stream(beanNames).map(beanName -> (MapperScanBasePackage)beanFactory.getBean(beanName)).map(BasePackage::basePackage).flatMap(Collection::stream).distinct().collect(Collectors.toList());
                }
                catch (Exception var6) {
                    logger.warn("Please config mybatis mapper scan path or add @MapperScan annotation!");
                }
                if (CollectionUtils.isEmpty(packages)) {
                    logger.warn("Not Config default scan package!");
                    return;
                }
                if (logger.isDebugEnabled()) {
                    packages.forEach(pkg -> logger.debug("Using auto-configuration base package '{}'", pkg));
                    logger.debug("Searching for mappers annotated with @Mapper");
                }
                ClassPathMapperScanner scanner = new ClassPathMapperScanner(registry);
                scanner.setMapperProperties((Environment)beanFactory.getBean(Environment.class));
                scanner.registerFilters();
                scanner.doScan(StringUtils.toStringArray(packages));
            }
        }

        public void postProcessBeanFactory(ConfigurableListableBeanFactory beanFactory) throws BeansException {
        }
    }
}

