/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.yusp.commons.autoconfigure.mybatis.plus;

import cn.com.yusys.yusp.commons.autoconfigure.mybatis.plus.MybatisPlusAutoConfiguration;
import cn.com.yusys.yusp.commons.mybatis.MapperScanBasePackage;
import cn.com.yusys.yusp.commons.scan.BasePackage;
import cn.com.yusys.yusp.commons.util.collection.CollectionUtils;
import com.baomidou.mybatisplus.core.mapper.Mapper;
import com.baomidou.mybatisplus.extension.spring.MybatisSqlSessionFactoryBean;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.ibatis.session.SqlSessionFactory;
import org.mybatis.spring.SqlSessionFactoryBean;
import org.mybatis.spring.mapper.MapperScannerConfigurer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanWrapperImpl;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.beans.factory.support.BeanDefinitionRegistryPostProcessor;
import org.springframework.beans.factory.support.DefaultListableBeanFactory;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.context.annotation.Bean;
import org.springframework.util.StringUtils;

@AutoConfigureAfter(value={MybatisPlusAutoConfiguration.class})
@ConditionalOnClass(value={SqlSessionFactory.class, SqlSessionFactoryBean.class, MybatisSqlSessionFactoryBean.class})
public class MybatisPlusAfterAutoConfiguration {
    @Bean
    public MybatisPlusMapperBeanDefinitionRegistryPostProcessor mapperBeanDefinitionRegistryPostProcessor() {
        return new MybatisPlusMapperBeanDefinitionRegistryPostProcessor();
    }

    static class MybatisPlusMapperBeanDefinitionRegistryPostProcessor
    implements BeanDefinitionRegistryPostProcessor {
        private static final Logger logger = LoggerFactory.getLogger(MybatisPlusMapperBeanDefinitionRegistryPostProcessor.class);

        MybatisPlusMapperBeanDefinitionRegistryPostProcessor() {
        }

        public void postProcessBeanDefinitionRegistry(BeanDefinitionRegistry registry) throws BeansException {
            if (registry instanceof DefaultListableBeanFactory) {
                DefaultListableBeanFactory beanFactory = (DefaultListableBeanFactory)registry;
                List<String> packages = null;
                try {
                    String[] beanNames = beanFactory.getBeanNamesForType(MapperScanBasePackage.class);
                    packages = Arrays.stream(beanNames).map(beanName -> (MapperScanBasePackage)beanFactory.getBean(beanName)).map(BasePackage::basePackage).flatMap(Collection::stream).distinct().collect(Collectors.toList());
                }
                catch (Exception e) {
                    logger.warn("Please config mybatis mapper scan path or add @MapperScan annotation!");
                }
                if (CollectionUtils.isEmpty(packages)) {
                    logger.warn("Not Config default scan package!");
                    return;
                }
                if (logger.isDebugEnabled()) {
                    packages.forEach(pkg -> logger.debug("Using auto-configuration base package '{}'", pkg));
                    logger.debug("Searching for mappers annotated with @Mapper");
                }
                BeanDefinitionBuilder builder = BeanDefinitionBuilder.genericBeanDefinition(MapperScannerConfigurer.class);
                builder.addPropertyValue("processPropertyPlaceHolders", (Object)true);
                builder.addPropertyValue("annotationClass", org.apache.ibatis.annotations.Mapper.class);
                builder.addPropertyValue("basePackage", (Object)StringUtils.collectionToCommaDelimitedString(packages));
                builder.addPropertyValue("markerInterface", Mapper.class);
                BeanWrapperImpl beanWrapper = new BeanWrapperImpl(MapperScannerConfigurer.class);
                Stream.of(beanWrapper.getPropertyDescriptors()).filter(x -> x.getName().equals("lazyInitialization")).findAny().ifPresent(x -> builder.addPropertyValue("lazyInitialization", (Object)"${mybatis.lazy-initialization:false}"));
                registry.registerBeanDefinition(MapperScannerConfigurer.class.getName(), (BeanDefinition)builder.getBeanDefinition());
            }
        }

        public void postProcessBeanFactory(ConfigurableListableBeanFactory beanFactory) throws BeansException {
        }
    }
}

