/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.yusp.commons.autoconfigure.logging;

import cn.com.yusys.yusp.commons.autoconfigure.logging.LoggingProperties;
import cn.com.yusys.yusp.commons.log.api.ApiLogger;
import cn.com.yusys.yusp.commons.log.api.collect.CustomInMemoryHttpTraceRepository;
import cn.com.yusys.yusp.commons.log.common.appender.JsonAppender;
import cn.com.yusys.yusp.commons.log.common.collect.TimedCollector;
import cn.com.yusys.yusp.commons.log.common.collect.TimedTaskExecutor;
import cn.com.yusys.yusp.commons.log.dbpool.DbPoolLogger;
import cn.com.yusys.yusp.commons.log.dbpool.collect.DbPoolTimedCollector;
import cn.com.yusys.yusp.commons.log.dbpool.collect.LocalLogDbPoolMetricsEndpoint;
import cn.com.yusys.yusp.commons.log.env.EnvLogger;
import cn.com.yusys.yusp.commons.log.env.collect.EnvTimedCollector;
import cn.com.yusys.yusp.commons.log.env.collect.LocalLogEnvAndConfigEndpoint;
import cn.com.yusys.yusp.commons.log.env.collect.YuspConfigurationPropertiesReportEndpoint;
import cn.com.yusys.yusp.commons.log.jvm.JvmLogger;
import cn.com.yusys.yusp.commons.log.jvm.collect.JvmTimedCollector;
import cn.com.yusys.yusp.commons.log.jvm.collect.LocalLogMetricsEndpoint;
import cn.com.yusys.yusp.commons.log.jvm.collect.LocalLogMetricsEndpointImpl;
import cn.com.yusys.yusp.commons.log.trace.TraceLogger;
import cn.com.yusys.yusp.commons.log.trace.reporter.TracingLoggerReporter;
import java.util.List;
import javax.sql.DataSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.boot.ApplicationRunner;
import org.springframework.boot.actuate.autoconfigure.context.properties.ConfigurationPropertiesReportEndpointProperties;
import org.springframework.boot.actuate.env.EnvironmentEndpoint;
import org.springframework.boot.actuate.health.HealthEndpoint;
import org.springframework.boot.actuate.info.InfoEndpoint;
import org.springframework.boot.actuate.management.ThreadDumpEndpoint;
import org.springframework.boot.actuate.metrics.MetricsEndpoint;
import org.springframework.boot.actuate.trace.http.HttpTraceRepository;
import org.springframework.boot.actuate.web.mappings.MappingsEndpoint;
import org.springframework.boot.autoconfigure.AutoConfigureBefore;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.cloud.sleuth.autoconfig.TraceAutoConfiguration;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.scheduling.TaskScheduler;
import org.springframework.scheduling.concurrent.ThreadPoolTaskScheduler;
import zipkin2.Span;
import zipkin2.reporter.Reporter;

@Configuration
@ConditionalOnClass(value={JsonAppender.class})
public class MetricLoggingAutoConfiguration {
    private static final Logger log = LoggerFactory.getLogger(MetricLoggingAutoConfiguration.class);
    private static final int LOGGER_POOL_SIZE = 4;
    private static final String LOG_TASK_PREFIX = "logging-metric-";
    public static final String LOGGER_REPORTER_BEAN = "tracingLogReporter";

    @Bean
    public TimedTaskExecutor timedTaskExecutor(ObjectProvider<List<TimedCollector>> collectorProvider) {
        List collectors = (List)collectorProvider.getIfAvailable();
        ThreadPoolTaskScheduler scheduler = new ThreadPoolTaskScheduler();
        scheduler.setPoolSize(4);
        scheduler.setThreadNamePrefix(LOG_TASK_PREFIX);
        scheduler.setDaemon(true);
        scheduler.initialize();
        return new TimedTaskExecutor((TaskScheduler)scheduler, collectors);
    }

    @Bean
    public ApplicationRunner logTimedTaskExecutorRunner(TimedTaskExecutor timedTaskExecutor) {
        return args -> timedTaskExecutor.init();
    }

    @Configuration
    @ConditionalOnProperty(value={"yusp.log.api.enabled"}, havingValue="true", matchIfMissing=true)
    @ConditionalOnClass(value={ApiLogger.class, HttpTraceRepository.class})
    static class ApiLoggingConfiguration {
        ApiLoggingConfiguration() {
        }

        @Bean
        public HttpTraceRepository traceRepository() {
            log.debug("Init Api logging trace repository.");
            return new CustomInMemoryHttpTraceRepository();
        }
    }

    @Configuration
    @ConditionalOnProperty(value={"yusp.log.trace.enabled"}, havingValue="true", matchIfMissing=true)
    @ConditionalOnClass(value={Reporter.class, TraceLogger.class})
    @AutoConfigureBefore(value={TraceAutoConfiguration.class})
    static class TraceLoggingConfiguration {
        TraceLoggingConfiguration() {
        }

        @Bean(name={"tracingLogReporter"})
        @ConditionalOnMissingBean(name={"tracingLogReporter"})
        public Reporter<Span> tracingLogReporter() {
            log.debug("Init LoggingReporter,will record tracing info into file.");
            return new TracingLoggerReporter();
        }
    }

    @Configuration
    @ConditionalOnProperty(value={"yusp.log.jvm.enabled"}, havingValue="true", matchIfMissing=true)
    @ConditionalOnClass(value={JvmLogger.class, MetricsEndpoint.class, HealthEndpoint.class, InfoEndpoint.class})
    static class JvmLoggingConfiguration {
        JvmLoggingConfiguration() {
        }

        @Bean
        @ConditionalOnMissingBean(value={LocalLogMetricsEndpoint.class})
        public LocalLogMetricsEndpoint restLocalLogMetricsEndpoint(MetricsEndpoint metricsEndpoint, HealthEndpoint healthEndpoint, InfoEndpoint infoEndpoint) {
            log.info("Init LocalLogMetricsEndpoint.");
            return new LocalLogMetricsEndpointImpl(metricsEndpoint, healthEndpoint, infoEndpoint);
        }

        @Bean
        public JvmTimedCollector jvmTimedCollector(LoggingProperties logging, LocalLogMetricsEndpoint endpoint) {
            log.debug("Init jvm metric collector.");
            return new JvmTimedCollector(logging.getJvm().getCollectFreq(), endpoint);
        }
    }

    @ConditionalOnClass(value={DbPoolLogger.class, MetricsEndpoint.class})
    @ConditionalOnProperty(value={"yusp.log.dbpool.enabled"}, havingValue="true", matchIfMissing=true)
    @ConditionalOnBean(value={DataSource.class})
    @Configuration
    static class DbPoolLoggingConfiguration {
        DbPoolLoggingConfiguration() {
        }

        @Bean
        @ConditionalOnMissingBean
        public LocalLogDbPoolMetricsEndpoint localLogDbPoolMetricsEndpoint(MetricsEndpoint metricsEndpoint) {
            log.debug("Init LocalLogDbPoolMetricsEndpoint.");
            return new LocalLogDbPoolMetricsEndpoint(metricsEndpoint);
        }

        @Bean
        public DbPoolTimedCollector dbPoolTimedCollector(LoggingProperties logging, LocalLogDbPoolMetricsEndpoint endpoint) {
            log.debug("Init db pool timed collector.");
            return new DbPoolTimedCollector(logging.getDbpool().getCollectFreq(), endpoint);
        }
    }

    @Configuration
    @ConditionalOnProperty(value={"yusp.log.env.enabled"}, havingValue="true", matchIfMissing=true)
    @EnableConfigurationProperties(value={LoggingProperties.class})
    @ConditionalOnClass(value={EnvLogger.class, MetricsEndpoint.class, HealthEndpoint.class, InfoEndpoint.class})
    static class EnvironmentLoggingConfiguration {
        EnvironmentLoggingConfiguration() {
        }

        @Bean
        @ConditionalOnMissingBean
        public YuspConfigurationPropertiesReportEndpoint yuspConfigurationPropertiesReportEndpoint(ConfigurationPropertiesReportEndpointProperties properties) {
            YuspConfigurationPropertiesReportEndpoint endpoint = new YuspConfigurationPropertiesReportEndpoint();
            String[] keysToSanitize = properties.getKeysToSanitize();
            if (keysToSanitize != null) {
                endpoint.setKeysToSanitize(keysToSanitize);
            }
            return endpoint;
        }

        @Bean
        @ConditionalOnMissingBean
        public LocalLogEnvAndConfigEndpoint envAndConfigEndpoint(YuspConfigurationPropertiesReportEndpoint configurationPropertiesReportEndpoint, MappingsEndpoint mappingsEndpoint, EnvironmentEndpoint environmentEndpoint, ThreadDumpEndpoint threadDumpEndpoint) {
            log.debug("Init LocalLogEnvAndConfigEndpoint.");
            return new LocalLogEnvAndConfigEndpoint(configurationPropertiesReportEndpoint, mappingsEndpoint, environmentEndpoint, threadDumpEndpoint);
        }

        @Bean
        public EnvTimedCollector envTimedCollector(LoggingProperties logging, LocalLogEnvAndConfigEndpoint endpoint) {
            log.debug("Init Env Metric collector.");
            return new EnvTimedCollector(logging.getEnv().getCollectFreq(), endpoint);
        }
    }
}

