/*
 * Decompiled with CFR 0.152.
 */
package cn.com.yusys.yusp.commons.autoconfigure.file;

import cn.com.yusys.yusp.commons.autoconfigure.file.FileProperties;
import cn.com.yusys.yusp.commons.autoconfigure.file.FileServerPostProcessor;
import cn.com.yusys.yusp.commons.file.server.ConnectConfig;
import cn.com.yusys.yusp.commons.file.server.fastdfs.mapper.FileFolderInfoMapper;
import cn.com.yusys.yusp.commons.file.server.fastdfs.mapper.FileInfoMapper;
import cn.com.yusys.yusp.commons.file.server.fastdfs.service.FastDfsCommandService;
import cn.com.yusys.yusp.commons.mybatis.MapperScanBasePackage;
import java.util.Arrays;
import java.util.Collections;
import org.apache.ibatis.session.SqlSession;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration(proxyBeanMethods=false)
@EnableConfigurationProperties(value={FileProperties.class})
@ConditionalOnClass(value={ConnectConfig.class})
public class FileServerAutoConfiguration {
    private static final Logger logger = LoggerFactory.getLogger(FileServerAutoConfiguration.class);
    private static final String FASTDFS_COMMAND_SERVICE_BEAN_NAME = "fastDfsCommandService";

    @Bean(value={"fastDfsCommandService"})
    @ConditionalOnClass(value={SqlSession.class})
    public FastDfsCommandService fastDfsCommandService(FileFolderInfoMapper fileFolderInfoMapper, FileInfoMapper fileInfoMapper) {
        return new FastDfsCommandService(fileFolderInfoMapper, fileInfoMapper);
    }

    @Bean
    @ConditionalOnClass(value={MapperScanBasePackage.class})
    public MapperScanBasePackage fileMapperPath() {
        return () -> Collections.unmodifiableList(Arrays.asList("cn.com.yusys.yusp.commons.file.server.fastdfs.mapper"));
    }

    @Bean
    public FileServerPostProcessor fileServerPostProcessor() {
        logger.info("fileServerPostProcessor init >>>>>> ");
        return new FileServerPostProcessor(FASTDFS_COMMAND_SERVICE_BEAN_NAME);
    }
}

